<?php
/**
* ArtBannersPlus 1.5.1
* Joomla Component
* Bernardino Porcaro
* www.dinoporcaro.it
* bporcaro@gmail.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @package ArtBannersPlus
* ArtBannersPlus! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_artbannersplus' ))) {
  mosRedirect( 'index2.php', _NOT_AUTH );
}

define ('BANNER_IN_ATTIVAZIONE', 1);
define ('BANNER_ATTIV0', 2);
define ('BANNER_TERMINATO', 3);
define ('BANNER_NON_PUBBLICATO', 4);

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

// includi il file delle lingue solo se non si tratta di salvare il file delle
// lingue e/o cambiare la lingua
if ($task != 'save_language' && $task != 'publish_language') {
  $artbannerslanguage = $mosConfig_lang;

  if (file_exists($mosConfig_absolute_path.'/administrator/components/com_artbannersplus/config.artbannersplus.php')) {
    include_once $mosConfig_absolute_path.'/administrator/components/com_artbannersplus/config.artbannersplus.php';
  }

  if (!file_exists($mosConfig_absolute_path.'/components/com_artbannersplus/language/'.$artbannerslanguage.'.php')) {
    $artbannerslanguage = 'english';
  }

  include_once ($mosConfig_absolute_path.'/components/com_artbannersplus/language/'.$artbannerslanguage.'.php');
}

// in caso di edit_language oppure publish_language cid contiene
// una stringa
if ($task == 'edit_language' ||  $task == 'publish_language') {
   $cid = mosGetParam( $_POST, 'cid', '' );
} else {
  /* Joomla 1.0.11 */
  $cid = josGetArrayInts( 'cid' );
}

switch ($task) {
// OTHER EVENTS

  case 'importartbanners':
    importArtBanners( $option );
    break;

  case 'importbanners':
    importJoomlaBanners( $option );
    break;

  case 'information':
    showInformation( $option );
    break;

  case 'cancel_language':
    mosRedirect( "index2.php?option=$option&task=langmanager" );
    break;

  case 'langmanager':
    viewLanguages( $option );
    break;

  case 'edit_language':
    editLanguageSource( $cid[0], $option );
    break;

  case 'save_language':
    saveLanguageSource( $option );
    break;

  case 'publish_language':
    publishLanguage( $cid[0], $option );
    break;


// CATEGORY EVENTS

  case 'newcategory':
    editCategory( 0, $option );
    break;

  case 'editcategory':
    editCategory( $cid[0], $option );
    break;

  case 'cancelcategory':
    cancelEditCategory( $option );
    break;

  case 'savecategory':
    saveCategory( $option );
    break;

  case 'removecategory':
    removeCategories( $cid, $option );
    break;

  case 'publishcategory':
    publishCategories( $cid, 1 );
    break;

  case 'unpublishcategory':
    publishCategories( $cid, 0 );
    break;

  case 'categories':
    viewCategories( $option );
    break;

// CLIENT EVENTS

  case 'newclient':
    editClient( 0, $option );
    break;

  case 'editclient':
    editClient( $cid[0], $option );
    break;

  case 'cancelclient':
    cancelEditClient( $option );
    break;

  case 'saveclient':
    saveClient( $option );
    break;

  case 'removeclients':
    removeClients( $cid, $option );
    break;

  case 'unpublishclient':
     publishClient( $cid, 0 );
    break;

  case 'publishclient':
    publishClient( $cid, 1 );
    break;

  case 'clients':
    viewBannerClients( $option );
    break;

// BANNER EVENTS

  case 'newbanner':
    editBanner( 0, $option);
    break;

  case 'editbanner':
    editBanner( $cid[0], $option);
    break;

  case 'cancelbanner':
    cancelEditBanner( $option );
    break;

  case 'applybanner':
  case 'savebanner':
  case 'resethits':
    saveBanner( $option, $task);
    break;

  case 'removebanners':
    removeBanner( $cid, $option);
    break;

  case 'publishbanner':
    publishBanner( $cid, 1, $option);
    break;

  case 'unpublishbanner':
    publishBanner( $cid, 0, $option);
    break;

  case 'banners':
    viewBanners( $option );
    break;

  case 'backup':
    doBackup();
    break;

  case 'restore':
    restore( $option );
    break;

  case 'dorestore':
    doRestore( $option );
    break;

  default:
    cPanel( $option );
    break;
}

function cPanel( $option ) {
  global $database;

  $info_banner = array();
  $info_categories = array();
  $info_clients = array();

  $artbannersplus = new mosArtBanner( $database );
  $client = new mosArtBannerClient( $database );
  $category = new mosArtCategory( $database );

  $date = mosCurrentDate("%Y-%m-%d");
  $time = mosCurrentDate("%H:%M:%S");

  $info_banner['attivi'] = $artbannersplus->iCountAttivi($date, $time);
  $info_banner['terminati'] = $artbannersplus->iCountTerminati($date);
  $info_banner['non_publ'] = $artbannersplus->iCountNonPubblicati();
  $info_banner['in_attiv'] = $artbannersplus->iCountInAttivazione($date);

  $info_clients['attivi'] = $client->iCountAttivi();
  $info_clients['non_publ'] = $client->iCountNonPubblicati();

  $info_categories['attivi'] = $category->iCountAttivi();
  $info_categories['non_publ'] = $category->iCountNonPubblicati();

  HTML_banners::cPanel( $info_banner, $info_clients, $info_categories, $option );
}

function changeLanguage( $link, $option, $traduzione ) {
  global $database;

  $database->setQuery( "UPDATE #__components"
  ."\n SET name = '$traduzione', admin_menu_alt = '$traduzione'"
  ."\n WHERE `option` = '$option' and admin_menu_link = '$link' "
  ."\n and trim(link) = ''");
  if (!$database->query()) {
    echo $database->stderr();
  }
}

function viewLanguages( $option ) {
  global $artbannerslanguage, $mosConfig_absolute_path;

  // Read the template dir to find templates
  $languageBaseDir = mosPathName(mosPathName($mosConfig_absolute_path) . '/components/com_artbannersplus/language/');

  $languageFiles = mosReadDirectory( $languageBaseDir );

  $bFound = false;
  $languages = array();
  for($i = 0, $count = count($languageFiles); $i < $count; $i++) {

    $row = new StdClass();
    $row->language = substr($languageFiles[$i],0, strlen($languageFiles[$i]) - 4);
    $row->published = false; // default

    if ($row->language == $artbannerslanguage) {
      $row->published = true; // selezionato
      $bFound = true;
    }

    $languages[] = $row;
  }

  // se  non trovo la lingua selezionata, e c'e' inglese seleziono
  // l'inglese
  if (!$bFound) {
    for($i = 0, $count = count($languages); $i < $count; $i++) {
      if ($languages[$i]->language == 'english') {
        $languages[$i]->published = true;
      }
    }
  }

  HTML_languages::showLanguages( $artbannerslanguage, $languages, $option );
}

function editLanguageSource( $language, $option ) {

  $file = stripslashes( "../components/com_artbannersplus/language/$language.php" );

  if ($fp = fopen( $file, "r" )) {
    $content = fread( $fp, filesize( $file ) );
    $content = htmlspecialchars( $content );

    HTML_languages::editLanguageSource( $language, $content, $option );
  } else {
    //$msg="Operazione fallita: Impossibile aprire  $file";
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error');
  }
}

function saveLanguageSource( $option ) {
  global $mosConfig_live_site, $mosConfig_absolute_path;

  $language = mosGetParam( $_POST, 'language', '' );
  $filecontent = mosGetParam( $_POST, 'filecontent', '', _MOS_ALLOWHTML );

  if (!$language || $language == '') {
    //$msg = 'Operazione fallita: Nessuna lingua specificata.';
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error' );
  }

  if (!$filecontent || empty($filecontent) || trim($filecontent) == '') {
    //$msg = 'Operazione fallita: Contenuto vuoto.';
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error' );
  }

  $file = "../components/com_artbannersplus/language/$language.php";

  clearstatcache();
  if (is_writable( $file ) == false) {
    //$msg = 'Operazione fallita: File non scrivibile.';
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error' );
  }

  if ($fp = fopen ($file, "w")) {

    fputs( $fp, stripslashes( $filecontent ) );
    fclose( $fp );

    mosRedirect( "index2.php?option=$option&task=langmanager" );
  } else {
    //$msg = 'Operazione fallita: Apertura file per la scrittura non possibile.';
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error' );
  }
}

function publishLanguage( $artbannerslanguage, $option ) {
  global $mosConfig_live_site, $mosConfig_absolute_path;

  $file = $mosConfig_absolute_path.'/administrator/components/com_artbannersplus/config.artbannersplus.php';

  if (is_writable( $file ) == false) {
    //$msg = 'Operazione fallita: File di configurazione non scrivibile.';
    mosRedirect( "index2.php?option=$option&task=langmanager", 'Error' );
  }

  if ($fp = fopen ($file, "w")) {
    $filecontent = "<?php \n" .
                   " // ensure this file is being included by a parent file \n" .
                   "defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );\n\n" .
                   "\$artbannerslanguage = '".$artbannerslanguage."';\n" .
                   "?>\n";

    fputs( $fp, $filecontent );
    fclose( $fp );

    if (!file_exists($mosConfig_absolute_path.'/components/com_artbannersplus/language/'.$artbannerslanguage.'.php')) {
      $artbannerslanguage = 'english';
    }

    include_once ($mosConfig_absolute_path.'/components/com_artbannersplus/language/'.$artbannerslanguage.'.php');

    changeLanguage("option=com_artbannersplus&task=information","com_artbannersplus", _ABP_INFORMATION);
    changeLanguage("option=com_artbannersplus&task=banners","com_artbannersplus", _ABP_BANNER_MANAGER);
    changeLanguage("option=com_artbannersplus&task=clients","com_artbannersplus", _ABP_BANNER_CLIENT_MANAGER);
    changeLanguage("option=com_artbannersplus&task=categories","com_artbannersplus", _ABP_BANNER_CATEGORY_MANAGER);
    changeLanguage("option=com_artbannersplus","com_artbannersplus", _ABP_CONTROL_PANEL);
    changeLanguage("option=com_artbannersplus&task=importartbanners","com_artbannersplus", _ABP_IMPORT_ARTBANNER);
    changeLanguage("option=com_artbannersplus&task=importbanners","com_artbannersplus", _ABP_IMPORT_JOOMLA_BANNER);
    changeLanguage("option=com_artbannersplus&task=langmanager","com_artbannersplus", _ABP_LANGUAGE_MANAGER);

    mosRedirect("index2.php?option=$option&task=langmanager"); //,"Lingua modificata correttamente! $p_lname");
  }

  mosRedirect("index2.php?option=$option&task=langmanager",'Error!');
}

function importJoomlaBanners( $option ) {
  global $database;

  // leggo le info dei banner da importare
  $query = 'SELECT count(*) FROM #__banner';
  $database->setQuery($query);
  $artbanners_number = @$database->loadResult();
  if ($database->getErrorNum()) {
    mosRedirect( "index2.php?option=$option", _ABP_NOT_EXIST_BANNER_RESTORE );
  }  else if (!$artbanners_number)  {
    mosRedirect( "index2.php?option=$option", _ABP_NOT_EXIST_BANNER_RESTORE );
  }

  // inserisco una categoria fittizia per i banner del core
  $query = "insert into #__artbannersplus_categories
            (name, description, published)
            VALUES ('Banners joomla core', 'Banners core joomla', 1)";
  $database->setQuery($query);
  if (!$database->query()) {
    echo $database->stderr();
    return false;
  }

  // memorizzo il nuovo ID della categoria
  $new_tid = $database->insertid();

  // leggo le info dei banner da importare
  $query = 'SELECT * FROM #__banner';
  $database->setQuery($query);
  if (($banners_array = $database->loadObjectList()) === null) {
    echo $database->stderr();
    return false;
  }

  $clienti_inserti = array();

  $num_clienti_inseriti = 0;
  $num_banner_inseriti = 0;

  // per ogni banner che si vuole importare
  foreach ($banners_array as $banner)
  {
    if (!in_array($banner->cid, $clienti_inserti ))
    {
      // leggo le info del cliente da importare
      $query = 'SELECT * FROM #__bannerclient where cid = '.$banner->cid;
      $database->setQuery($query);
      if (($bannerclients = $database->loadObjectList()) === null) {
        echo $database->stderr();
        return false;
      }

      if (count($bannerclients) == 0) {
        continue;
      }

      foreach ($bannerclients as $bannersclient)
      {
        $artbannersclientsplus = new mosArtBannerClient($database);

        $artbannersclientsplus->name      = $bannersclient->name;
        $artbannersclientsplus->contact   = $bannersclient->contact;
        $artbannersclientsplus->email     = $bannersclient->email;
        $artbannersclientsplus->extrainfo = $bannersclient->extrainfo;
        $artbannersclientsplus->published = 1;

        // salvo il cliente
        $artbannersclientsplus->store();

        // memorizzo il nuovo ID del cliente
        $new_cid = $database->insertid();

        $num_clienti_inseriti++;
      }

      $clienti_inserti[] = $bannersclient->cid;
    }

    $artbannersplus = new mosArtBanner($database);

    $artbannersplus->cid                = $new_cid;
    $artbannersplus->tid                = $new_tid;
    $artbannersplus->type               = $banner->type;
    $artbannersplus->name               = $banner->name;
    $artbannersplus->imp_total          = $banner->imptotal;
    $artbannersplus->imp_made           = $banner->impmade;
    $artbannersplus->clicks             = $banner->clicks;
    $artbannersplus->image_url          = $banner->imageurl;
    $artbannersplus->click_url          = $banner->clickurl;
    $artbannersplus->last_show          = $banner->date;
    $artbannersplus->custom_banner_code = $banner->custombannercode;
    $artbannersplus->state              = $banner->showBanner;
    $artbannersplus->complete_clicks    = $banner->clicks;
    $artbannersplus->publish_up_date    = mosCurrentDate("%Y-%m-%d");

    // salvo il banner
    $artbannersplus->store();

    $num_banner_inseriti++;
  }

  $msg = _ABP_IMPORT_OK;
  $msg .= ' Clienti inseriti ' . $num_clienti_inseriti . ' Banner inseriti '. $num_banner_inseriti;

  mosRedirect( "index2.php?option=$option&catid=0&cliid=0", $msg );
}

function importArtBanners( $option ) {
  global $database;

  // leggo le info dei banner da importare
  $query = 'SELECT count(*) FROM #__artbanners';
  $database->setQuery($query);
  $artbanners_number = @$database->loadResult();
  if ($database->getErrorNum()) {
    mosRedirect( "index2.php?option=$option", 'non ci sono banners artbanners' );
  }  else if (!$artbanners_number)  {
    mosRedirect( "index2.php?option=$option", 'non ci sono banners artbanners' );
  }

  // leggo le info dei banner da importare
  $query = 'SELECT * FROM #__artbanners';
  $database->setQuery($query);
  if (($artbanners_array = $database->loadObjectList()) === null) {
    echo $database->stderr();
    return false;
  }

  $clienti_inserti = array();
  $categorie_inserte = array();

  $num_clienti_inseriti = 0;
  $num_banner_inseriti = 0;
  $num_categorie_inserite = 0;

  // per ogni banner che si vuole importare
  foreach ($artbanners_array as $artbanners)
  {
    if (!in_array($artbanners->cid, $clienti_inserti ))
    {
      // leggo le info del cliente da importare
      $query = 'SELECT * FROM #__artbanners_clients where cid = '.$artbanners->cid;
      $database->setQuery($query);
      if (($artbannersclients = $database->loadObjectList()) === null) {
        echo $database->stderr();
        return false;
      }

      if (count($artbannersclients) == 0) {
        continue; // scarto il banner e cliente
      }

      foreach ($artbannersclients as $artbannersclient)
      {
        $artbannersclientsplus = new mosArtBannerClient($database);

        $artbannersclientsplus->name      = $artbannersclient->name;
        $artbannersclientsplus->contact   = $artbannersclient->contact;
        $artbannersclientsplus->email     = $artbannersclient->email;
        $artbannersclientsplus->extrainfo = $artbannersclient->extrainfo;
        $artbannersclientsplus->published = $artbannersclient->published;

        // salvo il cliente
        $artbannersclientsplus->store();

        // memorizzo il nuovo ID del cliente
        $new_cid = $database->insertid();

        $num_clienti_inseriti++;
      }

      $clienti_inserti[] = $bannersclient->cid;
    }

    if (!in_array($artbanners->tid, $categorie_inserte ))
    {

      // leggo le info della categoria
      $query = 'SELECT * FROM #__artbanners_categories where id = '.$artbanners->tid;
      $database->setQuery($query);
      if (($artbannerscategoiries = $database->loadObjectList()) === null) {
        echo $database->stderr();
        return false;
      }

      foreach ($artbannerscategoiries as $artbannerscategory)
      {
        $artbannerscategoiriesplus = new mosArtCategory($database);

        $artbannerscategoiriesplus->name        = $artbannerscategory->name;
        $artbannerscategoiriesplus->description = $artbannerscategory->description;
        $artbannerscategoiriesplus->published   = $artbannerscategory->published;

        // salvo il cliente
        $artbannerscategoiriesplus->store();

        // memorizzo il nuovo ID del cliente
        $new_tid = $database->insertid();

        $num_categorie_inserite++;
      }
      $categorie_inserte[] = $artbanners->tid;
    }

    $artbannersplus = new mosArtBanner($database);

    $artbannersplus->cid                = $new_cid;
    $artbannersplus->tid                = $new_tid;
    $artbannersplus->type               = $artbanners->type;
    $artbannersplus->name               = $artbanners->name;
    $artbannersplus->imp_total          = $artbanners->imp_total;
    $artbannersplus->imp_made           = $artbanners->imp_made;
    $artbannersplus->clicks             = $artbanners->clicks;
    $artbannersplus->image_url          = $artbanners->image_url;
    $artbannersplus->click_url          = $artbanners->click_url;
    $artbannersplus->last_show          = $artbanners->last_show;
    $artbannersplus->msec               = $artbanners->msec;
    $artbannersplus->state              = $artbanners->state;
    $artbannersplus->reccurtype         = $artbanners->reccurtype;
    $artbannersplus->reccurweekdays     = $artbanners->reccurweekdays;
    $artbannersplus->custom_banner_code = $artbanners->custom_banner_code;
    $artbannersplus->access             = $artbanners->access;
    $artbannersplus->target             = $artbanners->target;
    $artbannersplus->border_value       = $artbanners->border_value;
    $artbannersplus->border_style       = $artbanners->border_style;
    $artbannersplus->border_color       = $artbanners->border_color;
    $artbannersplus->click_value        = $artbanners->click_value;
    $artbannersplus->complete_clicks    = $artbanners->complete_clicks;
    $artbannersplus->imp_value          = $artbanners->imp_value;
    $artbannersplus->publish_up_date    = substr($artbanners->publish_up,0,10);
    $artbannersplus->publish_up_time    = substr($artbanners->publish_up,12);
    $artbannersplus->publish_down_date  = substr($artbanners->publish_down,0,10);
    $artbannersplus->publish_down_time  = substr($artbanners->publish_down,12);

    // salvo il banner
    $artbannersplus->store();

    // memorizzo il nuovo ID del banner
    $new_artbannersplus_id = $database->insertid();

    $num_banner_inseriti++;
  }

  $msg = _ABP_IMPORT_OK;
  $msg .= ' Clienti inseriti ' . $num_clienti_inseriti .
          ' Banner inseriti '. $num_banner_inseriti .
          ' Categorie inserite '. $num_categorie_inserite;

  mosRedirect( "index2.php?option=$option&catid=0&cliid=0", $msg );
}

function viewBanners( $option ) {
  global $database, $mainframe, $mosConfig_list_limit;

  $limit = intval($mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit ));
  $limitstart = intval($mainframe->getUserStateFromRequest( "view{$option}bannerslimitstart", 'limitstart', 0 ));
  $catid = intval($mainframe->getUserStateFromRequest( "category{$option}id", 'catid', 0 ));
  $cliid = intval($mainframe->getUserStateFromRequest( "client{$option}id", 'cliid', 0 ));
  $stateid = intval($mainframe->getUserStateFromRequest( "state{$option}id", 'stateid', 0 ));

  // get the total number of records
  $database->setQuery( 'SELECT count(*) FROM #__artbannersplus' );
  if (($total = $database->loadResult()) === null) {
    echo $database->stderr();
    return false;
  }

  require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
  $pageNav = new mosPageNav( $total, $limitstart, $limit );

  $where = '';
  if ($catid > 0) {
    $where = " AND a.tid = '$catid' ";
  }

  if ($cliid > 0) {
    $where .= " AND a.cid = '$cliid' ";
  }

  $date = mosCurrentDate("%Y-%m-%d");
  if ($stateid == 1) { // ATTIVI
    $where  .= " AND ('$date' <= publish_down_date OR publish_down_date = '0000-00-00')
                 AND '$date' >= publish_up_date
                 AND state = '1' ";
  }  else if ($stateid == 2) { // TERMINATI
    $where .= " AND imp_made = imp_total
                AND '$date' > publish_down_date ";

  } else if ($stateid == 3) { // NON PUBBLICATI
    $where .= " AND state = '0' ";
  } else if ($stateid == 4) { // IN ATTIVAZIONE
    $where .= " AND '$date' < publish_up_date
                AND state = '1' ";
  }

  $query = "SELECT a.*, u.name AS editor, "
  . "\n c.name as category, c.published as cat_pub, cl.published as cl_pub, "
  . "\n cl.name as cl_name"
  . "\n FROM #__artbannersplus AS a"
  . "\n LEFT JOIN #__users AS u ON u.id = a.checked_out"
  . "\n LEFT JOIN #__artbannersplus_categories AS c ON c.id = a.tid"
  . "\n LEFT JOIN #__artbannersplus_clients AS cl ON cl.cid = a.cid"
  . "\n WHERE 1 $where"
  . "\n ORDER BY c.name, a.name";
  $database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );

  if (($banners = $database->loadObjectList()) === null) {
    echo $database->stderr();
    return false;
  }

  // get list of categories
  $query = 'SELECT id AS value, name AS text FROM #__artbannersplus_categories ORDER BY name';
  $database->setQuery($query);
  if (!$database->query()) {
    echo $database->stderr();
    return false;
  }

  // Build Categories select list
  $categories[] = mosHTML::makeOption( '-1', _ABP_ALLCAT );
  $categories = array_merge( $categories, $database->loadObjectList() );
  $categorieslist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
                                'value', 'text', $catid );

  // get list of clients
  $query  = 'SELECT cid as value, name as text FROM #__artbannersplus_clients ORDER BY name';
  $database->setQuery($query);
  if (!$database->query()) {
    echo $database->stderr();
    return false;
  }
  // Build Client select list
  $clients[] = mosHTML::makeOption( '-1', _ABP_ALLCLI );
  $clients = array_merge( $clients, $database->loadObjectList() );
  $clientlist = mosHTML::selectList( $clients, 'cliid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
                                     'value', 'text', $cliid );


  // Build States select list
  $states[] = mosHTML::makeOption( '0', _ABP_BANNERS_ALL );
  $states[] = mosHTML::makeOption( '1', _ABP_BANNERS_ATT );
  $states[] = mosHTML::makeOption( '2', _ABP_BANNERS_TER );
  $states[] = mosHTML::makeOption( '3', _ABP_BANNERS_NO_PUB );
  $states[] = mosHTML::makeOption( '4', _ABP_BANNERS_IN_ATT );
  $stateslist = mosHTML::selectList( $states, 'stateid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
                                     'value', 'text', $stateid );


  HTML_banners::showBanners( $banners, $categorieslist, $clientlist, $stateslist, $pageNav, $option );
}

function editBanner( $bannerid, $option ) {
  global $database, $mainframe, $my;

  $banner = new mosArtBanner($database);

  if ($bannerid) {
    // load the row from the db table
    if (!$banner->load( $bannerid )) {
      echo $database->stderr();
      return false;
    }

    // fail if checked out not by 'me'
    if ($banner->checked_out && $banner->checked_out != $my->id) {
      mosRedirect( "index2.php?option=$option&task=banners",
      sprintf(_ABP_BANNER_IN_USE,$banner->name) );
    }
  }

  // get list of clients
  $query  = 'SELECT cid as value, name as text FROM #__artbannersplus_clients ORDER BY name';
  $database->setQuery($query);
  if (!$database->query()) {
    echo $database->stderr();
    return false;
  }

  if ($database->getNumRows() == 0) {
    $msg = 'Non ci sono clienti, inserisci prima il cliente';
    mosRedirect( "index2.php?option=$option&task=clients", $msg);
  }

  // Build Client select list
  $clients[] = mosHTML::makeOption( '0', _ABP_SELECT_CLIENT );
  $clients = array_merge( $clients, $database->loadObjectList() );
  $clientlist = mosHTML::selectList( $clients,  'cid', 'class="inputbox" size="1"','value', 'text', $banner->cid);

  // get list of categories
  $query = 'SELECT id AS value, name AS text FROM #__artbannersplus_categories ORDER BY name';
  $database->setQuery($query);
  if (!$database->query()) {
    echo $database->stderr();
    return false;
  }

  if ($database->getNumRows() == 0) {
    $msg = 'Non ci sono categorie, inserisci prima la categoria';
    mosRedirect( "index2.php?option=$option&task=categories", $msg);
  }

  // Build Categories select list
  $categories[] = mosHTML::makeOption(  '0', _ABP_SELECT_CATEGORY );
  $categories = array_merge( $categories, $database->loadObjectList() );
  $categorieslist = mosHTML::selectList( $categories, 'tid', 'class="inputbox" size="1"','value', 'text', $banner->tid);

  // Imagelist
  // get list of images
  $dimension = array();
  $imgFiles = mosReadDirectory( $mainframe->getCfg( 'absolute_path' ) . '/images/banners' );
  $images = array();
  $images[] = mosHTML::makeOption( '', _ABP_PSANIMG );
  foreach ($imgFiles as $file) {
    if (eregi( "(\.bmp|\.gif|\.jpg|\.jpeg|\.png|\.swf)$", $file)) {
      $images[] = mosHTML::makeOption( $file );
      // get image info
      $image_info = @getimagesize( $mainframe->getCfg( 'absolute_path' ) . 'images/banners/' .$file);
      $dimension[$file]['w'] = $image_info[0];
      $dimension[$file]['h'] = $image_info[1];
    }
  }

  $ilist = mosHTML::selectList( $images, 'image_url', "class=\"inputbox\" size=\"1\" onchange=\"changeDisplayImage(1);\"" ,
                                'value', 'text', $banner->image_url );

  // get list of groups
  $database->setQuery( 'SELECT id AS value, name AS text FROM #__groups ORDER BY id' );
  if (!($groups = $database->loadObjectList())) {
    echo $database->stderr();
    return false;
  }

  // build the html select list
  $glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"',
                                'value', 'text', intval( $banner->access ) );

  if ($bannerid) {
    // edit banner esistente
    $banner->checkout( $my->id );

    if ( $banner->publish_down_date == '0000-00-00') {
      $banner->publish_down_date = _ABP_NEVER;
    }

    $event_up = new mosArtBannersTime( $banner->publish_up_time );
    $banner->publish_up_hour = $event_up->hour;
    $banner->publish_up_minute = $event_up->minute;

    $event_down = new mosArtBannersTime( $banner->publish_down_time);
    $banner->publish_down_hour = $event_down->hour;
    $banner->publish_down_minute = $event_down->minute;
  } else {
    // nuovo banner
    $banner->publish_up_date = mosCurrentDate("%Y-%m-%d");
    $banner->publish_down_date = _ABP_NEVER;
    $banner->publish_up_hour = '00';
    $banner->publish_up_minute = '00';
    $banner->publish_down_hour = '00';
    $banner->publish_down_minute = '00';

    $banner->dta_mod_clicks = mosCurrentDate("%Y-%m-%d");
  }

  HTML_banners::editBanner( $banner, $clientlist, $categorieslist, $ilist, $glist, $option, $dimension );
}

function saveBanner( $option, $task ) {
  global $database;

  $_publish_up_date = trim( mosGetParam( $_POST, '_publish_up_date', '0000-00-00' ) );
  $_publish_up_hour= trim( mosGetParam( $_POST, '_publish_up_hour', '00' ) );
  $_publish_up_minute = trim( mosGetParam( $_POST, '_publish_up_minute', '00' ) );
  $_publish_down_date = trim( mosGetParam( $_POST, '_publish_down_date', '0000-00-00' ) );
  $_publish_down_hour= trim( mosGetParam( $_POST, '_publish_down_hour', '00' ) );
  $_publish_down_minute = trim( mosGetParam( $_POST, '_publish_down_minute', '00' ) );
  $reccurweekdays = mosGetParam( $_POST, 'reccurweekdays', '' );
  $send_email = mosGetParam( $_POST, 'send_email', '' );

  $banner = new mosArtBanner($database);

  if (!$banner->bind( $_POST )) {
    mosErrorAlert($banner->getError());
  }

  $msg = '';

  // Resets clicks when `Reset Clicks` button is used instead of `Save` button
  if ( $task == 'resethits' ) {
    $banner->clicks = 0;
    $msg = 'Resettato click parziali banner';
    $banner->dta_mod_clicks = mosCurrentDate("%Y-%m-%d");
  } else if ($banner->dta_mod_clicks == '0000-00-00') {
    $banner->dta_mod_clicks = mosCurrentDate("%Y-%m-%d");
  }

  // assemble the starting time
  if (intval( $_publish_up_date ) && $_publish_up_date != '0000-00-00') {
    $banner->publish_up_date = $_publish_up_date;

    // verifica formalita' della data inizio
    if (ereg( "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})", $banner->publish_up_date, $regs )) {
      if (!checkdate($regs[2], $regs[3], $regs[1])) {
        mosErrorAlert('Data inizio pubblicazione non valida');
      }
    } else {
      mosErrorAlert('Data inizio pubblicazione non valida');
    }
  } else {
    $banner->publish_up_date = mosCurrentDate("%Y-%m-%d");
  }

  $banner->publish_up_time =  "$_publish_up_hour:$_publish_up_minute:00";

  if (ereg( "([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $banner->publish_up_time, $regs )) {
    if ($regs[1] > 24 || $regs[2] > 60 || $regs[3] > 60) {
      mosErrorAlert('Ora inizio pubblicazione non valida');
    }
  } else {
    mosErrorAlert('Ora inizio pubblicazione non valida');
  }

  // assemble the finishing time
  if (intval($_publish_down_date) && $_publish_down_date != '0000-00-00') {
    $banner->publish_down_date = $_publish_down_date;

    // verifica formalita' della data fine
    if (ereg( "([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})", $banner->publish_down_date, $regs )) {
      if (!checkdate($regs[2], $regs[3], $regs[1])) {
        mosErrorAlert('Data fine pubblicazione non valida');
      }
    } else {
      mosErrorAlert('Data fine pubblicazione non valida');
    }

  } else {
    $banner->publish_down_date = '0000-00-00';
  }

  $banner->publish_down_time = "$_publish_down_hour:$_publish_down_minute:00";

  if (ereg( "([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $banner->publish_down_time, $regs )) {
    if ($regs[1] > 24 || $regs[2] > 60 || $regs[3] > 60) {
      mosErrorAlert('Ora fine pubblicazione non valida');
    }
  } else {
    mosErrorAlert('Ora fine pubblicazione non valida');
  }

  // Verifico se la data fine e' piu' grande della data inizio
  if ($banner->publish_down_date != '0000-00-00' &&
      $banner->publish_up_date > $banner->publish_down_date) {
    mosErrorAlert(_ABP_BN_DATE);
  }

  if ($banner->publish_up_date != $banner->publish_down_date) {
    $banner->reccurtype = intval( $banner->reccurtype );
  } else {
    $banner->reccurtype = 0;
  }

  // Reccur week days
  if ($banner->reccurtype != 0 && is_array($reccurweekdays)) {
    $banner->reccurweekdays = implode( ',', $reccurweekdays );
  }

  if (!$banner->check()) {
    mosErrorAlert($banner->getError());
  }

  if (!$banner->store()) {
    mosErrorAlert($banner->getError());
  }

  $banner->checkin();

  if ($send_email == 'on') {
    $client = new mosArtBannerClient( $database );
    if ($client->load($banner->cid)) {

      global $mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_live_site;
      $link = $mosConfig_live_site . '/index.php?option=com_artbannersplus&task=statistics&id='.$banner->id.'&password='.mosHash($banner->password);
      $result = mosMail( $mosConfig_mailfrom, $mosConfig_fromname, $client->email, _ABP_SUBJECT_MAIL, _ABP_BODY_MAIL.$link);

      if ($result === false)
        $msg .= ' '. _ABP_ERROR_SEND_MAIL;
    }
  }

  $catid = intval(mosGetParam($_REQUEST, 'catid', 0));
  $cliid = intval(mosGetParam($_REQUEST, 'cliid', 0));

  $catid = ($catid > 0)? '&catid='.$catid:'';
  $cliid = ($cliid > 0)? '&cliid='.$cliid:'';

  if ($task == 'applybanner') {
    mosRedirect( "index2.php?option=$option".$catid.$cliid."&task=editbanner&cid[]=".$banner->id, $msg );
  } else {
    mosRedirect( "index2.php?option=$option&task=banners".$catid.$cliid, $msg );
  }
}

function cancelEditBanner( $option ) {
  global $database;
  $banner = new mosArtBanner($database);
  $banner->bind( $_POST );
  $banner->checkin();

  $catid = intval(mosGetParam($_REQUEST, 'catid', 0));
  $cliid = intval(mosGetParam($_REQUEST, 'cliid', 0));

  $catid = ($catid > 0)? '&catid='.$catid:'';
  $cliid = ($cliid > 0)? '&cliid='.$cliid:'';

  mosRedirect( "index2.php?option=$option&task=banners".$catid.$cliid  );
}

function publishBanner( $cid, $publish=1, $option ) {
  global $database, $my;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    $action = $publish ? _ABP_L_PUBLISH : _ABP_L_UNPUBLISH;
    mosErrorAlert(sprintf(_ABP_SELECT_ITEM_TO,$action));
  }

  $cids = implode( ',', $cid );

  $date = mosCurrentDate("%Y-%m-%d");

  $database->setQuery( "UPDATE #__artbannersplus SET state='$publish'"
  . "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='(int)$my->id'))"
  . "\nand ('$date' <= publish_down_date or publish_down_date = '0000-00-00')"
  );

  if (!$database->query()) {
    mosErrorAlert($database->getErrorMsg());
  }

  if (count( $cid ) == 1) {
    $banner = new mosArtBanner( $database );
    $banner->checkin( $cid[0] );
  }

  $catid = intval(mosGetParam($_REQUEST, 'catid', 0));
  $cliid = intval(mosGetParam($_REQUEST, 'cliid', 0));

  $catid = ($catid > 0)? '&catid='.$catid:'';
  $cliid = ($cliid > 0)? '&cliid='.$cliid:'';

  mosRedirect( "index2.php?option=$option&task=banners".$catid.$cliid );
}

function removeBanner( $cid, $option ) {
  global $database, $my;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    mosErrorAlert(_ABP_PSACLI);
  }

  $msg = '';

  $banner = new mosArtBanner( $database );

  for($i = 0, $count = count($cid); $i < $count; $i++) {
    $cids = $cid[$i];
    if ($banner->load( $cids )) {
      if ($banner->checked_out && $banner->checked_out != $my->id) {
        $msg .= sprintf(_ABP_BANNER_IN_USE,$banner->name) .'<br>';
      } else {
        $database->setQuery( "DELETE FROM #__artbannersplus WHERE id = $cids" );
        if (!$database->query()) {
          mosErrorAlert($database->stderr());
        }
      }
    }
  }

  $catid = intval(mosGetParam($_REQUEST, 'catid', 0));
  $cliid = intval(mosGetParam($_REQUEST, 'cliid', 0));

  $catid = ($catid > 0)? '&catid='.$catid:'';
  $cliid = ($cliid > 0)? '&cliid='.$cliid:'';

  mosRedirect( "index2.php?option=$option&task=banners".$catid.$cliid, $msg);
}

/*
** ---------- BANNER CLIENTS ----------
*/

function viewBannerClients( $option ) {
  global $database, $mainframe, $my, $mosConfig_list_limit;

  $limit = intval($mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit ));
  $limitstart = intval($mainframe->getUserStateFromRequest( "view{$option}clientslimitstart", 'limitstart', 0 ));
  $published = $mainframe->getUserStateFromRequest( "published{$option}", 'published', -1 );

  // get the total number of records
  $database->setQuery( 'SELECT count(*) FROM #__artbannersplus_clients' );
  if(($total = $database->loadResult()) === null) {
    echo $database->stderr();
    return false;
  }

  $weekday = mosCurrentDate("%w");
  $date = mosCurrentDate("%Y-%m-%d");
  $time = mosCurrentDate("%H:%M:%S");

  require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
  $pageNav = new mosPageNav( $total, $limitstart, $limit );

  $where = '';
  if ($published != -1) {
    $published = intval($published);
    $where = " where a.published  = $published ";
  }

  $query = "SELECT a.*, count(b.id) AS id, u.name AS editor"
  . "\nFROM #__artbannersplus_clients AS a"
  . "\nLEFT JOIN #__artbannersplus AS b ON a.cid = b.cid"
  . "\nLEFT JOIN #__users AS u ON u.id = a.checked_out"
  . "\n $where "
  . "\nGROUP BY a.cid";
  $database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );

  if (($clients = $database->loadObjectList()) === null) {
    echo $database->stderr();
    return false;
  }

  $info_banner = array();
  for ($i=0, $n=count( $clients ); $i < $n; $i++) {

    $cid = $clients[$i]->cid;

    /*
    ** Conta i banner attivi del cliente
    */
    $sql = "SELECT count(b.id) as attivi"
    . "\nFROM #__artbannersplus_clients as c, #__artbannersplus as b"
    . "\nwhere c.cid = $cid and b.cid = c.cid and b.state = 1"
    . "\nAND ('$date' <= b.publish_down_date OR b.publish_down_date = '0000-00-00')"
    . "\nAND '$date' >= b.publish_up_date";

    $database->setQuery($sql);
    if (($result = $database->loadResult()) === null) {
      echo $database->stderr();
      return false;
    }

    $info_banner[$i]['attivi'] = (int)$result;

    /*
    ** Conta i banner terminati del cliente
    */
    $sql = "SELECT count(b.id) as terminati"
    . "\nFROM #__artbannersplus_clients as c, #__artbannersplus as b"
    . "\nwhere c.cid = $cid and b.cid = c.cid and b.state = 1"
    . "\nAND  '$date' >= b.publish_down_date and b.publish_down_date != '0000-00-00'";

    $database->setQuery($sql);
    if (($result = $database->loadResult()) === null) {
      echo $database->stderr();
      return false;
    }

    $info_banner[$i]['terminati'] = (int)$result;

    /*
    ** Conta i banner non_publicati del cliente
    */
    $sql = "SELECT count(b.id) as non_publ"
    . "\nFROM #__artbannersplus_clients as c, #__artbannersplus as b"
    . "\nwhere c.cid = $cid and b.cid = c.cid and b.state = 0";

    $database->setQuery($sql);
    if (($result = $database->loadResult()) === null) {
      echo $database->stderr();
      return false;
    }

    $info_banner[$i]['non_publ'] = (int)$result;

    /*
    ** Conta i banner in attivazione del cliente
    */
    $sql = "SELECT count(b.id) as in_attiv"
    . "\nFROM #__artbannersplus_clients as c, #__artbannersplus as b"
    . "\nwhere c.cid = $cid and b.cid = c.cid and b.state = 1"
    . "\nAND  '$date' < b.publish_up_date ";

    $database->setQuery($sql);
    if (($result = $database->loadResult()) === null) {
      echo $database->stderr();
      return false;
    }

    $info_banner[$i]['in_attiv'] = (int)$result;
  }

  // Build States select list
  $states[] = mosHTML::makeOption( '-1', _ABP_ALLCLI );
  $states[] = mosHTML::makeOption( '1', _ABP_BANNERS_ATT );
  $states[] = mosHTML::makeOption( '0', _ABP_BANNERS_NO_PUB );

  $stateslist = mosHTML::selectList( $states, 'published',
                                     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
                                     'value', 'text', $published );

  HTML_bannerClient::showClients( $clients, $info_banner, $my->id, $pageNav, $option, $stateslist );
}

function editClient( $clientid, $option ) {
  global $database, $my;
  $client = new mosArtBannerClient($database);

  if ($clientid) {
    // load the row from the db table
    if (!$client->load( $clientid)) {
      echo $database->stderr();
      return false;
    }

    // fail if checked out not by 'me'
    if ($client->checked_out && $client->checked_out != $my->id) {
      mosRedirect( "index2.php?option=$option&task=clients",
      sprintf(_ABP_CICBEBAA,$client->name) );
    }

    // do stuff for existing record
    $client->checkout( $my->id );
  }

  HTML_bannerClient::editClient( $client, $option );
}

function saveClient( $option ) {
  global $database;

  $client = new mosArtBannerClient( $database );

  $client->published = 1;

  if (!$client->bind( $_POST )) {
    mosErrorAlert($client->getError());
  }

  if (!$client->check()) {
    mosErrorAlert($client->getError());
  }

  if (!$client->store()) {
    mosErrorAlert($client->getError());
  }

  $client->checkin();

  mosRedirect( "index2.php?option=$option&task=clients" );
}

function publishClient( $cid=null, $publish=1 ) {
  global $database, $my;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    $action = $publish ? _ABP_SACT_PUB : _ABP_SACT_UNPUB;
    mosErrorAlert(sprintf(_ABP_SACT, $action));
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "UPDATE #__artbannersplus_clients SET published='$publish'"
  . "\nWHERE cid IN ($cids) AND (checked_out=0 OR (checked_out='(int)$my->id'))"
  );

  if (!$database->query()) {
    mosErrorAlert($database->stderr());
  }

  if (count( $cid ) == 1) {
    $category = new mosArtCategory( $database );
    $category->checkin( $cid[0] );
  }

  mosRedirect( "index2.php?option=com_artbannersplus&task=clients" );
}

function cancelEditClient( $option ) {
  global $database;
  $client = new mosArtBannerClient( $database );
  $client->bind( $_POST );
  $client->checkin();
  mosRedirect( "index2.php?option=$option&task=clients" );
}

function removeClients( $cid, $option ) {
  global $database, $my;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    mosErrorAlert(_ABP_PSACLI);
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "SELECT c.cid, c.name"
  . "\nFROM #__artbannersplus_clients AS c"
  . "\nWHERE c.cid IN ($cids)"
  . "\nGROUP BY c.cid"
  );

  if (!($rows = $database->loadObjectList())) {
    mosErrorAlert($database->stderr());
  }

  $err = array();
  $cid = array();
  foreach ($rows as $row) {

    $database->setQuery( 'SELECT count(*) from #__artbannersplus where cid = '. $row->cid);
    if(($count = $database->loadResult()) === null) {
      mosErrorAlert($database->stderr());
    }

    if ($count == 0) {
      $cid[] = $row->cid;
    } else {
      $err[] = $row->name;
    }
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__artbannersplus_clients WHERE cid IN ($cids)" );
    if (!$database->query()) {
      mosErrorAlert($database->stderr());
    }
  }

  if (count( $err )) {
    $err = implode( ',', $err );
    mosRedirect( "index2.php?option=com_artbannersplus&task=clients"
      . "&mosmsg=".urlencode(sprintf(_ABP_CDCATTATHABSR, $err)) );
  }

  mosRedirect("index2.php?option=$option&task=clients");
}

// BANNER CATEGORIES

function viewCategories( $option ) {
  global $database, $my, $mainframe, $mosConfig_list_limit;

  $limit = intval($mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit ));
  $limitstart = intval($mainframe->getUserStateFromRequest( "view{$option}categorieslimitstart", 'limitstart', 0 ));
  $published = $mainframe->getUserStateFromRequest( "published{$option}", 'published', -1 );

  // get the total number of records
  $database->setQuery( 'SELECT count(*) FROM #__artbannersplus_categories');
  if(($total = $database->loadResult()) === null) {
    echo $database->stderr();
    return false;
  }

  require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
  $pageNav = new mosPageNav( $total, $limitstart, $limit );

  $where = '';
  if ($published != -1) {
    $published = intval($published);
    $where = " where c.published  = $published ";
  }

  $query = "SELECT c.*,u.name AS editor, "
  . "\nCOUNT(DISTINCT b.id) AS banners"
  . "\nFROM #__artbannersplus_categories AS c"
  . "\nLEFT JOIN #__users AS u ON u.id = c.checked_out"
  . "\nLEFT JOIN #__artbannersplus AS b ON b.tid = c.id"
  . "\n $where "
  . "\nGROUP BY c.id"
  . "\nORDER BY c.name";

  $database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );

  if (($rows = $database->loadObjectList()) === null) {
    echo $database->stderr();
    return false;
  }

  // Build States select list
  $states[] = mosHTML::makeOption( '-1', _ABP_ALLCAT );
  $states[] = mosHTML::makeOption( '1', _ABP_BANNERS_ATT );
  $states[] = mosHTML::makeOption( '0', _ABP_BANNERS_NO_PUB );

  $stateslist = mosHTML::selectList( $states, 'published',
                                     'class="inputbox" size="1" onchange="document.adminForm.submit();"',
                                     'value', 'text', $published );

  HTML_bannerCategory::showCategories( $rows, $my->id, $pageNav , $option, $stateslist);
}

/**
* Compiles information to add or edit a category
* @param string The name of the category section
* @param integer The unique id of the category to edit (0 if new)
* @param string The name of the current user
*/
function editCategory( $cid, $option ) {
  global $database, $my;

  $category = new mosArtCategory( $database );

  if ($cid) {
    // load the row from the db table
    if (!$category->load( $cid )) {
      echo $database->stderr();
      return false;
    }

    // fail if checked out not by 'me'
    if ($category->checked_out && $category->checked_out != $my->id) {
      mosRedirect( "index2.php?option=com_artbannersplus&task=categories",
      sprintf(_ABP_TCICBEBAA, $category->name) );
    }

    $category->checkout( $my->id );
  }

  HTML_bannerCategory::editCategory( $category , $option );
}

/**
* Saves the catefory after an edit form submit
* @param string The name of the category section
*/
function saveCategory( $option ) {
  global $database;

  $category = new mosArtCategory( $database );

  $category->published = 1;

  if (!$category->bind( $_POST )) {
    mosErrorAlert($category->getError());
  }

  if (!$category->check()) {
    mosErrorAlert($category->getError());
  }

  if (!$category->store()) {
    mosErrorAlert($category->getError());
  }

  $category->checkin();

  mosRedirect( "index2.php?option=$option&task=categories" );
}
/**
* Deletes one or more com_artbanners from the artbanners_categories table
* @param array An array of unique category id numbers
*/
function removeCategories( $cid , $option ) {
  global $database;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    mosErrorAlert(_ABP_SACTD);
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "SELECT c.id, c.name"
  . "\nFROM #__artbannersplus_categories AS c"
  . "\nWHERE c.id IN ($cids)"
  . "\nGROUP BY c.id"
  );

  if (!($rows = $database->loadObjectList())) {
    mosErrorAlert($database->stderr());
  }

  $err = array();
  $cid = array();
  foreach ($rows as $row) {

    $database->setQuery( 'SELECT count(*) from #__artbannersplus where tid = '. $row->id);
    if(($count = $database->loadResult()) === null) {
      mosErrorAlert($database->stderr());
    }

    if ($count == 0) {
      $cid[] = $row->id;
    } else {
      $err[] = $row->name;
    }
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__artbannersplus_categories WHERE id IN ($cids)" );
    if (!$database->query()) {
      mosErrorAlert($database->stderr());
    }
  }

  if (count( $err )) {
    $cids = implode( ',', $err );
    mosRedirect( "index2.php?option=com_artbannersplus&task=categories"
      . "&mosmsg=".urlencode(sprintf(_ABP_CCBRATCR, $cids)) );
  }

  mosRedirect( "index2.php?option=$option&task=categories" );
}

/**
* Publishes or Unpublishes one or more artbanners_categories
* @param integer A unique category id (passed from an edit form)
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
*/
function publishCategories( $cid=null, $publish=1 ) {
  global $database, $my;

  if (!is_array( $cid ) || count( $cid ) == 0) {
    $action = $publish ? _ABP_SACT_PUB : _ABP_SACT_UNPUB;
    mosErrorAlert(sprintf(_ABP_SACT, $action));
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "UPDATE #__artbannersplus_categories SET published='$publish'"
  . "\nWHERE id IN ($cids) AND (checked_out=0 OR (checked_out='(int)$my->id'))"
  );

  if (!$database->query()) {
    mosErrorAlert($database->stderr());
  }

  if (count( $cid ) == 1) {
    $category = new mosArtCategory( $database );
    $category->checkin( $cid[0] );
  }

  mosRedirect( 'index2.php?option=com_artbannersplus&task=categories' );
}

/**
* Cancels an edit operation
*/
function cancelEditCategory($option) {
  global $database;
  $category = new mosArtCategory( $database );
  $category->bind( $_POST );
  $category->checkin();
  mosRedirect( "index2.php?option=$option&task=categories" );
}

// OTHER

function showInformation( $option ) {
  HTML_bannersOther::showInformation($option );
}


function buildReccurTypeSelect($reccurtype, $args) {
  $recur[] = mosHTML::makeOption( '0', _ABP_ALLDAYS );
  $recur[] = mosHTML::makeOption( '1', _ABP_EACHWEEK );
  $tosend = mosHTML::selectList( $recur, 'reccurtype', $args, 'value', 'text', $reccurtype );
  echo $tosend;
}

function buildWeekDaysCheck($reccurweekdays, $args) {
  $day_name = array(
  '<font color="red">'._ABP_SUN.'</font>',
  _ABP_MON,
  _ABP_TUE,
  _ABP_WED,
  _ABP_THU,
  _ABP_FRI,
  _ABP_SAT
  );

  $tosend = '';
  $split = array();
  $countsplit = 0;
  if (!empty($reccurweekdays)){
    $split = explode(",", $reccurweekdays);
    $countsplit = count($split);
  }

  for($a=0; $a<7; $a++) {
    $checked = '';
    for ($x = 0; $x < $countsplit; $x++) {
      if ($split[$x] == $a) {
        $checked = 'CHECKED';
      }
    }
    $tosend .= "<input type='checkbox' id='cb_wd".$a."' name='reccurweekdays[]' value='".$a."' ".$args." ".$checked."/>".$day_name[$a]."\n";
  }
  echo $tosend;
}

function getLongDayName($daynb) {

  if ($daynb == "0") {
    $dayname = '<font color="red">'._ABP_SUNDAY.'</font>';
  } elseif ($daynb == "1") {
    $dayname = _ABP_MONDAY;
  } elseif ($daynb == "2") {
    $dayname = _ABP_TUESDAY;
  } elseif ($daynb == "3") {
    $dayname = _ABP_WEDNESDAY;
  } elseif ($daynb == "4") {
    $dayname = _ABP_THURSDAY;
  } elseif ($daynb == "5") {
    $dayname = _ABP_FRIDAY;
  } elseif ($daynb == "6") {
    $dayname = _ABP_SATURDAY;
  }

  return $dayname;
}

function getShortDayName($daynb) {
  if ($daynb == "0") {
    $dayname = '<font color="red">'._ABP_SUN.'</font>';
  } elseif ($daynb == "1") {
    $dayname = _ABP_MON;
  } elseif ($daynb == "2") {
    $dayname = _ABP_TUE;
  } elseif ($daynb == "3") {
    $dayname = _ABP_WED;
  } elseif ($daynb == "4") {
    $dayname = _ABP_THU;
  } elseif ($daynb == "5") {
    $dayname = _ABP_FRI;
  } elseif ($daynb == "6") {
    $dayname = _ABP_SAT;
  }
  return $dayname;
}

function restore($option) {
  HTML_bannersOther::restore($option);
}

function getTextNode($node, $tag, $default = '') {

  $element = $node->getElementsByPath($tag, 1);

  $return = $element ? $element->getText() : $default;

  return $return;
}

function doRestore( $option ) {

  global $mosConfig_absolute_path, $database;

  $media_path  = $mosConfig_absolute_path.'/media/';

  $userfile2=(isset($_FILES['userfile']['tmp_name']) ? $_FILES['userfile']['tmp_name'] : "");
  $userfile_name=(isset($_FILES['userfile']['name']) ? $_FILES['userfile']['name'] : "");

  if (isset($_FILES['userfile'])) {

    if (empty($userfile_name)) {
      mosErrorAlert(_ABP_SELECT_FILE);
    }

    $filename = split("\.", $userfile_name);

    if (eregi("[^0-9a-zA-Z_]", $filename[0])) {
      mosErrorAlert(_ABP_ERROR_FILENAME);
    }

    if (strcasecmp(substr($userfile_name,-4),'.xml')) {
      mosErrorAlert(_ABP_ERROR_NOT_XML_FILE);
    }

    if (!move_uploaded_file ($_FILES['userfile']['tmp_name'],$media_path.$_FILES['userfile']['name']) || !mosChmod($media_path.$_FILES['userfile']['name'])) {
      mosErrorAlert(_ABP_ERROR_LOAD_FILE.$userfile_name);
    }
  }

  global $mosConfig_absolute_path;
  require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_include.php' );

  //instantiate a new DOMIT! document
  $xmldoc =& new DOMIT_Document();

  $success = $xmldoc->loadXML($media_path.$userfile_name);

  if (!$success) {
    @unlink ($media_path.$userfile_name);
    mosErrorAlert('Error file xml. '.$xmldoc->getErrorString());
  }

  //process XML
  $root = &$xmldoc->documentElement;

  //verifico se ha figli
  if (!$root->hasChildNodes()) {
    mosErrorAlert(_ABP_NOT_EXIST_BANNER_RESTORE);
  }

  /*
  ** Leggo i banners
  */
  $bannersNodes  = &$root->getElementsByPath('artbannersplus', 1);
  if (is_null( $bannersNodes )) {
    mosErrorAlert(_ABP_NOT_EXIST_BANNER_RESTORE);
  }

  $banners = &$bannersNodes->getElementsByTagName('record');
  if ( $banners->getLength() == 0) {
    mosErrorAlert(_ABP_NOT_EXIST_BANNER_RESTORE);
  }

  $clientsNodes  = &$root->getElementsByPath('artbannersplus_clients', 1);
  if (is_null( $clientsNodes )) {
    mosErrorAlert(_ABP_ERROR_NOT_EXIST_CLIENTS);
  }

  $clients = &$clientsNodes->getElementsByTagName('record');
  if ( $clients->getLength() == 0) {
    mosErrorAlert(_ABP_ERROR_NOT_EXIST_CLIENTS);
  }

  $categoriesNodes  = &$root->getElementsByPath('artbannersplus_categories', 1);
  if (is_null( $categoriesNodes )) {
    mosErrorAlert(_ABP_ERROR_NOT_EXIST_CATEGORIES);
  }

  $categories = &$categoriesNodes->getElementsByTagName('record');
  if ($categories->getLength () == 0) {
    mosErrorAlert(_ABP_ERROR_NOT_EXIST_CATEGORIES);
  }

  $clienti = array();
  $categorie = array();

  // inserisco tutte le categorie
  // ... mi scorro tutte le categorie
  for ($i_category = 0, $n_categories = $categories->getLength(); $i_category < $n_categories; $i_category++) {
    $category =& $categories->item($i_category);

    $tid = getTextNode($category, 'id', 0);
    // verifico se ho gia' inserito questa categoria
    if (!array_key_exists($tid, $categorie)) {
      $artbannerscategoiriesplus = new mosArtCategory($database);

      $artbannerscategoiriesplus->name        = getTextNode($category, 'name');
      $artbannerscategoiriesplus->description = getTextNode($category, 'description');
      $artbannerscategoiriesplus->published   = getTextNode($category, 'published', 0);

      if ($artbannerscategoiriesplus->store()) {
        // memorizzo il nuovo ID categoria
        $categorie[$tid] = $database->insertid();
      } else {
        echo "<meta http-equiv=\"Content-Type\" content=\"text/html; "._ISO."\" />";
        echo "<script>alert('Errore controllo categoria');</script> \n";
      }
    }
  }

  // inserisco tutti i clienti
  // ... mi scorro tutti i clienti
  for ($i_client = 0, $n_clients = $clients->getLength(); $i_client < $n_clients; $i_client++) {
    $client =& $clients->item($i_client);

    $cid = getTextNode($client, 'cid', 0);

     // verifico se ho gia' inserito questo cliente
    if (!array_key_exists($cid, $clienti ))
    {
      $artbannersclientsplus = new mosArtBannerClient($database);

      $artbannersclientsplus->name      = getTextNode($client, 'name');
      $artbannersclientsplus->contact   = getTextNode($client, 'contact');
      $artbannersclientsplus->email     = getTextNode($client, 'email');
      $artbannersclientsplus->extrainfo = getTextNode($client, 'extrainfo');
      $artbannersclientsplus->published = getTextNode($client, 'published', 0);

      // salvo il cliente
      if ($artbannersclientsplus->store()) {
        // memorizzo il nuovo ID del cliente
        $clienti[$cid] = $database->insertid();
      } else {
        echo "<meta http-equiv=\"Content-Type\" content=\"text/html; "._ISO."\" />";
        echo "<script>alert('Errore controllo cliente');</script> \n";
      }
    }
  }

  // per ogni banner presente nel XML
  for ($i_banner = 0, $n_banners = $banners->getLength(); $i_banner < $n_banners; $i_banner++) {
    $banner =& $banners->item($i_banner);

    // inserisco il banner
    $artbannersplus = new mosArtBanner($database);

    $cid = getTextNode($banner, 'cid');
    $tid = getTextNode($banner, 'tid');

    // se il cliente non e' presente nel file .xml
    if (!array_key_exists($cid, $clienti )) {
      $cid = 0;
    } else {
      $cid = $clienti[$cid];
    }

    // se la categoria non e' presente nel file .xml
    if (!array_key_exists($tid, $categorie )) {
      $tid = 0;
    } else {
      $tid = $categorie[$tid];
    }

    $artbannersplus->cid                = $cid;
    $artbannersplus->tid                = $tid;
    $artbannersplus->type               = getTextNode($banner, 'banner');
    $artbannersplus->name               = getTextNode($banner, 'name');
    $artbannersplus->imp_total          = getTextNode($banner,'imp_total',0);
    $artbannersplus->imp_made           = getTextNode($banner,'imp_made',0);
    $artbannersplus->clicks             = getTextNode($banner,'clicks',0);
    $artbannersplus->image_url          = getTextNode($banner,'image_url');
    $artbannersplus->click_url          = getTextNode($banner,'click_url');
    $artbannersplus->last_show          = getTextNode($banner,'last_show','0000-00-00 00:00:00');
    $artbannersplus->msec               = getTextNode($banner,'msec',0);
    $artbannersplus->state              = getTextNode($banner,'state',0);
    $artbannersplus->reccurtype         = getTextNode($banner,'reccurtype',0);
    $artbannersplus->reccurweekdays     = getTextNode($banner,'reccurweekdays');
    $artbannersplus->custom_banner_code = getTextNode($banner,'custom_banner_code');
    $artbannersplus->access             = getTextNode($banner,'access',0);
    $artbannersplus->target             = getTextNode($banner,'target');
    $artbannersplus->border_value       = getTextNode($banner,'border_value',0);
    $artbannersplus->border_style       = getTextNode($banner,'border_style');
    $artbannersplus->border_color       = getTextNode($banner,'border_color');
    $artbannersplus->click_value        = getTextNode($banner,'click_value',0);
    $artbannersplus->complete_clicks    = getTextNode($banner,'complete_clicks',0);
    $artbannersplus->imp_value          = getTextNode($banner,'imp_value',0);
    $artbannersplus->publish_up_date    = getTextNode($banner,'publish_up_date','0000-00-00');
    $artbannersplus->publish_up_time    = getTextNode($banner,'publish_up_time','00:00:00');
    $artbannersplus->publish_down_date  = getTextNode($banner,'publish_down_date','0000-00-00');
    $artbannersplus->publish_down_time  = getTextNode($banner,'publish_down_time','00:00:00');
    $artbannersplus->alt                = getTextNode($banner,'alt');
    $artbannersplus->title              = getTextNode($banner,'title');

    if (!$artbannersplus->store()) {
      echo "<meta http-equiv=\"Content-Type\" content=\"text/html; "._ISO."\" />";
      echo "<script>alert('Errore salvataggio banner');</script> \n";
    }
  }

  @unlink ($media_path.$userfile_name);
  mosRedirect( "index2.php?option=$option&catid=0&cliid=0", _ABP_RESTORE_OK );
}

function doBackup () {

  global $database, $mosConfig_db, $mosConfig_sitename;

  $UserAgent = $_SERVER['HTTP_USER_AGENT'];

  if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $UserAgent)) {
      $UserBrowser = 'Opera';
  } elseif (ereg('MSIE ([0-9].[0-9]{1,2})', $UserAgent)) {
      $UserBrowser = 'IE';
  } else {
      $UserBrowser = '';
  }

  /* Determine the mime type and file extension for the output file */
  //$filename  = date("Ymdhis").'_artbannersplus.sql';
  $filename  = date("Ymdhis").'_artbannersplus.xml';
  $mime_type = ($UserBrowser == 'IE' || $UserBrowser == 'Opera') ? 'application/octetstream' : 'application/octet-stream';

  /* Store all the tables we want to back-up in variable $tables[] */
  $tables = array();
  $tables[] = '#__artbannersplus_categories';
  $tables[] = '#__artbannersplus_clients';
  $tables[] = '#__artbannersplus';

  /* Store all the FIELD TYPES being backed-up (text fields need to be delimited) in variable $FieldType*/
  foreach ($tables as $tblval) {
      $database->setQuery("SHOW FIELDS FROM $tblval");
      $database->query();
      if (!($fields = $database->loadObjectList())) {
        echo $database->stderr();
        return false;
      }

      foreach($fields as $field)  {
        $FieldType[$tblval][$field->Field] = preg_replace("/[(0-9)]/",'', $field->Type);
      }
  }

  global $mosConfig_absolute_path;
  require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_include.php' );

  //instantiate a new DOMIT! document
  $xmldoc =& new DOMIT_Document();

  //create backup node
  $rootElement =& $xmldoc->createElement('artbannerplus_backup');

  //append cdlibrary node to new DOMIT_Document
  $xmldoc->appendChild($rootElement);

  /* Okay, here's the meat & potatoes */
  foreach ($tables as $tblval) {
    //create backup node
    $TableElement =& $xmldoc->createElement(substr($tblval, 3));
    $database->setQuery("SELECT * FROM $tblval");
    if (!($rows = $database->loadObjectList())) {
      echo $database->stderr();
      return false;
    }

    foreach($rows as $row) {
        $record =& $xmldoc->createElement('record');

        $arr = mosObjectToArray($row);
        foreach($arr as $key => $value) {
            //create backup node
            $fieldElement =& $xmldoc->createElement($key);

            ///create and append text node to name element
            $fieldElement->appendChild($xmldoc->createTextNode($value));

            $record->appendChild($fieldElement);
        }

        //append name element to cd element
        $TableElement->appendChild($record);

    }

    $rootElement->appendChild($TableElement);
  }

  $OutBuffer = $xmldoc->toNormalizedString();

  /* Send the HTML headers */
  // dump anything in the buffer
  @ob_end_clean();
  ob_start();
  header('Content-Type: ' . $mime_type);
  header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');

  if ($UserBrowser == 'IE') {
      header('Content-Disposition: inline; filename="' . $filename . '"');
      header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
      header('Pragma: public');
  } else {
      header('Content-Disposition: attachment; filename="' . $filename . '"');
      header('Pragma: no-cache');
  }

  echo $OutBuffer;
  ob_end_flush();
  ob_start();
  //// do no more
  exit();
}

/*
** Return state of the banner
*/
function getStato(&$row) {

  if ($row->id == 0) { // banner nuovo
    return BANNER_ATTIV0;
  }

  // se ho impostato il numero max di impressioni allora
  // verifico se ho terminato
  if ($row->imp_total != 0) {
    if ($row->imp_made == $row->imp_total) {
      return BANNER_TERMINATO;
    }
  }

  $iRet = BANNER_NON_PUBBLICATO; // state == '0'

  if ($row->state == '1') {

    $date = mosCurrentDate("%Y-%m-%d");

    // - se la data di attivazione e' maggiore della data odierna: BANNER_IN ATTIVAZIONE
    // - se la data odierna e' minore della data di fine pubblicazione o la data di
    //   fine pubblicazione e' impostato a Mai (0000-00-00) : BANNER ATTIVO
    // - se la data odierna e' uguale alla data di fine pubblicazione: BANNER ATTIVO
    // - se la data odierna e' maggiore della data di fine pubblicazione: BANNER TERMINATO
    if ($date < $row->publish_up_date) {
      $iRet = BANNER_IN_ATTIVAZIONE;
    } else if ($date < $row->publish_down_date || $row->publish_down_date == '0000-00-00' ) {
      $iRet = BANNER_ATTIV0;
    } else if  ($date == $row->publish_down_date) {
      $iRet = BANNER_ATTIV0;
    } else if ($date > $row->publish_down_date) {
      $iRet = BANNER_TERMINATO;
    }
  }

  return $iRet;
}
?>
