<?php
/**
* ArtBannersPlus 1.5.1
* Joomla Component
* Bernardino Porcaro
* www.dinoporcaro.it
* bporcaro@gmail.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @package ArtBannersPlus
* ArtBannersPlus! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// Don't allow direct access to the file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// function that selecting one or more banner/s
function showBanners( &$params ) {
  global $database, $my;

  $random = (int)$params->get( 'random', 0 );
  $count = (int)$params->get( 'count', 1 );
  $banners = $params->get( 'banners' );
  $categories = $params->get( 'categories');
  $clients = $params->get( 'clients' );
  $orientation = (int)$params->get( 'orientation', 0 );
  $moduleclass_sfx = $params->get('moduleclass_sfx');

	$weekday = mosCurrentDate("%w");
	$date = mosCurrentDate("%Y-%m-%d");
	$time = mosCurrentDate("%H:%M:%S");

	$where = array();
	if ($categories != '') {
    $categoriesArray = explode( ',', $categories );
    mosArrayToInts( $categoriesArray );
    $categories = implode(',',$categoriesArray);
    $where[] = "#__artbannersplus.tid IN ($categories)";
  }

	if ($banners != '') {
    $bannersArray = explode( ',', $banners );
    mosArrayToInts( $bannersArray );
    $banners = implode(',',$bannersArray);
    $where[] = "#__artbannersplus.id IN ($banners)";
	}

  if ($clients != '') {
    $clientsArray = explode( ',', $clients );
    mosArrayToInts( $clientsArray );
    $clients = implode(',',$clientsArray);
		$where[] = "#__artbannersplus.cid IN ($clients)";
  }

  if (count($where) > 0)
	  $where = '('.implode(' OR ', $where).') AND';
  else
    $where = '';

	$query = "SELECT #__artbannersplus.* FROM #__artbannersplus,
                          #__artbannersplus_categories,
                          #__artbannersplus_clients
      WHERE 1 AND $where
		  (('$date' <= publish_down_date OR publish_down_date = '0000-00-00')
		  AND '$date' >= publish_up_date
		  AND ((reccurtype = 0)
		      OR (reccurtype = 1 AND reccurweekdays LIKE '%$weekday%'))
		  AND '$time' >= publish_up_time
		  AND ('$time' <= publish_down_time OR publish_down_time = '00:00:00')
		  AND access <= '$my->gid'
      AND state = '1'
      AND #__artbannersplus.tid = #__artbannersplus_categories.id
      AND #__artbannersplus_categories.published = 1
      AND #__artbannersplus.cid = #__artbannersplus_clients.cid
      AND #__artbannersplus_clients.published = 1 ) ORDER BY last_show ASC, msec ASC";

	$database->setQuery( $query );
	if(!$database->query()) {
		return '&nbsp;';
	}

  if (!($rows = $database->loadObjectList())) {
    return '&nbsp;';
  }

  // se non ci sono banner
  $numrows = count( $rows );
  if ($numrows == 0)
    return '&nbsp;';

  $result = '<link rel="stylesheet" href="components/com_artbannersplus/artbannersplus.css" type="text/css" />';
  $result .= '<table cellpadding="0" cellspacing="0" class="artbannersplus'.$moduleclass_sfx.'">';

  // se si vuole visualizzare banner in modalita' random
  if ($random && $count == 1) {

    $bannum = 0;
    if ($numrows > 1) {
      $numrows--;
    	mt_srand( (double) microtime()*1000000 );
    	$bannum = mt_rand( 0, $numrows ); 
    }

    if ($numrows) {
      $result .= '<tr><td>' . showSingleBanner($rows[$bannum]) . '</td></tr></table>';
      return $result;
    }
  }  else if ($random && $count > 1) { // thank you Richard Stupart
    shuffle($rows); 
  } 

	$showed = 0;

  $first = false;
	foreach ($rows as $row) {

    //'0' -> Vertical
    //'1' -> Horizontal
    if ($orientation == '0') {
      $result .= '<tr><td>' . showSingleBanner($row) . '</td></tr>';
    } else {

      if ($first == false) {
        $result .= '<tr>';
        $first = true;
      }

      $result .= '<td>' . showSingleBanner($row) . '</td>';
    }

		$showed++;
		if ($showed == $count) {break;}
	}

  if ($orientation == '1') {
    $result .= '</tr>';
  }

  $result .= '</table>';

	return $result;
}

// function that showing one banner
function showSingleBanner(&$banner) {
  global $mosConfig_live_site, $database, $mosConfig_absolute_path;

  $result = '';

	$secs = gettimeofday();
	$database->setQuery( "UPDATE #__artbannersplus SET imp_made=imp_made+1,
                        last_show='".mosCurrentDate("%Y-%m-%d %H:%M:%S")."',
                        msec='".$secs["usec"]."'
                        WHERE id='$banner->id'" );
	$database->query();

	$banner->imp_made++;
	if ($banner->imp_total == $banner->imp_made) {
		$database->setQuery( "UPDATE #__artbannersplus SET state='0' WHERE id='$banner->id'" );
		$database->query();
	}

	if( $banner->custom_banner_code != "") {
		$result .= $banner->custom_banner_code;
	} else if (eregi( "(\.bmp|\.gif|\.jpg|\.jpeg|\.png)$", $banner->image_url)) {
		$image_url="$mosConfig_live_site/images/banners/$banner->image_url";
		$imginfo = @getimagesize( "$mosConfig_absolute_path/images/banners/".$banner->image_url );
		$target = $banner->target;
		$border_value = $banner->border_value;
		$border_style = $banner->border_style;
		$border_color = $banner->border_color;

    $alt = $banner->name;
    if ($banner->alt != '')
      $alt = $banner->alt;

    $title = $banner->title;

		$result = "<a href=\"index.php?option=com_artbannersplus&amp;task=clk&amp;id=$banner->id\" target=\"_" . $target . "\"><img src=\"" . $image_url . "\" style=\"border:" . $border_value . "px " . $border_style . " " . $border_color . "\" vspace=\"0\" alt=\"$alt\" title=\"$title\" width=\"$imginfo[0]\" height=\"$imginfo[1]\" /></a>";
	} else if (eregi(".swf", $banner->image_url)) {
		$image_url="$mosConfig_live_site/images/banners/".$banner->image_url;
		$swfinfo = @getimagesize( "$mosConfig_absolute_path/images/banners/".$banner->image_url );
		$result = "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,2,0\" border=\"0\" width=\"$swfinfo[0]\" height=\"$swfinfo[1]\" vspace=\"0\"><param name=\"SRC\" value=\"$image_url\"><embed src=\"$image_url\" loop=\"false\" pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=\"$swfinfo[0]\" height=\"$swfinfo[1]\"></object>";
	}

  return $result;
}
?>