<?php
// hotproperty.php
/**
* Hot Property
*
* @package Hot Property 0.9
* @copyright (C) 2004-2006 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <hotproperty@mosets.com>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

include_once ( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/function.hotproperty.php' );

# Front-end classes
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/hotproperty.class.php' );

# Backend classes
include_once ( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/admin.hotproperty.class.php' );

# Edit Property
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/property.php' );
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/property.html.php' );
include_once( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/classes/oohforms.inc' );

# Edit Agent
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/agent.php' );
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/agent.html.php' );

require( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/config.hotproperty.php' );
include_once( $mosConfig_absolute_path.'/components/com_hotproperty/functions.hotproperty.php' );
include_once( $mosConfig_absolute_path.'/includes/pageNavigation.php' );
require_once( $mainframe->getPath( 'front_html' ) );

# Include the language file. Default is English
if (file_exists($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php')) {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php');
} else {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/english.php');
}


/*
if ($hp_language=='') {
	$hp_language='english';
} else {
	$hp_language=$mosConfig_lang;
}

include_once('components/com_hotproperty/language/'.$hp_language.'.php');
*/


SetFilters();


if ($task <> "rss") {
	# include Hot Property's CSS file
	# To allows greater control over the presentation layer, through CSS.
	hotproperty_HTML::include_CSS();

	# Global Container - Start
	hotproperty_HTML::include_Container_Start();
}

# Include a special container for Image management - Used when editing property in front-end
if (substr($task,-5) == "image")  {
	HP_Property_HTML::listprop_starthtml_image();
}

#
$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );

# Caching
$cache =& mosCache::getCache( 'com_hotproperty' );

switch( $task ) {
	case 'viewtype':
		$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit ) );
		$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

		$sortby_sort = trim( mosGetParam( $_REQUEST, 'sort', $hp_default_order ) );
		$sortby_order = trim( mosGetParam( $_REQUEST, 'order', $hp_default_order2 ) );

		$cache->call( 'showType', $id, $limit, $limitstart, $sortby_sort, $sortby_order );
		break;
	case 'viewco':
		$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit_co ) );
		$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
		$cache->call( 'showCompany', $id, $limit, $limitstart );
		break;
	case 'viewagent':
		$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit_agent ) );
		$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
		$cache->call( 'showAgent', $id, $limit, $limitstart );
		break;
	case 'viewfeatured':
		$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit_featured) );
		$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
		$cache->call( 'showFeatured', $limit, $limitstart );
		break;
	case "viewagentemail":
		showAgentEmail();
		break;
	case "viewcoemail":
		showCoEmail();
		break;
	case 'view':
		$cache->call('showProp', $id );
		break;
	case 'sendenquiry':
		sendEnquiry();
		break;
	case 'search':
		search();
		break;
	case 'asearch':
		asearch();
		break;
	case 'advsearch':
		searchAdv();
		break;
	case 'emailform':
		emailContentForm();
		break;
	case "emailsend":
		emailContentSend();
		break;
	case "showpdf":
		showpdf();
		break;
	/* Edit Agent */
	case 'editagent':
		editagent();
		break;
	case 'saveagent':
		mosCache::cleanCache( 'com_hotproperty' );
		saveagent($option);
		break;
	case 'cancelagent':
		cancelagent($option);
		break;

	/* Edit Property */
	case 'editprop':
		editproperty($option);
		break;
	case 'addprop':
		editproperty($option);
		break;
	case 'saveprop':
		mosCache::cleanCache( 'com_hotproperty' );
		saveproperty($option);
		break;
	case "saveproperty_image_new":
		# Save and Edit again - For new record
		mosCache::cleanCache( 'com_hotproperty' );
		saveproperty($option, 'newimage');
		break;
	case 'cancelprop':
		cancelproperty($option);
		break;
	case 'manageprop':
		manageprop();
		break;

	/* Image Management */
	case "listprop_image":
		listprop_showupload_image();
		break;
	case "listprop_upload_image":
		mosCache::cleanCache( 'com_hotproperty' );
		listprop_upload_image();
		break;
	case "listprop_edit_image":
		listprop_edit_image();
		break;
	case "listprop_delete_image":
		mosCache::cleanCache( 'com_hotproperty' );
		listprop_delete_image();
		break;
	case "orderup_images":
		mosCache::cleanCache( 'com_hotproperty' );
		listprop_order_image(-1, $option);
		break;
	case "orderdown_images":
		mosCache::cleanCache( 'com_hotproperty' );
		listprop_order_image(1, $option);
		break;
	case "listprop_edit_images":
		listprop_edit_images($option);
		break;

	/* RSS Feeds */
	case "rss":
		include_once ( $mosConfig_absolute_path.'/components/com_hotproperty/rss.hotproperty.php' );
		break;

	# Show Main Listing by default
	case "":
		showFrontpage();
		break;

	# Display Mambo default error msg when $task provided does not exists
	default:
		echo _NOT_EXIST;
		break;
}

# Image Management Container - End
if (substr($task,-5) == "image") {
	listprop_image($option);
	HP_Property_HTML::listprop_endhtml_image();
}

if ($task <> "rss") {
	# Global Container - End
	hotproperty_HTML::include_Container_End();
}

function showFrontpage() {
	global $database, $hp_fp_featured_count, $cache;

	# Get featured listings' Data
	if ( !is_numeric($hp_fp_featured_count) ) $hp_fp_featured_count = 0;

	HP_getProperty('featured', null, $featured, $featured_fields_caption, 0, $hp_fp_featured_count);
	$featured_total = hotproperty::getNumProp('p.featured=1');

	# Select published types
	$database->setQuery( "SELECT * FROM #__hp_prop_types AS t"
		. "\nWHERE t.published='1'"
		. "\nORDER BY t.ordering ASC");
	$types = $database->loadObjectList();

	# Get the number of records for each type
	################## PERFECTURE FILTER ###################
	$perfectureCookie = mosGetParam( $_COOKIE, 'perfecture', null );
	if (isset($perfectureCookie["perfecture"]) && $perfectureCookie["perfecture"] != "") {	
		if ( $perfectureCookie == "outside") {
#			echo "1. Outside of Crete, is currently not working. Please wait";			
#			$where[] .= "p.Hors_de_Crete LIKE '%yes%'";
			$where[] .= "p.country LIKE '%yes%'";
			#echo "set the country 1" . $perfectureCookie["perfecture"] . " task: ".mosGetParam( $_GET, 'task', "" );
		} else {
			$where[] .= "p.state LIKE '%" . $perfectureCookie . "%'";
		}
	}
	################## PERFECTURE FILTER ###################
	
	
	$database->setQuery( "SELECT COUNT(*) AS total, type FROM #__hp_properties as p"
		. "\nWHERE published='1' AND approved='1'"
		//. "\nAND state LIKE '%" . $perfectureCookie . "%'"		
		.	(count( $where ) ? "\nAND (" . implode( ' OR ', $where ) .")": "")		
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		. "\nGROUP BY type");

	$types_total = $database->loadObjectList('type');

	# Get the top 3 HOT property under every published types. It will be more attractive to the user
	foreach($types AS $t) {
		$database->setQuery( "SELECT p.name, p.id FROM #__hp_properties AS p"
			.	"\nLEFT JOIN #__hp_prop_types AS t ON t.id=p.type"
			.	(count( $where ) ? "\nAND (" . implode( ' OR ', $where ) .")": "")						
			. "\nWHERE p.published='1' AND p.approved='1' AND t.published='1' AND type=".$t->id
			. "\n	AND (p.publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
			. "\n	AND (p.publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
			. "\nORDER BY p.hits DESC"
			. "\nLIMIT 0,3");

		$types_hotproperty[$t->id] = $database->loadObjectList();

		echo $database->getErrorMsg();
	}
	$cache->call( 'hotproperty_HTML::show_Frontpage', $featured, $featured_fields_caption, $featured_total, $types, $types_hotproperty, $types_total );

}

function showType( $id, $limit, $limitstart, $sortby_sort, $sortby_order ) {
	global $database, $Itemid, $hp_default_limit;
	
	# Validate input
	if ( $sortby_order <> "asc" ) $sortby_order = "desc";
	if ( $sortby_sort <> "name" && $sortby_sort <> "agent" && $sortby_sort <> "price" && $sortby_sort <> "suburb" && $sortby_sort <> "state" && $sortby_sort <> "country" && $sortby_sort <> "type" && $sortby_sort <> "modified" && $sortby_sort <> "hits") $sortby_sort = "name";

	# Redirect to main listing if invalid ID
	if (!HP_isTypePublished($id)) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid)) ;

	# Pagination
	$total = HP_getNumProp_GroupType($id);
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	# Get type
	$database->setQuery("SELECT name, id FROM #__hp_prop_types WHERE id='".$id."' LIMIT 1");
	$database->loadObject($type);

	# Get properties
	$where[] = "type='".$id."'";

	HP_getProperty('listing', $where, $prop, $caption, $limitstart, $limit, $sortby_sort, $sortby_order);

	hotproperty_HTML::show_Type($prop, $type, $caption, $pageNav, $sortby_sort, $sortby_order);	
}

function showProp( $id ) {
	global $database, $hp_show_agentdetails, $hp_use_companyagent;
	
	if (!HP_isPropPublished($id)) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&amp;Itemid=$Itemid'));

	$where[] = "p.id='".$id."'";

	HP_getProperty('all', $where, $prop, $caption);


	# Get All thumbnails
	$database->setQuery("SELECT * FROM #__hp_photos"
		.	"\nWHERE property='".$id."'"
		.	"\nORDER BY ordering ASC");
	$images = $database->loadObjectList();

	# Get Agent's info
	if ($hp_show_agentdetails && $hp_use_companyagent) {
		$sql = "SELECT a.*, COUNT(p.id) AS properties, c.id AS companyid, c.name AS company FROM (#__hp_agents AS a, #__hp_prop_types AS t) "
		.	"\nLEFT JOIN #__hp_companies AS c ON c.id=a.company"
		.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
		.	"\nWHERE a.id='".$prop[0]->agentid."'"
		.	"\n AND t.id=p.type"
		. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		. "\nGROUP BY p.agent"
		.	"\nLIMIT 1";
		$database->setQuery($sql);
		$agent = $database->loadObjectList();
	}

	# Record Hit
	$database->setQuery("UPDATE #__hp_properties SET hits = hits + 1 WHERE id ='".$id."' LIMIT 1");
	$database->query();

	hotproperty_HTML::show_Prop($prop, $caption, $images, $agent);

}

function showCompany( $id, $limit, $limitstart ) {
	global $database, $Itemid;
	
	if ($id == 0) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&amp;Itemid=$Itemid'));

	# Get Company's info
	$database->setQuery("SELECT c.* FROM #__hp_companies AS c"
		.	"\nWHERE c.id='".$id."'"
		.	"\nLIMIT 1");
	$company = $database->loadObjectList();

	# Redirect to main listing if company does not exists
	if (count($company) == 0) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));

	# Pagination
	$database->setQuery("SELECT COUNT(DISTINCT a.id) FROM (#__hp_agents AS a, #__hp_prop_types AS t) "
		.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
		.	"\nWHERE a.company='".$id."'"
		.	"\n AND t.id=p.type"
		. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())");
	$total = $database->loadResult();
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	# Get Agents' info who works for this company
	$database->setQuery("SELECT a.*, COUNT(p.id) AS properties FROM (#__hp_agents AS a, #__hp_prop_types AS t)"
		.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
		.	"\nWHERE a.company='".$id."'"
		.	"\n AND t.id=p.type"
		. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		.	"\nGROUP BY p.agent"
		. "\nORDER BY name ASC"
		.	"\nLIMIT ".$limitstart.", ".$limit);
	$agents = $database->loadObjectList();

	hotproperty_HTML::show_Company($company, $agents, $pageNav);
}

function showAgent( $id, $limit, $limitstart ) {
	global $database, $Itemid;

	# Get Agent's info 
	# - Only get agent that has at least 1 property
	$database->setQuery("SELECT a.*, COUNT(p.id) AS properties, c.id AS companyid, c.name AS company FROM (#__hp_agents AS a, #__hp_prop_types AS t) "
		.	"\nLEFT JOIN #__hp_companies AS c ON c.id=a.company"
		.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
		.	"\nWHERE a.id='".$id."'"
		.	"\n AND t.id=p.type"
		. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		.	"\nGROUP BY p.agent");
	$agent = $database->loadObjectList();

	if (empty($agent) )	mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));

	# Pagination
	$total = HP_getNumProp_GroupAgent($id);
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	# Load properties belong to this agent
	$where[] = "agent='".$id."'";

	HP_getProperty('listing', $where, $prop, $caption, $limitstart, $limit);

	hotproperty_HTML::show_Agent($prop, $caption, $agent, $pageNav);	
}

function showFeatured( $limit, $limitstart) {
	global $database, $Itemid;

	# Pagination
	$total = hotproperty::getNumProp('p.featured=1');
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	# Load properties belong to this agent
	
	HP_getProperty('featured', null, $prop, $caption, $limitstart, $limit);

	hotproperty_HTML::show_Featured($prop, $caption, $pageNav);	
}

function showCoEmail() {
	global $database, $Itemid	;

	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );

	# Get Company's info
	$database->setQuery("SELECT c.* FROM #__hp_companies AS c"
		.	"\nWHERE c.id='".$id."'"
		.	"\nLIMIT 1");
	$company = $database->loadObjectList();
	
	# If company does not exists, redirect to main listing
	if (empty($company))	mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));

	hotproperty_HTML::show_CoEmail($company);	
}

function showAgentEmail() {
	global $database, $Itemid	;

	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );

	# Get Agent's info
	$database->setQuery("SELECT a.*, COUNT(p.id) AS properties, c.id AS companyid, c.name AS company FROM #__hp_agents AS a"
		.	"\nLEFT JOIN #__hp_companies AS c ON c.id=a.company"
		.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
		.	"\nWHERE a.id='".$id."'"
		.	"\nGROUP BY p.agent"
		.	"\nLIMIT 1");
	$agent = $database->loadObjectList();

	# If agent does not exists, redirect to main listing
	if (empty($agent))	mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));

	hotproperty_HTML::show_AgentEmail($agent);	
}

function sendEnquiry() {
	global $database, $Itemid, $mosConfig_live_site, $mosConfig_sef, $option;;
	
	josSpoofCheck(1);

	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
	$sbj = trim( strtolower( mosGetParam( $_POST, 'sbj', '' ) ) );

	# Redirect to main listing if property/agent is invalid or not unpublish
	if ($id == 0) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));
	if (empty($sbj)) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));

	if ($sbj == "property") {
		if (!HP_isPropPublished($id)) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));
	} elseif ($sbj == "agent") {
		$database->setQuery("SELECT id FROM #__hp_agents WHERE id='".$id."' LIMIT 1");
		$agentid = $database->loadResult();
		if ( empty($agentid) ) {
			mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));
		}
	} elseif ($sbj == "company") {
		$database->setQuery("SELECT id FROM #__hp_companies WHERE id='".$id."' LIMIT 1");
		$companyid = $database->loadResult();
		if ( empty($companyid) ) {
			mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid));
		}
	}

	# Assign form's value
	$hp_email = trim( mosGetParam( $_POST, 'hp_email', '' ) );
	$hp_contactnumber = trim( mosGetParam( $_POST, 'hp_contactnumber', '' ) );
	$hp_name = trim( mosGetParam( $_POST, 'hp_name', '' ) );
	$hp_country = trim( mosGetParam( $_POST, 'hp_country', '' ) );
	$hp_enquiry = trim( mosGetParam( $_POST, 'hp_enquiry', '' ) );

	# Validate form's data
	if (!$hp_name || !$hp_enquiry || !$hp_country ){
		echo "<script>alert (\""._HP_CONTACT_ERR_COMPLETE."\"); window.history.go(-1);</script>";
		exit(0);
	}
	if (!$hp_email && !$hp_contactnumber){
		echo "<script>alert (\""._HP_CONTACT_ERR_ONECONTACT."\"); window.history.go(-1);</script>";
		exit(0);
	}
	if ($hp_email && !is_email($hp_email)) {
		echo "<script>alert (\""._HP_CONTACT_ERR_VALIDEMAIL."\"); window.history.go(-1);</script>";
		exit(0);
	}

	# Get agent's email & name, Property's title
	if ($sbj == "property") {
		$sql = "SELECT a.name AS name, a.email AS email, p.name AS propTitle FROM #__hp_properties AS p"
			.	"\nLEFT JOIN #__hp_agents AS a ON a.id=p.agent"
			.	"\nWHERE p.id='".$id."'";
	} elseif ($sbj == "agent") {
		$sql = "SELECT a.name AS name, a.email AS email FROM #__hp_agents AS a"
			.	"\nWHERE a.id='".$id."'";
	} elseif ($sbj == "company") {
		$sql = "SELECT c.name AS name, c.email AS email FROM #__hp_companies AS c"
			.	"\nWHERE c.id='".$id."'";
	}
	$database->setQuery($sql);
	$database->loadObject($agent);

	$email_to = $agent->email;

	# Construct the email
	$text  = ""._HP_CONTACT_ENQUIRY_TEXT.$hp_name;
	
	$text .= "\n"._HP_CONTACTCOUNTRY.": ". $hp_country . "\n"._CMN_EMAIL.": ". $hp_email . "\n"._HP_CONTACTNUMBER.": ".$hp_contactnumber."\r\n".stripslashes($hp_enquiry);
	if ($sbj == "property") {
		$text .= "\n\n"._HP_CONTACT_ENQUIRY_TEXT2;
		$text .= "\n\n\t";

		if ($mosConfig_sef) {
			$url = sefRelToAbs("index.php?option=com_hotproperty&task=view&id=$id");
		} else {
			// Get Itemid
			$database->setQuery("SELECT id FROM #__menu WHERE link='index.php?option=$option'");
			$Itemid = $database->loadResult();
			$url = $mosConfig_live_site .'/'. "index.php?option=com_hotproperty&task=view&id=$id&Itemid=$Itemid";
		}

		$text .= $url;
	}
	if ($sbj == "property")	$subject = _HP_CONTACT_ENQUIRY_SUBJECTP.$agent->propTitle;
	elseif ($sbj == "agent") $subject = _HP_CONTACT_ENQUIRY_SUBJECTA;
	elseif ($sbj == "company") $subject = _HP_CONTACT_ENQUIRY_SUBJECTC;
	$headers .= "From: ".$hp_name." <".$hp_email.">\r\n";
	$headers .= "Reply-To: <".$hp_email.">\r\n";
	$headers .= "X-Priority: 3\r\n";
	$headers .= "X-MSMail-Priority: Low\r\n";
	$headers .= "X-Mailer: Hot Property\r\n\r\n";
	
	# Send the email
	mosMail($hp_email,$hp_name,$email_to,$subject,$text);

	if ($sbj == "property") {	?>
	<script> alert("<?php echo _HP_CONTACT_THANK; ?>"); document.location.href='<?php echo sefRelToAbs("index.php?option=com_hotproperty&task=view&id=$id&Itemid=$Itemid"); ?>'; </script>
	<?php } elseif ($sbj == "agent") { ?>
	<script> alert("<?php echo _HP_CONTACT_THANK; ?>"); document.location.href='<?php echo sefRelToAbs("index.php?option=com_hotproperty&task=viewagent&id=$id&Itemid=$Itemid"); ?>'; </script>
	<?php } elseif ($sbj == "company") { ?>
	<script> alert("<?php echo _HP_CONTACT_THANK; ?>"); document.location.href='<?php echo sefRelToAbs("index.php?option=com_hotproperty&task=viewco&id=$id&Itemid=$Itemid"); ?>'; </script>
	<?php } 

}

function search() {
	global $database, $Itemid, $hp_default_limit_search;

	$searchString->search = rawurldecode(trim( mosGetParam( $_POST, 'search', '' ) ) );

	if ( empty($searchString->search) ) $searchString->search = rawurldecode(trim( mosGetParam( $_REQUEST, 'search', '' ) ) );
	
	$searchString->type = intval( mosGetParam( $_POST, 'type', '' ) );
	
	if ( empty($searchString->type) ) $searchString->type = intval( mosGetParam( $_REQUEST, 'type', '' ) );

	if ( !empty($searchString->type) && empty($searchString->search) ) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&task=viewtype&id='.$searchString->type.'Itemid='.$Itemid)) ;

	if ( empty($searchString->search) ) mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid)) ;

  $where = array();
	$where[] = "p.name LIKE '%".  htmlentities($searchString->search, ENT_NOQUOTES)."%'";
	$where[] = "p.address LIKE '%".htmlentities($searchString->search, ENT_NOQUOTES)."%'";
	$where[] = "p.suburb LIKE '%$searchString->search%'";
	$where[] = "p.state LIKE '%$searchString->search%'";
	$where[] = "p.country LIKE '%$searchString->search%'";
	$where[] = "p.intro_text LIKE '%$searchString->search%'";
	$where[] = "p.full_text LIKE '%$searchString->search%'";

	# Pagination
	$database->setQuery("SELECT COUNT(*) FROM #__hp_properties AS p"
		. "\nLEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
		. "\nWHERE p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		.	(count( $where ) ? "\nAND (" . implode( ' OR ', $where ) .")": "")
		. (($searchString->type <> 0) ? "\nAND p.type=".$searchString->type: "")
		); 
	$total = $database->loadResult();
	$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit_search) );
	$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	# Only log search if the listing is on the first page. This prevents multiple hits for the same search if a 
	# search result span multipls pages
	if ($limit == $hp_default_limit_search && $limitstart == 0) HP_logSearch($searchString->search);

	# Select published types
	$database->setQuery( "SELECT * FROM #__hp_prop_types AS t"
		. "\nWHERE t.published='1'"
		. "\nORDER BY t.ordering ASC");
	$types = $database->loadObjectList();

	# Load Result of the search
	$where2[] = "(".implode( ' OR ', $where ).")";
	if ($searchString->type <> 0)	$where2[] = "p.type=".$searchString->type;

	
	HP_getProperty('listing', $where2, $prop, $caption, $limitstart, $limit);

	hotproperty_HTML::show_SearchResults($types, $prop, $caption, $pageNav, $searchString);	
}

/**
* Perform the Advanced Search
*
*/
function asearch() {
	global $database, $Itemid, $hp_default_limit_search, $hp_use_advsearch;

	if ($hp_use_advsearch <> '1') {
		mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid)) ;		
	}



	# Load up search ID if available
	$search_id = intval( mosGetParam( $_REQUEST, 'search_id', 0 ) );
	
	if ($search_id > 0) 
	{
		$database->setQuery("SELECT search_text FROM #__hp_search_results WHERE search_id ='".$search_id."'");
		$database->query();
		$_POST = unserialize($database->loadResult());
	}
	
	# Get Extra Fields setting
	$sql = "SELECT name, iscore, size, field_elements, field_type, search_caption, search_type FROM #__hp_prop_ef WHERE search=1 AND published = 1 AND hidden = 0 ORDER BY iscore DESC, ordering ASC";
	$database->setQuery($sql);
	$rows = $database->loadObjectList();

	# Look for range_1 & range_2 fields and validate is_numeric

	foreach($rows AS $row) {
		switch($row->search_type) {
			case 'range_1':
				if ( mosGetParam( $_POST, $row->name, '' ) <> '' ) {
					if ( !is_numeric(trim( mosGetParam( $_POST, $row->name."_range", '' ))) || !is_numeric(trim( mosGetParam( $_POST, $row->name, '' ))) ) {
						//echo "range_1";
						hotproperty_HTML::show_advSearchResults_error(_HP_SEARCH_NOTVALID);
						//exit();
					}
				}
				break;
			case 'range_2':
				if( (trim( mosGetParam( $_POST, $row->name."_from", '' )) <> '' && !is_numeric(trim( mosGetParam( $_POST, $row->name."_from", '' )))) || (trim( mosGetParam( $_POST, $row->name."_to", '' )) <> '' && !is_numeric(trim( mosGetParam( $_POST, $row->name."_to", '' )))) ) {
					//echo "range_2";
					hotproperty_HTML::show_advSearchResults_error(_HP_SEARCH_NOTVALID);
					//exit();
				}
				break;
		}
	}

	/***************************************************************
	 * Construct mos_hp_temp table for advance searching
	 * Hot Property Advanced Searching works by elimination. 
	 * It first creates a temporary table consisting all searchable fields and it's data. 
	 * HP will narrow the result by eliminations.
	 ***************************************************************/
	$database->setQuery("DROP TABLE IF EXISTS #__hp_temp");
	$database->query();

	$sql = "CREATE TABLE #__hp_temp ("
		."\n id INT(11) NOT NULL, ";

	foreach ($rows AS $col) {
		if ($col->field_type == 'checkbox' || $col->field_type == 'selectmultiple') 
		{
			// Create SET field for checkbox and selectmultiple fields
			$sql .= "\n".$col->name." SET('".str_replace('|',"', '",$col->field_elements)."') NOT NULL, ";
		} else {
			$sql .= "\n".$col->name." MEDIUMTEXT NOT NULL, ";
		}
	}
	$sql .= "\nPRIMARY KEY  (id)"
		#. "\n) TYPE=MyISAM ;";
		. "\n) ;";		

	$database->setQUery($sql);
	if (!$database->query()) 
	{
		echo $database->getErrorMsg();
	}

	# Populating core field's data
	$sql2 = "INSERT INTO #__hp_temp (`id`";

	foreach ($rows AS $col) {
		if ($col->iscore) {
			$sql2 .= ", `".$col->name."`";
		}
	}
	$sql2 .= ") \n SELECT p.id";
	foreach ($rows AS $col) {
		if ($col->iscore) {
			if ($col->name == 'company') 
			{
				$sql2 .= ", c.id AS company";
			} else {
				$sql2 .= ", p.".$col->name;
			}
		}
	}

	$sql2 .= "\n FROM (#__hp_properties AS p, #__hp_companies AS c)"
		. "\n LEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
		. "\n LEFT JOIN #__hp_agents AS a ON p.agent = a.id"
		. "\n WHERE p.published='1' AND p.approved='1' AND t.published='1'"
		.	"\n AND a.company=c.id"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())";

	$database->setQuery($sql2);
	if (!$database->query()) {
		echo $database->getErrorMsg();
	}

	# Populating non-core field's data
	$sql3 = "SELECT e.name, e.field_type, p.property, p.field, p.value FROM (#__hp_properties2 AS p, #__hp_prop_ef AS e)"
		.	"\nWHERE e.id=p.field AND e.published=1 AND e.hidden=0 AND e.search=1";

	$database->setQuery($sql3);
	$rows3 = $database->loadObjectList();

	foreach ($rows3 AS $row3) {
		if ($row3->field_type == 'checkbox' || $row3->field_type == 'selectmultiple') 
		{
			$sql4 = "UPDATE #__hp_temp SET ".$row3->name."='".mysql_escape_string(str_replace('|',",",$row3->value))."' WHERE id='".$row3->property."'";
		} else {
			$sql4 = "UPDATE #__hp_temp SET ".$row3->name."='".$row3->value."' WHERE id='".$row3->property."'";
		}
		$database->setQuery($sql4);
		$database->query();
	}

	/*************************************************************** 
	 * End of creating mos_hp_temp
	 ***************************************************************/

	# Setup the sql conditions
	$where = '';

	foreach ( $rows AS $row ) {
		
		if ( ($row->field_type == "link" || $row->field_type == "text" || $row->field_type == "multitext" || $row->name == "name") && trim( mosGetParam( $_POST, $row->name )) <> '' && ($row->search_type <> 'range_1' && $row->search_type <> 'range_2' && $row->search_type <> 'range_3') ) {

			$where = $row->name ." NOT LIKE '%".mysql_escape_string(trim( mosGetParam( $_POST, $row->name, '' ) ))."%'";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) {
				echo $database->getErrorMsg();
			}

		} elseif($row->field_type == "selectlist" && trim( mosGetParam( $_POST, $row->name, '' )) <> '' ) {
			if ( //Ignore All Agent, All Company & ALL type conditions with value = 0
				!($row->name == "type" && trim( mosGetParam( $_POST, $row->name, '' ) ) == '0') && 
				!($row->name == "agent" && trim( mosGetParam( $_POST, $row->name, '' ) ) == '0') && 
				!($row->name == "company" && trim( mosGetParam( $_POST, $row->name, '' ) ) == '0') ) {

				$where = $row->name ." <> '".trim( mosGetParam( $_POST, $row->name, '' ) )."'";
				$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
				if(!$database->query()) {
					echo $database->getErrorMsg();
				}
			}

		} elseif( 
			($row->field_type == "checkbox" || $row->field_type == "selectmultiple") 
			&& trim( mosGetParam( $_POST, $row->name, '' )) <> '' ) {

			$tmp = mosGetParam( $_POST, $row->name, '' );
			if (is_array($tmp) && count($tmp) > 0) {
				foreach($tmp AS $t) {
					if (!empty($t)) 
					{
						$where = "FIND_IN_SET('".$t."', ".$row->name.") < 1";
						$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
						if(!$database->query()) {
							echo $database->getErrorMsg();
						}
					}
				}
			} 
		} elseif($row->field_type == "radiobutton" && trim( mosGetParam( $_POST, $row->name, '' )) <> '' ) {
			
			$where = $row->name ." <> '".trim( mosGetParam( $_POST, $row->name, '' ) )."'";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) 
			{
				echo $database->getErrorMsg();
			}

		} elseif($row->search_type == "range_1" && trim( mosGetParam( $_POST, $row->name."_range", '' )) <> '' && trim( mosGetParam( $_POST, $row->name, '' )) <> '' ) {
			# Delete all records which has empty value
			$where = $row->name ." = ''";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) echo $database->getErrorMsg();

			if (trim( mosGetParam( $_POST, $row->name."_range", '' ) ) == '0' ) {
				$where = $row->name ." >= ".intval( trim( mosGetParam( $_POST, $row->name, 0 ) ) );
				$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
				if(!$database->query()) 
				{
					echo $database->getErrorMsg();
				}

			} else {
				$where = $row->name ." <= ".intval( trim( mosGetParam( $_POST, $row->name, 0 ) ) );
				$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
				if(!$database->query()) {
					echo $database->getErrorMsg();
				}
			}

		} elseif($row->search_type == "range_2" && (trim( mosGetParam( $_POST, $row->name."_from", '' )) <> '' || trim( mosGetParam( $_POST, $row->name."_to", '' )) <> '') ) {
			# Delete all records which has empty value
			$where = $row->name ." = ''";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) echo $database->getErrorMsg();
			
			# Delete lower bound
			if (mosGetParam( $_POST, $row->name."_from", '' ) <> '') {
				$where = $row->name ." < ".intval( trim( mosGetParam( $_POST, $row->name."_from", '' ) ) );
				$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
				if(!$database->query()) {
					echo $database->getErrorMsg();
				}
			}

			# Delete upper bound
			if (mosGetParam( $_POST, $row->name."_to", '' ) <> '') {
				$where = $row->name ." > ".intval( trim( mosGetParam( $_POST, $row->name."_to", '' ) ) );
				$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
				if(!$database->query()) {
					echo $database->getErrorMsg();
				}
			}

		} elseif($row->search_type == "range_3" && mosGetParam( $_POST, $row->name, 0 ) == '1' && trim( mosGetParam( $_POST, $row->name."_from_y", '' )) <> '' && trim( mosGetParam( $_POST, $row->name."_from_m", '' )) <> '' && trim( mosGetParam( $_POST, $row->name."_from_d", '' )) <> '' && trim( mosGetParam( $_POST, $row->name."_to_y", '' )) <> '' && trim( mosGetParam( $_POST, $row->name."_to_m", '' )) <> '' && trim( mosGetParam( $_POST, $row->name."_to_d", '' )) <> '' ) {

			# Delete lower bound
			$where = $row->name ." < '".trim( mosGetParam( $_POST, $row->name."_from_y", '' ) )."-".trim( mosGetParam( $_POST, $row->name."_from_m", '' ) )."-".trim( mosGetParam( $_POST, $row->name."_from_d", '' ) )."'";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) {
				echo $database->getErrorMsg();
			} 
			
			# Delete upper bound
			$where = $row->name ." > '".trim( mosGetParam( $_POST, $row->name."_to_y", '' ) )."-".trim( mosGetParam( $_POST, $row->name."_to_m", '' ) )."-".trim( mosGetParam( $_POST, $row->name."_to_d", '' ) )."'";
			$database->setQuery("DELETE FROM #__hp_temp WHERE ".$where);
			if(!$database->query()) {
				echo $database->getErrorMsg();
			} 

		} 
	}

	if (empty($where)) {
		hotproperty_HTML::show_advSearchResults_error(_HP_SEARCH_NOSEARCH);
	} else {
		# How many results?
		$database->setQuery('SELECT COUNT(id) FROM #__hp_temp');
		$total = $database->loadResult();
		if($total <= 0) 
		{
			hotproperty_HTML::show_advSearchResults_error(_HP_SEARCH_NORESULT);
		} else {
			
			# Store this search for later retrieval.
			$database->setQuery("INSERT INTO #__hp_search_results (search_text) VALUES ('".serialize($_POST)."')");		
			if(!$database->query())
			{
				echo $database->getErrorMsg();
			}


			# Get the above search ID
			$database->setQuery("SELECT search_id FROM #__hp_search_results WHERE search_text ='".serialize($_POST)."'");		
			$database->query();
			$search_id = $database->loadResult();

			# Retrieve the properties' ID
			$database->setQuery('SELECT id FROM #__hp_temp');
			$ids = $database->loadResultArray();
			unset($where);
			$where[] = 'p.id IN ('.implode(',',$ids).')';
			################## PERFECTURE FILTER ###################
			$perfectureCookie = mosGetParam( $_COOKIE, 'perfecture', null );
			if (isset($perfectureCookie["perfecture"]) && $perfectureCookie["perfecture"] != "") {	
				if ( $perfectureCookie == "outside") {
					$where[] .= "p.country LIKE '%yes%'";
					#echo "set the country 4" . $perfectureCookie["perfecture"];
				} else {
					$where[] .= "p.state LIKE '%" . $perfectureCookie . "%'";
				}
			}
			################## PERFECTURE FILTER ###################

	
			# Setup pagination
			$limit = trim( mosGetParam( $_REQUEST, 'limit', $hp_default_limit_search) );
			$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

			HP_getProperty('listing', $where, $prop, $caption);
			$total = count($prop);
			$pageNav = new mosPageNav( $total, $limitstart, $limit );			
			
			unset($prop);
			HP_getProperty('listing', $where, $prop, $caption, $limitstart, $limit);

			hotproperty_HTML::show_advSearchResults($search_id, $prop, $caption, $pageNav, $searchString);	
		}

	}

}

/**
* Display the Advanced Search Form
*/
function searchAdv() {
	global $database, $hp_use_advsearch, $Itemid;

	if ($hp_use_advsearch <> '1') {
		mosRedirect(sefRelToAbs('index.php?option=com_hotproperty&Itemid='.$Itemid)) ;		
	}


	$sql = "SELECT * FROM #__hp_prop_ef WHERE search=1 AND published=1 AND hidden=0 ORDER BY iscore DESC,  ordering ASC";
	$database->setQuery($sql);
	$rows = $database->loadObjectList();

	$sql = "SELECT name, field_elements FROM #__hp_prop_ef WHERE search=1 AND published=1 AND hidden=0 ORDER BY iscore DESC,  ordering ASC";
	$database->setQuery($sql);
	$rows_elements = $database->loadObjectList("name");
	$i = 0;
	foreach($rows AS $row) {

		$fields[$i]->name = $row->name;
		$fields[$i]->caption = $row->search_caption;
		
		if ( !isset($fields[$i]->input) ) $fields[$i]->input = '';

		unset($list);

		# Handle core field's search
		if ($row->iscore) {

			# ------------ Type
			if ($row->name == "type") {
				# Select published types
				$database->setQuery( "SELECT * FROM #__hp_prop_types AS t"
					. "\nWHERE t.published='1'"
					. "\nORDER BY t.ordering ASC");
				$types = $database->loadObjectList();
				
				$search_types = array();
				$search_types[] = mosHTML::makeOption( '0', _HP_SEARCH_ALLTYPES );
				foreach($types AS $type) { 
					$search_types[] = mosHTML::makeOption( $type->id, $type->name );
				}

				$fields[$i]->input = mosHTML::selectList( $search_types, $row->name, 'class="inputbox" size="1"',	'value', 'text', '0');
			} 
			# ------------ Price
			elseif ($row->name == "price") {
				$fields[$i]->input = mosHTML_hp::rangeText( $row->name, 'size="8" class="inputbox"');
			}
			# ------------ Featured
			elseif ($row->name == "featured") {
				$fields[$i]->input .= ' <input type="checkbox" name="'.$row->name.'" value="1" /> ';
			}
			# ------------ Agent
			elseif ($row->name == "agent") {
				# Get Agents that has at least one property
				$database->setQuery("SELECT a.*, COUNT(p.id) AS properties, c.id AS companyid, c.name AS company FROM (#__hp_agents AS a, #__hp_prop_types AS t)"
					.	"\nLEFT JOIN #__hp_companies AS c ON c.id=a.company"
					.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
					.	"\nWHERE t.id=p.type"
					. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
					. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
					. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
					.	"\nGROUP BY p.agent");
				$agents = $database->loadObjectList();
			
				$search_agents = array();
				$search_agents[] = mosHTML::makeOption( '0', _HP_SEARCH_ALLAGENTS );
				foreach($agents AS $agent) { 
					$search_agents[] = mosHTML::makeOption( $agent->id, $agent->name );
				}

				$fields[$i]->input = mosHTML::selectList( $search_agents, $row->name, 'class="inputbox" size="1"',	'value', 'text', '0');
			}
			# ------------ Company
			elseif ($row->name == "company") {
				# Get Companies that has at least one property
				$database->setQuery("SELECT c.name, c.id FROM #__hp_companies AS c"
					.	"\nLEFT JOIN #__hp_agents AS a ON c.id=a.company"
					.	"\nLEFT JOIN #__hp_properties AS p ON p.agent=a.id"
					.	"\nLEFT JOIN #__hp_prop_types AS t ON t.id=p.type"
					.	"\nWHERE t.id=p.type"
					. "\n AND p.published='1' AND p.approved='1' AND t.published='1'"
					. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
					. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
					.	"\nGROUP BY a.company");
				$companies = $database->loadObjectList();
				
				$search_companies = array();
				$search_companies[] = mosHTML::makeOption( '0', _HP_SEARCH_ALLCOMPANIES );
				foreach($companies AS $company) { 
					$search_companies[] = mosHTML::makeOption( $company->id, $company->name );
				}

				$fields[$i]->input = mosHTML::selectList( $search_companies, $row->name, 'class="inputbox" size="1"',	'value', 'text', '0');
			}
			# ------------ Hits
			elseif ($row->name == "hits") {
				$search_hits = array();
				$search_hits[] = mosHTML::makeOption( '0', _HP_SEARCH_LESS_THAN );
				$search_hits[] = mosHTML::makeOption( '1', _HP_SEARCH_MORE_THAN );

				$fields[$i]->input = mosHTML::selectList( $search_hits, "hits_range", 'class="inputbox" size="1"',	'value', 'text', '1');
				$fields[$i]->input .= '&nbsp; <input type="text" name="hits" class="inputbox" size="8" />';
			}
			# ------------ Created
			elseif ($row->name == "created") {
				# Get min & max year from available properties
				$sql = "SELECT MIN(created) AS start, MAX(created) AS end FROM #__hp_properties AS p"
					. "\nLEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
					. "\nWHERE p.published='1' AND p.approved='1' AND t.published='1'"
					. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
					. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
					.	"\n AND created <> '0000-00-00 00:00:00'";
				$database->setQuery($sql);
				$database->loadObject($created);

				$fields[$i]->input = mosHTML_hp::rangeDateSelectList( $row->name, '', $selected, strtotime($created->start), strtotime($created->end) );
			}
			# ------------ Modified
			elseif ($row->name == "modified") {
				# Get min & max year from available properties
				$sql = "SELECT MIN(modified) AS start, MAX(modified) AS end FROM #__hp_properties AS p"
					. "\nLEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
					. "\nWHERE p.published='1' AND p.approved='1' AND t.published='1'"
					. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
					. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
					.	"\n AND created <> '0000-00-00 00:00:00'";
				$database->setQuery($sql);
				$database->loadObject($modified);

				$fields[$i]->input = mosHTML_hp::rangeDateSelectList( $row->name, '', $selected, strtotime($modified->start), strtotime($modified->end) );
			}
			# Other Core fields will use normal inputbox
			# Postcode, Name, State, Country, Suburb, Intro Text, Full Text
			else {
				$fields[$i]->input = ' <input type="text" name="'.$row->name.'" size="35" class="inputbox" /> ';
			}

		} 
		# Non-core Extra Fields
		else {
			if ($row->search_type == "range_1") {
				$range_1_options = array();
				$range_1_options[] = mosHTML::makeOption( '0', _HP_SEARCH_LESS_THAN );
				$range_1_options[] = mosHTML::makeOption( '1', _HP_SEARCH_MORE_THAN );

				$fields[$i]->input = mosHTML::selectList( $range_1_options, $row->name."_range", 'class="inputbox" size="1"',	'value', 'text', '1');
				$fields[$i]->input .= '&nbsp; <input type="text" name="'.$row->name.'" class="inputbox" size="'.$row->size.'" />';
			} 
			elseif ($row->search_type == "range_2") {
				$fields[$i]->input = mosHTML_hp::rangeText( $row->name, 'size="'.$row->size.'" class="inputbox"');
			}
			elseif ($row->field_type == "link" || $row->field_type == "text" || $row->field_type == "multitext") {
				$fields[$i]->input = ' <input type="text" name="'.$row->name.'" size="'.(($row->field_type == "multitext") ? '20' : $row->size).'" class="inputbox" /> ';
			}
			elseif ( $row->field_type == "selectlist" ) {
				$olist_translated_caption = explode("|",$row->field_elements);
				$olist = explode("|",$rows_elements[$row->name]->field_elements);
				$list[] = mosHTML::makeOption( " " );
				$j=0;
				foreach($olist AS $li) { 
					$list[] = mosHTML::makeOption( trim($li),$olist_translated_caption[$j++] );
				}
				$fields[$i]->input = mosHTML::selectList( $list, $row->name, 'class="inputbox" size="1"',	'value', 'text', ' ');
			}
			elseif ( $row->field_type == "radiobutton" ) {
				$olist_translated_caption = explode("|",$row->field_elements);
				$olist = explode("|",$rows_elements[$row->name]->field_elements);
				$j=0;
				foreach($olist AS $li) { 
					$fields[$i]->input .= '<input type="radio" name="'.$row->name.'" value="'.trim($li).'"> '.trim($olist_translated_caption[$j++]). "<br />";
				}
			}
			elseif ( $row->field_type == "checkbox" ) {
				$olist_translated_caption = explode("|",$row->field_elements);
				$olist = explode("|",$rows_elements[$row->name]->field_elements);
				$j=0;				
				foreach($olist AS $li) { 
					$fields[$i]->input .= "<input type='checkbox' name='".$row->name."[]' value='".trim($li)."'> ".trim($olist_translated_caption[$j++]). "<br />";
				}
			} elseif ( $row->field_type == "selectmultiple" ) {
				$olist_translated_caption = explode("|",$row->field_elements);
				$olist = explode("|",$rows_elements[$row->name]->field_elements);
				$fields[$i]->input .= "<select multiple name='".$row->name."[]' size='".$row->size."' class='inputbox'>";
				$j=0;
				foreach($olist AS $li) { 
					$fields[$i]->input .= "<option value='".$li."' > ".trim($olist_translated_caption[$j++]). "</option>";
				}
				$fields[$i]->input .= "</select>";
			}

		}
		$i++;
	}

	hotproperty_HTML::show_AdvSearch($fields);	
}

function emailContentForm() {
	global $database;

	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );

	# Retrieve the Property title
	$database->setQuery("SELECT name FROM #__hp_properties WHERE id='$id' LIMIT 1");
	$title = $database->loadResult();

	hotproperty_HTML::sendEmailForm( $id, $title );

}

function emailContentSend() {
	global $database;
	global $mosConfig_live_site, $mosConfig_sitename, $mosConfig_sef, $option;

	josSpoofCheck(1);

	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
	$email = trim( mosGetParam( $_POST, 'email', '' ) );
	$yourname = trim( mosGetParam( $_POST, 'yourname', '' ) );
	$youremail = trim( mosGetParam( $_POST, 'youremail', '' ) );

	if ($mosConfig_sef) {
		$url = sefRelToAbs("index.php?option=com_hotproperty&amp;task=view&amp;id=".$id);
	} else {
		// Get Itemid
		$database->setQuery("SELECT id FROM #__menu WHERE link='index.php?option=$option'");
		$Itemid = $database->loadResult();
		$url = $mosConfig_live_site .'/'. "index.php?option=com_hotproperty&task=view&id=$id&Itemid=$Itemid";
	}

	if (!$email || !$youremail || (is_email($email)==false) || (is_email($youremail)==false) ){
		echo "<script>alert (\""._EMAIL_ERR_NOINFO."\"); window.history.go(-1);</script>";
		exit(0);
	}

	$msg = sprintf( _EMAIL_MSG,	$mosConfig_sitename, $yourname,	$youremail,	$url);

	$recipient = $email;
	$subject = _EMAIL_INFO." $yourname";
	$headers .= "From: ".$yourname." <".$youremail.">\r\n";
	$headers .= "Reply-To: <".$youremail.">\r\n";
	$headers .= "X-Priority: 3\r\n";
	$headers .= "X-MSMail-Priority: Low\r\n";
	$headers .= "X-Mailer: ARCH TCC - Property\r\n\r\n";
//	mosMail($yourmail,$yourname,$recipient,$subject,$msg);

//	hotproperty_HTML::emailSent( $email );
}

function showpdf() {
	$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
	include ("components/com_hotproperty/includes/pdf.php");
	exit();
}

class mosHTML_hp {

	function rangeDateSelectList( $tag_name, $tag_attribs, $selected, $from, $to ) {
		$search_created_yyyy = array();
		$search_end_yyyy = array();
		$search_mm = array();
		$search_dd = array();

		$result = '<input type="radio" name="'.$tag_name.'" value="0" checked /> '._HP_ANYTIME. "<br />";
		$result .= '<input type="radio" name="'.$tag_name.'" value="1"> ';

		# Generate Generic Days drop down
		for($j=1 ; $j<=31 ; $j++) {
			$search_dd[] = mosHTML::makeOption( $j );
		}

		# Generate Start's YYYY drop down
		for($j=date('Y',$from) ; $j<=date('Y',$to) ; $j++) {
			$search_created_yyyy[] = mosHTML::makeOption( $j );
		}
		$result .= mosHTML::selectList( $search_created_yyyy, $tag_name."_from_y", 'class="inputbox" size="1"',	'value', 'text', date('Y',$from));
		# Generate Start's MM drop down
		$result .= mosHTML::monthSelectList( $tag_name."_from_m", 'class="inputbox" size="1"',	date('m',$from));
		# Generate Start's DD drop down
		$result .= mosHTML::selectList( $search_dd, $tag_name."_from_d", 'class="inputbox" size="1"',	'value', 'text', date('j',$from));

		$result .= _HP_SEARCH_TO;

		# Generate End's YYYY drop down
		for($j=date('Y',$to) ; $j<=date('Y',$to) ; $j++) {
			$search_end_yyyy[] = mosHTML::makeOption( $j );
		}
		$result .= mosHTML::selectList( $search_end_yyyy, $tag_name."_to_y", 'class="inputbox" size="1"',	'value', 'text', date('Y',$to));
		# Generate End's MM drop down
		$result .= mosHTML::monthSelectList( $tag_name."_to_m", 'class="inputbox" size="1"',	date('m',$to));
		# Generate End's DD drop down
		$result .= mosHTML::selectList( $search_dd, $tag_name."_to_d", 'class="inputbox" size="1"',	'value', 'text', date('j',$to));

		return $result;
	}
	
	function rangeText( $tag_name, $tag_attribs ) {
		$result = _HP_SEARCH_FROM;
		$result .= ' <input type="text" name="'.$tag_name.'_from"'.(($tag_attribs) ? " ".$tag_attribs : "").' />';
		$result .= _HP_SEARCH_TO;
		$result .= ' <input type="text" name="'.$tag_name.'_to"'.(($tag_attribs) ? " ".$tag_attribs : "").' />';

		return $result;
	}

}
?>