<?php
// $Id: rss.hotproperty.php
/**
* Hot Property RSS Feeds
*
* @package Hot Property 0.9
* @copyright (C) 2004 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <cy@mosets.com>
**/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//global $database, $mainframe, $my, $Itemid;

$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

$menu= new mosMenu( $database );
$menu->load( 1 );
$params = mosParseParams( $menu->params );

$count = isset( $params->count ) ? $params->count : 6;
$orderby = @$params->orderby;

switch (strtolower( $orderby )) {
	case 'latest':
		$orderby = "p.created DESC";
		break;
	case 'hottest':
		$orderby = "p.hits DESC";
		break;
	default:
		$orderby = "p.created DESC";
		break;
}

$sql = "SELECT p.id, p.name, p.intro_text, p.address, p.suburb, p.state, p.modified FROM #__hp_properties AS p"
//photos.thumb,
//		. "\nRIGHT JOIN #__hp_photos AS photos ON p.id = photos.property"
//		. "\nLEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
		. "\nRIGHT JOIN #__hp_featured AS f ON f.property = p.id"
		. "\nWHERE p.published='1' AND p.approved='1'"
#		. "\n	AND (p.publish_up = '0000-00-00 00:00:00' OR p.publish_up <= '$now')"
#		. "\n	AND (p.publish_down = '0000-00-00 00:00:00' OR p.publish_down >= '$now')"
	  . "\nORDER BY ".$orderby
    . ($count ? " LIMIT $count" : "");
    
$database->setQuery( $sql );

$rows = $database->loadObjectList();

header('Content-type: application/xml');
$encoding = split("=", _ISO);
echo "<?xml version=\"1.0\" encoding=\"".$encoding[1]."\"?>"; ?>
<rss version="2.0"
	xmlns:content="http://purl.org/rss/1.0/modules/content/"
	xmlns:wfw="http://wellformedweb.org/CommentAPI/"
	xmlns:dc="http://purl.org/dc/elements/1.1/">
<channel>
<title><?php echo htmlspecialchars($mosConfig_sitename); ?></title>
<link><?php echo $mosConfig_live_site; ?></link>
<description>Notre agence immobilière située à Agia Pélagia vous propose tous les types de propriétés dans toute la Crète: maisons, villas, terrains, locations, commerces.</description>
<language>fr</language>
<lastBuildDate><?php $date = date("r"); echo "$date";?></lastBuildDate>
	<image>
	<title><?php echo $mosConfig_sitename; ?></title>
	<url><?php echo $mosConfig_live_site; ?>/images/M_images/casadicandia_logo.png</url>
	<link><?php echo $mosConfig_live_site; ?></link>
	<width>153</width>
	</image>
<?php
foreach ($rows as $row) {
	$sql = "SELECT p.thumb, p.property FROM #__hp_photos AS p" . "\n WHERE p.property=" . $row->id . " LIMIT 1";
	$database->setQuery( $sql );
	$photos = $database->loadObjectList();

	echo ("<item>");
	echo ("\n<title>".htmlspecialchars($row->name)."</title>");
	echo ("\n<pubDate>".$row->modified."</pubDate>");
	$creatorString = $row->address . ", " . $row->suburb . ", " . $row->state ." | " . $row->id;
	echo ("\n<dc:creator><![CDATA[". $creatorString . "]]></dc:creator>");
	echo "\n<link>";
	if ($mosConfig_sef == "1"){
		echo sefRelToAbs("index.php?option=com_hotproperty&amp;task=view&amp;id=".$row->id);
	} else {
		echo $mosConfig_live_site . "/index.php?option=com_hotproperty&amp;task=view&amp;id=" . $row->id;
	}
	echo "</link>";
	$words = $row->intro_text;
	$words = preg_replace("'<script[^>]*>.*?</script>'si","",$words);
	$words = preg_replace('/<a\s+.*?href="([^"]+)"[^>]*>([^<]+)<\/a>/is','\2 (\1)', $words);
	$words = preg_replace('/<!--.+?-->/','',$words);
	$words = preg_replace('/{.+?}/','',$words);
	$words = preg_replace('/&nbsp;/',' ',$words);
	$words = preg_replace('/&amp;/',' ',$words);
	$words = preg_replace('/&quot;/',' ',$words);
	$words = strip_tags($words);
	$words = htmlspecialchars($words);
	echo ("\n<description>".substr($words,0,600)."...</description>");
	echo "<content:encoded><![CDATA[";
	if ($photos[0]->thumb <> "" ) {
		echo "<img src='".$mosConfig_live_site.$hp_imgdir_thumb.$photos[0]->thumb."' align='left' />";
	}
	echo $words . "]]></content:encoded>";
	echo ("</item>");
}
?>
</channel>
</rss>
