<?php
/**
* @version $Id: pdf.php 4562 2006-08-18 23:26:32Z stingrey $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
* Created by Phil Taylor me@phil-taylor.com
* Support file to display PDF Text Only using class from - http://www.ros.co.nz/pdf/readme.pdf
* HTMLDoc is available from: http://www.easysw.com/htmldoc and needs installing on the server for better HTML to PDF conversion
**/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

function dofreePDF() {

/************************ Start editing here ************************/

	$lang = 		'el';				// Language
	$enc = 			'UTF-8';			// Encoding
	$unit = 		'mm';				// Unit of measurement
	$format = 		'A4';		 		// Page format
	$orient = 		'P';		 		// Page orientation
	$fnt = 			'FreeSerif'; 		// Font name
	$size = 		10; 				// Font size
	$mrgleft = 		20;					// Left margin
	$mrgright = 	20;					// Right margin
	$mrgtop = 		40;					// Top margin
	$mrgbottom = 	30;					// Bottom margin
	$mrghead = 		20;					// Header margin
	$mrgfoot = 		20;					// Footer margin
	$scale = 		1;					// Image scale factor

/************************ Stop editing here ************************/

	global $mosConfig_live_site, $mosConfig_sitename, $mosConfig_offset;
	global $mainframe, $database, $my;
	
	$id 		= intval( mosGetParam( $_REQUEST, 'id', 1 ) );
	
	$gid 		= $my->gid;
	$now 		= _CURRENT_SERVER_TIME;
	$nullDate 	= $database->getNullDate();
	
	// query to check for state and access levels
	$query = "SELECT a.*, cc.name AS category, s.name AS section, s.published AS sec_pub, cc.published AS cat_pub,"
	. "\n  s.access AS sec_access, cc.access AS cat_access, s.id AS sec_id, cc.id as cat_id"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__sections AS s ON s.id = cc.section AND s.scope = 'content'"
	. "\n WHERE a.id = $id"
	. "\n AND a.state = 1"
	. "\n AND a.access <= $gid"
	. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
	. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"	
	;	
	$database->setQuery( $query );
	$row = NULL;
	
	if ( $database->loadObject( $row ) ) {
		/*
		* check whether category is published
		*/
		if ( !$row->cat_pub && $row->catid ) {
			mosNotAuth();  
			return;
		}
		/*
		* check whether section is published
		*/
		if ( !$row->sec_pub && $row->sectionid ) {
			mosNotAuth(); 
			return;
		}
		/*
		* check whether category access level allows access
		*/
		if ( ($row->cat_access > $gid) && $row->catid ) {
			mosNotAuth();  
			return;
		}
		/*
		* check whether section access level allows access
		*/
		if ( ($row->sec_access > $gid) && $row->sectionid ) {
			mosNotAuth();  
			return;
		}
		
		$langfile = 'tcpdf/config/lang/' .  $lang . '.php';
		
		require_once("$langfile");
		require_once('tcpdf/tcpdf.php');

		$htmlcontent = $row->introtext ."<p>". $row->fulltext;

		//create new PDF document (document units are set by default to millimeters)
		$pdf = new TCPDF($orient, $unit, $format, true, $enc); 

		// set document information
		$pdf->SetCreator($row->created_by_alias);
		$pdf->SetAuthor($row->created);
		$pdf->SetTitle($row->title);
		$pdf->SetSubject($row->metadesc);
		$pdf->SetKeywords($row->metakey);

		$pdf->SetHeaderData("", "", $mosConfig_sitename, $row->title . "\n" . $row->created_by_alias);

		//set margins
		$pdf->SetMargins($mrgleft, $mrgtop, $mrgright);
		//set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, $mrgbottom);
		$pdf->SetHeaderMargin($mrghead);
		$pdf->SetFooterMargin($mrgfoot);
		$pdf->setImageScale($scale); //set image scale factor

		$pdf->setHeaderFont(Array($fnt, '', $size));
		$pdf->setFooterFont(Array($fnt, '', $size));

		$pdf->setLanguageArray($l); //set language items

		//initialize document
		$pdf->AliasNbPages();

		$pdf->AddPage();

		// output some HTML code
		$pdf->writeHTML($htmlcontent, true, 0);

		//Close and output PDF document
		$pdf->Output();

	} else {
		mosNotAuth();
		return;
	}
}

dofreePDF();
?>