<?php
/**
* @version $Id: mosthumb.php,v 1.4 2004/12/05 15:05:34 manni Exp $
* @package Mambo_4.5.1
* @copyright (C) 2004 Manfred Dennerlein
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
* Based on MOS Image Mambot
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botlightThumb' );


/**
*/
function botlightThumb( $published, &$row, &$params, $page=0  ) {
	global $mosConfig_absolute_path, $mosConfig_live_site, $database;

	if (!$published ) {
	    return true;
	}
	include_once($mosConfig_absolute_path."/mambots/content/lightThumb/class.img2thumb.inc");

	//Get parameters from Database
	$query = "SELECT id FROM #__mambots WHERE element = 'lightThumb' AND folder = 'content'";

	$database->setQuery( $query );
	$id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load( $id );
	$param =& new mosParameters( $mambot->params );
	
			$enable_thumbs = $param->get('enable_thumbs', 1);
			$newxsize = $param->get('newxsize',150);
			$newysize = $param->get('newysize',150);
			$use_popups = $param->get('use_popups', 1);
			$maxsize  = $param->get('maxsize',0);
			$enable_cache = $param->get('enable_cache',1);
			$caption = $param->get('caption', 1);

	// assemble the images
	$images = array();

	// split on \n the images fields into an array
	$row->images = explode( "\n", $row->images );

		// needed to stopping loading of images for the introtext
	$start = 0;
	if ( !$params->get( 'introtext' ) && strstr( $row->introtext, '{mosimage}' ) ) {
		$search 		= explode( '{mosimage}', $row->introtext );
		$start 		= count( $search ) - 1;
	}
	$total 			= count( $row->images );

	$m_img = trim( $row->images[0] );
	if ($m_img) { ?>
	<link rel="stylesheet" type="text/css" href="/mambots/content/lightThumb/css/shadowbox.css" />
	<script type="text/javascript" src="/mambots/content/lightThumb/adapter/shadowbox-mootools.js"></script>
	<script type="text/javascript" src="/mambots/content/lightThumb/shadowbox.js"></script><script type="text/javascript">window.onload = function(){ var o = { loadingImage: '/mambots/content/lightThumb/loading.gif' }; Shadowbox.init(o); };</script>
	<?php }
for ( $i = $start; $i < $total; $i++ ) {
		$img = trim( $row->images[$i] );
		
		// split on pipe the attributes of the image
		if ($img) {
			$temp = explode( '|', trim( $img ) );
			if ( !isset($temp[1]) || !$temp[1] ) {
				$temp[1] = '';
			}
			if ( !isset($temp[2]) || !$temp[2] ) {
				$temp[2] = 'Image';
			} else {
				$temp[2] = htmlspecialchars( $temp[2] );
			}
			if ( !isset($temp[3]) || !$temp[3] ) {
				$temp[3] = '0';
			}
			$size = '';
			
			if($temp[2]=='Image') 
				$myCaption = 0;
			else
				$myCaption = $caption;
			
			// assemble the image tag
			if (function_exists( 'getimagesize' )) {
				$size = @getimagesize( $mosConfig_absolute_path .'/images/stories/'. $temp[0] );
				if (is_array( $size )) {
				$oldxsize=$size[0];
				$oldysize=$size[1];
					$size = $size[3];
				}
			}
			//Thumb only if defined size is exceeded)
			if( ($newxsize<$oldxsize || $newysize < $oldysize) && ($enable_thumbs) )	{
			//Cache only works if thumbnail generated has same name, 
			//if extension is other than .gif, .jpg, .png (lowercase) or gif creation is not supported(saved as png)
			//then caching will not work.
			$thumb_file = str_replace('/','_',$temp[0]);
				if(!file_exists($mosConfig_absolute_path .'/mambots/content/lightThumb/thumbs/'. $thumb_file ) || $enable_cache==0) {
					$thumb = new Img2Thumb($mosConfig_absolute_path .'/images/stories/'. $temp[0],$newxsize,$newysize,$mosConfig_absolute_path .'/mambots/content/lightThumb/thumbs/'. $thumb_file);
					$thumb_file = $thumb->getFileOut();
				}
				//get new size of thumb
				if($maxsize) {
					$size = 'width="'. $newxsize .'" height="'. $newysize .'"';
					}
				else {
					if (function_exists( 'getimagesize' )) {
					$size = @getimagesize( $mosConfig_absolute_path .'/mambots/content/lightThumb/thumbs/'. $thumb_file  );
					if (is_array( $size )) {
						$size = $size[3];
						}
					}
				}


				switch ($myCaption) 
				{
					case 0: //no caption
					default:
						$img = '<div class="thumbnail'. $temp[1] .'">';
							if ($use_popups) 
							{
								// Replace all empty characters to underscore in alt -tags
								$find[] = ' ';
								$replace[] = "-";
								$temp[2] = str_replace($find, $replace, $temp[2]);
									$img .= '<a rel="shadowbox['. $temp[2] .']" href="'.$mosConfig_live_site .'/images/stories/'. $temp[0].'">';
									$img .= '<img src="'. $mosConfig_live_site  .'/mambots/content/lightThumb/thumbs/'. $thumb_file .'" '. $size;
						    	$img .= $temp[1] ? '  ' : '';
						    	$img .=' alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
									$img .= '</a>';
							}
							else 
							{
								$img .= '<img src="'. $mosConfig_live_site  .'/mambots/content/lightThumb/thumbs/'. $thumb_file .'" '. $size;
						    $img .= $temp[1] ? ' align="'. $temp[1] .'" ' : '';
						    $img .=' alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
						  }
						$img .= '</div>';
						
						break;
						
					case 1: //caption below: Float left or right based on the mosimage settings
						$find[] = ' ';
						$replace[] = "-";
						$temp[2] = str_replace($find, $replace, $temp[2]);
								
						$img = '<div class="thumbnail'. $temp[1] .'">';
							if ($use_popups) $img .= '<a rel="shadowbox['. $temp[2] .']" title="'. $temp[4] .'" href="'.$mosConfig_live_site .'/images/stories/'. $temp[0].'">';
							$img .= '<img src="'. $mosConfig_live_site  .'/mambots/content/lightThumb/thumbs/'. $thumb_file .'" '. $size;
					    	$img .='  alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
							if ($use_popups) $img .='</a>';
						$img .='<div class="caption">';
						$img .= ''.$temp[4].'</div>';
						$img .= '</div>';
						break;
					case 2:	//caption above: Float left or right based on the mosimage settings
						$find[] = ' ';
						$replace[] = "-";
						$temp[2] = str_replace($find, $replace, $temp[2]);
						$img = '<div class="thumbnail'. $temp[1] .'">';
						$img .= '<div class="caption">';
							$img .= ''.$temp[4].'</div>';
                                                        if ($use_popups) $img .= '<a rel="shadowbox['. $temp[2] .']" title="'. $temp[4] .'" href="'.$mosConfig_live_site .'/images/stories/'. $temp[0].'">';
							$img .= '<img src="'. $mosConfig_live_site  .'/mambots/content/lightThumb/thumbs/'. $thumb_file .'" '. $size;
					    	$img .='  alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
							if ($use_popups) $img .='</a>';
						$img .= '</div>';
						break;
				}
		  $images[] = $img;
			}
			else {
				switch ($myCaption) 
				{
					case 0: //no caption
					default:
							 $img = '<div class="thumbnail'. $temp[1] .'">';
					   	 $img .= '<img src="'. $mosConfig_live_site .'/images/stories/'. $temp[0] .'" '. $size;
				       $img .= $temp[1] ? ' ' : '';
				       $img .='  alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
				       $img .= '</div>';
				       $images[] = $img;
					   break;
					case 1: //caption below
						$img = '<div class="thumbnail'. $temp[1] .'">';
						$img .= '<img src="'. $mosConfig_live_site .'/images/stories/'. $temp[0] .'" '. $size;
				        $img .='  alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
						$img .='<div class="caption">';
						$img .= ''.$temp[4].'</div>';
						$img .= '</div>';
				        $images[] = $img;
						break;
					case 2: //caption above
						$img = '<div class="thumbnail'. $temp[1] .'">';
						$img .= '<div class="caption">';
						$img .= ''.$temp[4].'</div>';
						$img .= '<img src="'. $mosConfig_live_site .'/images/stories/'. $temp[0] .'" '. $size;
				        $img .='  alt="'. $temp[2] .'" title="'. $temp[4] .'" border="'. $temp[3] .'" />';
						$img .= '</div>';
				    	$images[] = $img;
						break;
				}
		  }
		}
	}

	// define the regular expression for the bot
	$regex = '#{mosimage}#s';

	// store some vars in globals to access from the replacer
	$GLOBALS['botMosImageCount'] = 0;
	$GLOBALS['botMosImageParams'] =& $params;
	$GLOBALS['botMosImageArray'] =& $images;

	// perform the replacement
	$row->text = preg_replace_callback( $regex, 'botlightThumb_replacer', $row->text );

	// clean up globals
	unset( $GLOBALS['botMosImageCount'] );
	unset( $GLOBALS['botMosImageMask'] );
	unset( $GLOBALS['botMosImageArray'] );

	return true;
}
/**
* Replaces the matched tags an image
* @param array An array of matches (see preg_match_all)
* @return string
*/
function botlightThumb_replacer( &$matches ) {
	$i = $GLOBALS['botMosImageCount']++;
	return @$GLOBALS['botMosImageArray'][$i];
}

?>
