<?php
defined( '_VALID_MOS' ) or die( 'Restricted Access.' );

$version = "1.1.1";

require_once( $mainframe->getCfg('absolute_path') . '/mambots/editors/jce/jscripts/tiny_mce/libraries/classes/jce.class.php' );
require_once( $mainframe->getCfg('absolute_path') . '/mambots/editors/jce/jscripts/tiny_mce/libraries/classes/jce.utils.class.php' );

$jce = new JCE();
$jce->setPlugin('caption');

require_once( $jce->getLibPath() . '/classes/jce.class.php' );

//Setup languages
include_once( $jce->getLibPath() . '/langs/' . $jce->getLanguage() . '.php' );
include_once(  $jce->getPluginPath() . '/langs/' . $jce->getPluginLanguage() . '.php' );

//Load Plugin Parameters
$params = $jce->getPluginParams();

?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title><?php echo $jce->translate('desc');?> : <?php echo $version;?></title>
   <meta http-equiv="Content-Type" content="text/html; charset=<?php echo $jce->translate('iso');?>" />
	<?php 
	echo $jce->printLibJs( 'tiny_mce_utils' );
	echo $jce->printLibJs( 'mootools' );
	echo $jce->printLibJs( 'utils' );
	echo $jce->printLibJs( 'window' );
	echo $jce->printPluginJs( 'functions' );
	echo $jce->printLibCss( 'common', true );
	?>
	<script type="text/javascript">
		jce.setPlugin('caption');
	</script>
</head>
<body lang="<?php echo $jce->getPluginLanguage(); ?>" onLoad="tinyMCEPopup.executeOnLoad('init();');">
<form onSubmit="insertAction();return false;" action="#">
	<div class="tabs">
		<ul>
			<li id="general_tab" class="current"><span><a href="javascript:mcTabs.displayTab('general_tab','general_panel');" onMouseDown="return false;"><?php echo $jce->translate('caption');?></a></span></li>
		</ul>
	</div>
    <div class="panel_wrapper">
    	<div id="general_panel" class="panel current" style="height:350px;">
        	<fieldset>
            <legend><?php echo $jce->translate('caption_text');?></legend>
            <table class="properties" border="0">
            	<tr>
					<td><?php echo $jce->translate('caption');?>:</td>
					<td colspan="4"><input type="text" size="50" id="text" name="text" onKeyUp="document.getElementById('caption_text').innerHTML=this.value;" /></td>
				</tr>
				<tr>
					<td><?php echo $jce->translate('align');?>:</td>
					<td colspan="3"><select name="align" id="align" onChange="updateCaptionStyles();" >
							<option value="left">left</option>
							<option value="center" selected>center</option>
							<option value="right">right</option>
							<option value="justified">justified</option>
						</select>
					</td>
            	</tr>
				<tr>
					<td><label for="text_padding"><?php echo $jce->translate('padding');?></label></td>
					<td colspan="3">
						<select id="text_padding" name="text_padding" onChange="updateCaptionStyles();">
							<option value="0">0</option>
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
							<option value="8">8</option>
							<option value="9">9</option>
						</select>
					</td>
					</tr>
				<tr>
					<td><label for="caption_color"><?php echo $jce->translate('caption_color');?></label></td>
					<td style="width:20%;"><input id="caption_color" name="caption_color" type="text" value="#000000" size="9" onChange="updateColor('caption_color_pick','caption_color');updateCaptionStyles();" /></td>
					<td id="caption_color_pickcontainer" style="width:8%;">&nbsp;</td>
                	<td><input class="radio" type="checkbox" name="caption_color_check" id="caption_color_check" checked="checked" /></td>
				</tr>
			</table>
			</fieldset>
			<fieldset>
            <legend><?php echo $jce->translate('caption_frame');?></legend>
			<table class="properties">
				<tr>
					<td><label for="margin"><?php echo $jce->translate('width');?></label></td>
					<td><input type="text" name="width" id="width" size="5" value="" />&nbsp; px</td>
					<td>&nbsp;</td>
					<td rowspan="7">
					<div style="margin-left:10px; vertical-align:middle;">
					<div id="caption">
						<img src="<?php echo $jce->getPluginImg('strawberry.jpg');?>" width="150" height="112" border="0" alt="Preview" title="Preview" />
						<div id="caption_text" class="caption_text" style="clear:both; float:left;"></div>
					</div></div></td>
				</tr>
				<tr>
					<td><label for="margin"><?php echo $jce->translate('margin');?></label></td>
					<td>
						<select id="margin" name="margin" onChange="updateCaptionStyles();">
							<option value="0">0</option>
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
							<option value="8">8</option>
							<option value="9">9</option>
						</select>
					</td>
					<td>&nbsp;</td>
					</tr>
					<tr>
						<td><label for="padding"><?php echo $jce->translate('padding');?></label></td>
						<td>
							<select id="padding" name="padding" onChange="updateCaptionStyles();">
								<option value="0">0</option>
								<option value="1">1</option>
								<option value="2">2</option>
								<option value="3">3</option>
								<option value="4">4</option>
								<option value="5">5</option>
								<option value="6">6</option>
								<option value="7">7</option>
								<option value="8">8</option>
								<option value="9">9</option>
							</select>
						</td>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td><label for="float"><?php echo $jce->translate('float');?></label></td>
						<td>
							<select id="float" name="float">
								<option value="left"><?php echo $jce->translate('left');?></option>
								<option value="right"><?php echo $jce->translate('right');?></option>
							</select>
						</td>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td><label for="border_width"><?php echo $jce->translate('border');?></label></td>
						<td>
							<select id="border_width" name="border_width" onChange="updateCaptionStyles();">
								<option value="0">0</option>
								<option value="1" selected="selected">1</option>
								<option value="2">2</option>
								<option value="3">3</option>
								<option value="4">4</option>
								<option value="5">5</option>
								<option value="6">6</option>
								<option value="7">7</option>
								<option value="8">8</option>
								<option value="9">9</option>
							</select>
						</td>
						<td>&nbsp;</td>
					</tr>
					<tr>
						<td><label for="border_style"><?php echo $jce->translate('border_style');?></label></td>
						<td>
							<select id="border_style" name="border_style" onChange="updateCaptionStyles();">
								<option value="none">none</option>
								<option value="solid" selected="selected">solid</option>
								<option value="dashed">dashed</option>
								<option value="dotted">dotted</option>
								<option value="double">double</option>
								<option value="groove">groove</option>
								<option value="inset">inset</option>
								<option value="outset">outset</option>
								<option value="ridge">ridge</option>
							</select>
						</td>
						<td>&nbsp;</td>
					</tr>
					<tr>						
						<td><label for="border_color"><?php echo $jce->translate('border_color');?></label></td>
						<td style="width:20%;"><input id="border_color" name="border_color" type="text" value="#000000" size="9" onChange="updateColor('border_color_pick','border_color');updateCaptionStyles();" /></td>
						<td id="border_color_pickcontainer" style="width:8%;">&nbsp;</td>
                    </tr>
                    <tr>												
						<td><label for="bgcolor"><?php echo $jce->translate('bgcolor');?></label></td>
						<td style="width:20%;"><input id="bgcolor" name="bgcolor" type="text" value="#ffffff" size="9" onChange="updateColor('bgcolor_pick','bgcolor');updateCaptionStyles();" /></td>
						<td id="bgcolor_pickcontainer" style="width:8%;">&nbsp;</td>
						<td><input class="radio" type="checkbox" name="bgcolor_check" id="bgcolor_check" checked="checked" /></td>
                    </tr>
				</table>
                </fieldset>
            </div>
        </div>
        <div class="mceActionPanel">
			<div style="float: left">
				<input type="button" id="insert" name="insert" value="{$lang_insert}" onClick="insertAction();" />&nbsp;
			</div>
			<div style="float: left">
				<input type="button" class="button" id="remove" name="remove" value="<?php echo $jce->translate('remove');?>" onClick="removeCaption();" />
			</div>
			<div style="float: right">
				<input type="button" class="button" id="help" name="help" value="<?php echo $jce->translate('help');?>" onClick="openHelp('caption');" />
				<input type="button" id="cancel" name="cancel" value="<?php echo $jce->translate('cancel');?>" onClick="tinyMCEPopup.close();" />
			</div>
		</div>
    </form>
</body>
</html>
