// Import theme specific language pack 
tinyMCE.importPluginLanguagePack('caption');

var TinyMCE_CaptionPlugin = {	
	getInfo : function() {
		return {
			longname : 'Captions',
			author : 'Ryan Demmer',
			authorurl : 'http://www.cellardoor.za.net',
			infourl : 'http://www.cellardoor.za.net/index2.php?option=com_content&amp;task=findkey&amp;pop=1&amp;lang=en&amp;keyref=caption.about',
			version : '1.1.0'
		};
	},

	getControlHTML : function(cn) {
		switch (cn) {
			case "caption":
				return tinyMCE.getButtonHTML(cn, 'lang_caption_desc', '{$pluginurl}/images/caption.gif', 'mceCaption');
			case "caption_delete":
				return tinyMCE.getButtonHTML(cn, 'lang_caption_delete_desc', '{$pluginurl}/images/caption_delete.gif', 'mceCaptionDelete');
		}

		return "";
	},
	
	initInstance : function(inst) {
			tinyMCE.importCSS(inst.getDoc(), tinyMCE.baseURL + "/plugins/caption/css/content.css");
	},

    execCommand : function(editor_id, element, command, user_interface, value) {
		switch (command) {
			case "mceCaption":
				var template = new Array();
				
				template['file']   = tinyMCE.getParam('site')+'/index2.php?option=com_jce&no_html=1&task=plugin&plugin=caption&file=caption.php';
                template['width']  = 450;
			    template['height'] = 460;

				var inst = tinyMCE.getInstanceById(editor_id);
				var elm = inst.getFocusElement();

				if (elm != null && tinyMCE.getAttrib(elm, 'class').indexOf('mceItem') != -1)
					return true;

				tinyMCE.openWindow(template, {editor_id : editor_id, inline : "yes"});

				return true;
				
			case "mceCaptionDelete":
				var inst = tinyMCE.getInstanceById(editor_id);
				var el = inst.getFocusElement();
				
				var d = tinyMCE.getParentElement(el, "div");

				if(d) {	
					var i = (el.nodeName == "A") ? el.firstChild : el;
					
					i.style.marginTop = i.style.marginBottom = TinyMCE_CaptionPlugin._getStyle(d, 'marginTop') || TinyMCE_CaptionPlugin._getStyle(d, 'marginBottom') || 0;
					i.style.marginLeft = i.style.marginRight = TinyMCE_CaptionPlugin._getStyle(d, 'marginLeft') || TinyMCE_CaptionPlugin._getStyle(d, 'marginRight') || 0;	
			
					d.removeChild(d.lastChild);
					tinyMCE.execCommand("mceRemoveNode", false, d);
				}

				return true;
		}

		return false;
	},
	
	_getStyle : function(elm, attrib, style) {
		var val = tinyMCE.getAttrib(elm, attrib);
	
		if (val != '')
			return '' + val;
	
		if (typeof(style) == 'undefined')
			style = attrib;
	
		val = eval('elm.style.' + style);
	
		return val == null ? '' : '' + val.replace(new RegExp('[^0-9%]', 'gi'), '');
	},
	
	handleNodeChange : function(editor_id, node, undo_index, undo_levels, visual_aid, any_selection) {
		var inst = tinyMCE.getInstanceById(editor_id);		
		if (node == null)
			return;

		tinyMCE.switchClass(editor_id + '_caption', 'mceButtonDisabled');
		tinyMCE.switchClass(editor_id + '_caption_delete', 'mceButtonDisabled');
		
		if (node.nodeName == "IMG" && tinyMCE.getParentElement(node, "div")) {
			tinyMCE.switchClass(editor_id + '_caption_delete', 'mceButtonSelected');
		}
		if (node.nodeName == "IMG" && tinyMCE.getAttrib(node, 'class').indexOf('mceItem') == -1) {
			tinyMCE.switchClass(editor_id + '_caption', 'mceButtonSelected');
		}
		return true;
	}
};

tinyMCE.addPlugin("caption", TinyMCE_CaptionPlugin);
