function init(){
    var c, ct, cn;
	var inst = tinyMCE.selectedInstance;
	var el = inst.getFocusElement();
	
	var action = "insert";
	
	setHTML('caption_color_pickcontainer', getColorPickerHTML('caption_color_pick','caption_color'));
	setHTML('border_color_pickcontainer', getColorPickerHTML('border_color_pick','border_color'));
	setHTML('bgcolor_pickcontainer', getColorPickerHTML('bgcolor_pick','bgcolor'));
	
	updateColor('caption_color_pick', 'caption_color');
	updateColor('border_color_pick', 'border_color');
	updateColor('bgcolor_pick', 'bgcolor');
		
	c = (el.parentNode.nodeName == "A") ? el.parentNode.parentNode : el.parentNode;	
	if(c.nodeName == "DIV" && (c.className == 'jce_caption' || c.id == 'caption')){
		action = "update";
		ct = getTextDiv(c);
		
		selectByValue('border_width', trimSize(getStyle(c, 'border', 'borderLeftWidth')) || 0);			
		selectByValue('border_style',getStyle(c, 'border', 'borderLeftStyle') || 'solid');
		selectByValue('margin', trimSize(getStyle(c, 'margin', 'marginLeft')) || 0);
		selectByValue('padding', trimSize(getStyle(c, 'padding', 'paddingLeft')) || 0);
		selectByValue('float', getStyle(c, 'float') || tinyMCE.getAttrib(el, 'align'));
		
		selectByValue('text_padding', trimSize(getStyle(ct, 'padding', 'paddingLeft')) || 0);
		
		setValue('width', trimSize(getStyle(c, 'width')));
			
		setColors('bgcolor', c.style.backgroundColor, '#ffffff');
		setColors('border_color', c.style.borderLeftColor, '#000000');		
		setColors('caption_color', ct.style.color, '#000000');
			
		setValue('text', ct.innerHTML);
		setHTML('caption_text', getValue('text'));
		selectByValue('align', getStyle(ct, 'textAlign'));
	}else{
		setValue('text', tinyMCE.getAttrib(el, 'title'));
		selectByValue('margin', tinyMCE.getAttrib(el, 'vspace') || tinyMCE.getAttrib(el, 'hspace') || trimSize(getStyle(el, 'marginLeft')) || trimSize(getStyle(el, 'marginTop')));
		selectByValue('padding', tinyMCE.getAttrib(el, 'vspace') || tinyMCE.getAttrib(el, 'hspace'));
		selectByValue('float', tinyMCE.getAttrib(el, 'align'));
		setHTML('caption_text', getValue('text'));
		setValue('width', el.getAttribute('width') || trimSize(getStyle(el, 'width')));
	}
	setValue('insert', tinyMCE.getLang('lang_' + action, 'Insert', true));
	updateCaptionStyles();
}
function setColors(el, color, def){
	if(el != 'border_color'){
		if(color){
			check(el + '_check', true);
		}else{
			check(el + '_check', false);
		}
	}
	if(!color) color = def;
	setValue(el, rgbToHex(color));
	updateColor(el + '_pick', el);
}
function getTextDiv(p){
	var ct,  cn = p.childNodes;
	for(var i=0; i<cn.length; i++){
		if(cn[i].nodeName == "DIV" && (cn[i].className == 'jce_caption_text' || cn[i].id == 'caption_text')){
			ct = cn[i];
		}
	}
	return ct;
}
function setAttribs(c, ct, i){
	var inst = tinyMCE.getInstanceById(tinyMCE.getWindowArg('editor_id'));
	c.setAttribute('class', 'jce_caption');
	ct.setAttribute('class', 'jce_caption_text');
	
	c.style.cssText = "";
	ct.style.cssText = "";
	
	c.style.width = getValue('width'); 
	if(tinyMCE.isMSIE){
		c.style.styleFloat = getSelectValue('float');
	}else{
		c.style.cssFloat = getSelectValue('float');
	}
	if(i.getAttribute('align') != 'left' || i.getAttribute('align') != 'right'){
		if(tinyMCE.isMSIE){
			i.style.styleFloat = getSelectValue('float');
		}else{
			i.style.cssFloat = getSelectValue('float');
		}
	}
	if(getSelectValue('border_width') != '0'){
		c.style.borderStyle = getSelectValue('border_style');
		c.style.borderLeftWidth = c.style.borderRightWidth = c.style.borderTopWidth = c.style.borderBottomWidth = getSelectValue('border_width');
		c.style.borderColor = getValue('border_color');
	}	
	if(ischecked('bgcolor_check')){
		c.style.backgroundColor = getValue('bgcolor');
	}
	if(ischecked('caption_color_check')){
		ct.style.color = getValue('caption_color');
	}
	if(getSelectValue('text_padding') != '0'){
		ct.style.paddingLeft = ct.style.paddingRight = ct.style.paddingTop = ct.style.paddingBottom = getSelectValue('text_padding');
	}
	ct.style.textAlign = getSelectValue('align');
	ct.style.clear = 'both'; 
		
	if(getSelectValue('margin') != '0'){
		c.style.marginLeft = c.style.marginRight = c.style.marginTop = c.style.marginBottom = getSelectValue('margin');
	}
	if(getSelectValue('padding') != '0'){	
		c.style.paddingLeft = c.style.paddingRight = c.style.paddingTop = c.style.paddingBottom = getSelectValue('padding');
	}
	
	c.style.cssText = tinyMCE.serializeStyle(tinyMCE.parseStyle(c.style.cssText));
	ct.style.cssText = tinyMCE.serializeStyle(tinyMCE.parseStyle(ct.style.cssText));
	
	tinyMCEPopup.close();
}
function insertAction() {
    var i, c, ct, cn;
	var inst = tinyMCE.getInstanceById(tinyMCE.getWindowArg('editor_id'));
	var doc = tinyMCE.selectedInstance.getDoc();
	var el = inst.getFocusElement();

	if(el.parentNode.nodeName == "A"){
		i = el;
		el = el.parentNode;
	}else{
		i = el;
	}
	//Undo
	tinyMCEPopup.execCommand("mceEndUndoLevel");
	
	i.removeAttribute('vspace');
	i.removeAttribute('hspace');
	i.style.marginLeft = i.style.marginRight = i.style.marginTop = i.style.marginBottom = '0';
	if(i.getAttribute('align') == 'left' || i.getAttribute('align') == 'right'){
		i.removeAttribute('align');
	}
    c = el.parentNode;
	if(c && c.nodeName == "DIV"){
		if(c.className == 'jce_caption' || c.getAttribute('id') == 'caption'){
			ct = getTextDiv(c);
			ct.removeChild(ct.lastChild);
			ct.appendChild(doc.createTextNode(getValue('text')));
			setAttribs(c, ct, i);
		}
	}else{
		c = doc.createElement("div");
        ct = doc.createElement("div");
		c.appendChild(el.cloneNode(true));
		el.parentNode.replaceChild(c, el);

		c.appendChild(ct);
        ct.appendChild(doc.createTextNode(getValue('text')));
		setAttribs(c, ct, i);
	}
}
function removeCaption()
{
    var inst = tinyMCE.getInstanceById(tinyMCE.getWindowArg('editor_id'));
	var el = inst.getFocusElement();

	var d_el = tinyMCE.getParentElement(el, "div");

    if(d_el) {	
		var i = (el.nodeName == "A") ? el.firstChild : el;
		
		i.style.marginTop = i.style.marginBottom = trimSize(getStyle(d_el, 'marginTop')) || trimSize(getStyle(d_el, 'marginBottom')) || 0;
		i.style.marginLeft = i.style.marginRight = trimSize(getStyle(d_el, 'marginLeft')) || trimSize(getStyle(d_el, 'marginRight')) || 0;	

		d_el.removeChild(d_el.lastChild);
        tinyMCE.execCommand("mceRemoveNode", false, d_el);

        tinyMCEPopup.close();
    }
}
function updateCaptionStyles(){
	var c = getObj('caption');
	var ct = getObj('caption_text');
	
	c.style.cssText = "";
	ct.style.cssText = "";
	
	c.style.borderColor = getValue('border_color');
	c.style.backgroundColor = getValue('bgcolor');
	ct.style.color = getValue('caption_color');
	ct.style.paddingLeft = ct.style.paddingRight = ct.style.paddingTop = ct.style.paddingBottom = getSelectValue('text_padding');
	ct.style.textAlign = getSelectValue('align');
	
	c.style.borderStyle = getSelectValue('border_style');
	c.style.borderLeftWidth = c.style.borderRightWidth = c.style.borderTopWidth = c.style.borderBottomWidth = getSelectValue('border_width');	
	c.style.paddingLeft = c.style.paddingRight = c.style.paddingTop = c.style.paddingBottom = getSelectValue('padding');
	
	c.style.cssText = tinyMCE.serializeStyle(tinyMCE.parseStyle(c.style.cssText));
	ct.style.cssText = tinyMCE.serializeStyle(tinyMCE.parseStyle(ct.style.cssText));
}