<?php
/**
 * ImageManager Class.
 * @author $Author: Ryan Demmer $
 * @version $Id: common.class.php 27 2005-09-14 17:51:00 Ryan Demmer $
 */
class imageManager extends Manager{
        /**
         * Constructor. Create a new Manager instance.
         * @param string $base_dir Base Directory
         * @param string $base_dir Base URL
         */
        function imageManager( $base_dir, $base_url ){
         	global $params;
			$this->base_dir = $base_dir;
            $this->base_url = $base_url;
			
			$this->cache_max_size 	= $params->get( 'cache_size', 10 ) * 1024 * 1024;
			$this->cache_max_age 	= $params->get( 'cache_age', 30 ) * 86400;
			$this->cache_max_files 	= $params->get( 'cache_files', 50 );
        }
		function getCacheDirectory(){
			global $mainframe, $params;
			$dir = JPath::makePath( $mainframe->getCfg('absolute_path'), $params->get( 'cache', 'media' ) );			
			if( !is_dir( $dir ) ){
				JFolder::createFolder( $dir, 0777 );
			}
			return $dir;
		}
		function phpthumbSetConfig( &$phpthumb ){
			global $jce, $params, $mainframe;
			
			$phpthumb->config_document_root 				= $mainframe->getCfg('absolute_path');			
			$phpthumb->config_use_imagemagick				= intval($params->get('use_imagemagick', 0));
			$phpthumb->config_prefer_imagemagick			= true;
			$phpthumb->config_imagemagick_path				= $params->get('imagemagick_path', '');
			$phpthumb->config_use_exif_thumbnail_for_speed 	= true;
			$phpthumb->config_max_source_pixels				= 0; // <--- this is dangerous but....?
		}
		function cleanCacheDir(){
			if( ( $this->cache_max_age > 0) || ( $this->cache_max_size > 0 ) || ( $this->cache_max_files > 0 ) ){
				$path = $this->getCacheDirectory();
				$files = JFolder::files( $path, '\.(jpg|jpeg|gif|png)$' );
				$num = count( $files );
				$size = 0;
				$cutofftime = time() - 3600;
				foreach( $files as $file ){
					$file = JPath::makePath( $path, $file );
					if( eregi( 'thumb_cache', $file ) && is_file( $file ) ){
						$ftime = @fileatime( $file );
						$fsize = @filesize( $file );
						if( $cutofftime > $ftime ){
							if( $fsize == 0 ){
								@unlink( $file );
							}
							if( $num > $this->cache_max_files ){
								@unlink( $file );
								$num--;
							}
							if( $ftime < ( time() - $this->cache_max_age ) ){
								@unlink( $file );
							}			
							if( ( $size + $fsize ) > $this->cache_max_size ){
								@unlink( $file );
							}		
						}
					}
				}
			}
			return true;
		}
		function getCacheThumb( $src, $create, $w, $h, $t, $q ){
			global $jce, $params, $mainframe;

			$this->cleanCacheDir();
			
			require_once( $jce->getPluginPath() . '/classes/phpthumb/phpthumb.class.php' );
			$phpthumb = new phpThumb();
			$this->phpthumbSetConfig( $phpthumb );
			
			if( strpos( $src, $mainframe->getCfg('absolute_path') ) === false ){
				$src = JPath::makePath( $mainframe->getCfg('absolute_path'), $src );
			}

			$phpthumb->src 	= $src;
			$phpthumb->w 	= $w;
            $phpthumb->h 	= $h;
            $phpthumb->q 	= $q;
			$phpthumb->f 	= $t;
			$phpthumb->far 	= 1;
			
			$mtime = @filemtime( $src );
			$thumb = 'jce_thumb_cache_' . md5( basename( JFile::stripExt( $src ) ) . $mtime . $w ) . '.' . JFile::getExt( $src );
			$thumb = JPath::makePath( $this->getCacheDirectory(), $thumb );
						
			if( file_exists( $thumb ) && !$create ){
				@unlink( $thumb );
				return true;
			}
			if( !file_exists( $thumb ) && $create ){
				$phpthumb->GenerateThumbnail();
				$phpthumb->RenderToFile( $thumb );
				@JPath::setPermissions( $thumb );
			}
			unset( $phpthumb );
			if( file_exists( $thumb ) ){
				return JPath::makePath( $params->get( 'cache', 'media' ), basename( $thumb ) );
			}else{
				return 'mambots/editors/jce/jscripts/tiny_mce/plugins/imgmanager_ext/images/noimage_' . $w . '.gif';
			}
		}
		function cleanCacheThumb( $src ){
			global $mainframe;
			$t = $this->getCacheThumb( $src, false, 120, 120, JFile::getExt( $src ), 75 );
			$p = $this->getCacheThumb( $src, false, 50, 50, JFile::getExt( $src ), 75 );
		}
		/**
         * PHPThumb Resize function for resizing and thumbnailing
         * @param string $src Fullpath of the source file
         * @param string $dest Fullpath of the destination file if any
         * @param string $width Width to resize to.
         * @param string $height Height to resize to.
         * @param string $quality Quality of resizing.
         */
        function resize( $src, $dest=false, $width, $height, $quality, $rm='' ){
            global $jce, $params;
            if( !$dest  ) $dest = $src;

            require_once( $jce->getPluginPath() . '/classes/phpthumb/phpthumb.class.php' );
           
		    $phpthumb = new phpThumb();
			$this->phpthumbSetConfig( $phpthumb );
						
			$phpthumb->src = $src;
			
            $phpthumb->w = $width;
            $phpthumb->h = $height;
            $phpthumb->q = $quality;
			
			if( $rm == 'zc' ) $phpthumb->zc = 1;
			if( $rm == 'aoe' ) $phpthumb->aoe = 1;
						                    
            if ( $phpthumb->GenerateThumbnail() ) {
                $phpthumb->RenderToFile( $dest );
                @JPath::setPermissions( $dest );
				unset( $phpthumb );
                return true;
            }else{
                unset( $phpthumb );
				return false;
            }
        }
        function doUpload( $dir, $file, $name, $ext, $overwrite, $r, $rv, $rq, $t, $tv, $tq, $tm ){
            global $cl, $pl, $params;
			$error = false;
			
			if( intval( $params->get('force_resize') ) ){		
				$r = true;
			}
			if( intval( $params->get('force_thumb') ) ){
				$t = true;
			}
			$fileExt = JFile::getExt( $file['name'] );
			$match = in_array( $fileExt, $ext );

			if( $file['size'] > ( intval( $params->get( 'max_size', '1024' ) ) * 1024 ) ){
				$error = $cl['upload_size_err'];
			}else{
				if( !$match ){
					$error = $cl['upload_ext_err'];
				}else{
					$path = JPath::makePath( $this->getBaseDir(), $dir );
					$file_path = JPath::makePath( $path, JFile::makeSafe( $name . '.' . $fileExt ) );
					$result = JFile::upload( $file['tmp_name'], $file_path, $overwrite );
	
					if( !JFile::exists( $result ) ){
						$error = $result;
					}else{
						//Resize
						if( $r ){
							if( !$this->resize( $result, false, $rv, $rv, $rq ) ){
								$error = $pl['resize_error'];
							}	
						}
						//Thumbnail
						if( $t ){
							$file_path = JPath::makePath( $dir, JFile::makeSafe( $name . '.' . $fileExt ) );
							$error = $this->createThumbnail( $file_path, $tv, $tv, $tq, $tm );
							if( $error ){
								$error = $pl['upload_thumbnail_error'];
							}
						}
					}
				}
			}
            return $error;
        }
        /**
         * Delete the relative file(s), and any thumbnails.
         * @param $files the relative path to the file name or comma seperated list of multiple paths.
         * @return string $error on failure.
         */
        function deleteFiles( $files ){
            global $cl;
			$error = false;
            $files = explode( ",", $files );
            foreach( $files as $file ){
                $fullpath = JPath::makePath( $this->getBaseDir(), $file );
                if( JFile::exists( $fullpath ) ){
                    //Remove cache thumb
					$this->cleanCacheThumb( $fullpath );
					if( @!JFile::delete( $fullpath ) ){
                        $error = $cl['del_file_err'];
                    }else{
						if( JFile::exists( $this->getThumbPath( $file ) ) ){
							//Remove cache thumb
							$this->cleanCacheThumb( $this->getThumbPath( $file ) );
							$error = $this->deleteThumbnail( $file );
						}
					}
                }
            }
			return $error;
        }
        /*
        * Rename a file.
        * @param string $src The relative path of the source file
        * @param string $dest The name of the new file
        * @return string $error
        */
        function renameFile( $src, $name ){
            global $cl;
            $error = false;

            $src = JPath::makePath( $this->getBaseDir(), $src );

            $dir = str_replace( "\\", "/", dirname( $src ) );
            $ext = JFile::getExt( $src );
            
            $dest = JPath::makePath( $dir, $name . '.' . $ext );
			
			//Remove cache thumb
			$this->cleanCacheThumb( $src );
            
            $error = JFile::rename( $src, $dest );
			if( !$error ){
				if( JFile::exists( $this->getThumbPath( $src ) ) ){					
					$error = JFile::rename( $this->getThumbPath( $src ), $this->getThumbPath( $dest ) );
					$this->cleanCacheThumb( $this->getThumbPath( $src ), $this->getThumbPath( $dest ) );
				}
			}
            return $error;
        }
        /*
        * Copy a file.
        * @param string $files The relative file or comma seperated list of files
        * @param string $dest The relative path of the destination dir
        * @return string $error on failure
        */
        function copy( $files, $dest_dir ){
            global $cl;
			$error = false;

            $files = explode( ",", $files );
            foreach( $files as $file ){
              
                $filepath = JPath::makePath( $dest_dir, basename( $file ) );
                $src = JPath::makePath( $this->getBaseDir(), $file );
                $dest = JPath::makePath( $this->getBaseDir(), $filepath );
                $error = JFile::copy( $src, $dest );
				if( !$error ){
					if( JFile::exists( $this->getThumbPath( $file ) ) ){					
						if( !JFolder::exists( $this->getThumbDir( $filepath, false ) ) ){
							$this->getThumbDir( $filepath, true );
						}
						$error = JFile::copy( $this->getThumbPath( $file ), $this->getThumbPath( $filepath ) );
					}
				}
				
            }
            return $error;
        }
        /*
        * Move a file.
        * @param string $files The relative file or comma seperated list of files
        * @param string $dest The relative path of the destination dir
        * @return string $error on failure
        */
        function move( $files, $dest_dir ){
            global $cl, $pl;
			$error = false;

            $files = explode( ",", $files );
            foreach( $files as $file ){

                $filepath = JPath::makePath( $dest_dir, basename( $file ) );
                $src = JPath::makePath( $this->getBaseDir(), $file );
                $dest = JPath::makePath( $this->getBaseDir(), $filepath );
				//Remove cache thumb
				$this->cleanCacheThumb( $src );
                $error = JFile::rename( $src, $dest );
				if( !$error ){
					if( JFile::exists( $this->getThumbPath( $file ) ) ){					
						if( !JFolder::exists( $this->getThumbDir( $filepath, false ) ) ){
							$this->getThumbDir( $filepath, true );
						}
						$error = JFile::rename( $this->getThumbPath( $file ), $this->getThumbPath( $filepath ) );
						if( JFile::countFiles( $this->getThumbDir( $file, false ) ) == 0 || JFolder::countDirs( $this->getThumbDir( $file, false ) ) == 0 ){
							if( @!JFolder::delete( $this->getThumbDir( $file, false ) ) ){
                    			$error = $pl['del_thumb_dir_err'];
                			}
						}
					}
				}
            }
            return $error;
        }
		function getRelative( $file ){
			return str_replace( $this->getBaseDir(), '', $file );
		}
		function getThumbParams(){
			global $params;
			
			$def['size'] 	= intval( $params->get('thumb_size', '150') );
			$def['dir'] 	= $params->get('thumb_dir', 'thumbnails');
			$def['quality'] = intval( $params->get('thumb_quality', '75') );
			
			return $def;
		}
		/**
         * Check for the thumbnail for a given file
         * @param string $relative The relative path of the file
         * @return The thumbnail URL or false if none.
         */
        function getThumbnail( $relative ){
            global $params, $jce;
            $thumbnail = false;
			
			$t_params = $this->getThumbParams();

            $fullpath = JPath::makePath( $this->getBaseDir(), $relative );
            $dim = @getimagesize( $fullpath );
                
            $thumbnail_dir = JPath::makePath( str_replace( "\\", "/", dirname( $relative ) ), $t_params['dir'] );
            $thumb = JPath::makePath( $thumbnail_dir, $this->getThumbName( $relative ) );

            //the original image is smaller than thumbnails,
            //so just return the url to the original image.
            if ( $dim[0] <= $t_params['size'] && $dim[1] <= $t_params['size'] ){
                $thumbnail = $relative;
            }
            //check for thumbnails, if exists return the thumbnail url
            if( JFile::exists( JPath::makePath( $this->getBaseDir(), $thumb ) ) ){
                $thumbnail = $thumb;
            }
            return $thumbnail;
        }
		function getThumbPath( $file ){		
			return JPath::makePath( $this->getThumbDir( $file, false ), $this->getThumbName( $file ) );
		}
        /**
         * For a given image file, get the respective thumbnail filename
         * no file existence check is done.
         * @param string $file the full path to the image file
         * @return string of the thumbnail file
         */
        function getThumbName( $file ){
            global $params;
            return $params->get( 'thumb_prefix', 'thumb_' ) . basename( $file );
        }
		function getThumbDir( $file, $create ){
			global $params;
			$dir = JPath::makePath( $this->getBaseDir(), JPath::makePath( str_replace( "\\", "/", dirname( $file ) ), $params->get('thumb_dir', 'thumbnails') ) );
			if( $create ){
				if( !JFolder::exists( $dir ) ){
					JFolder::createFolder( $dir );
				}
			}			
			return $dir;
		}
		function resizeImage( $file, $w, $h, $q ){
			global $pl;
			
			$error = false;
			$file = JPath::makePath( $this->getBaseDir(), $file );			
			if( !$this->resize( $file, false, $w, $h, $q, 'aoe' ) ){
				$error = $pl['resize_error'];
			}			
			return $error;			
		}
		function createThumbnail( $file, $w, $h, $q, $tm ){
			global $pl;
			
			$error = false;
			
			$t_dir = $this->getThumbDir( $file, true );

			$i_path = JPath::makePath( $this->getBaseDir(), $file );
			$t_path = JPath::makePath( $t_dir, $this->getThumbName( $file ) );				
			if( !$this->resize( $i_path, $t_path, $w, $h, $q, $tm ) ){
				$error = $pl['create_thumb_error'];
			}			
			return $error;			
		}
		function deleteThumbnail( $file ){
			global $pl;
			$error = false;
			$t_file = $this->getThumbPath( $file );
			$t_dir = $this->getThumbDir( $file, false );
			if( @!JFile::delete( $t_file ) ){
				$error = $pl['del_thumb_err'];
			}else{
				if( !JFile::countFiles( $t_dir ) && !JFolder::countDirs( $t_dir ) ){
					if( @!JFolder::delete( $t_dir ) ){
                    	$error = $pl['del_thumb_dir_err'];
                	}
				}
			}
			return $error;			
		}
		function getProperties( $file ){
			global $cl, $jce, $mainframe;
			clearstatcache();
			
			$path = JPath::makePath( $this->getBaseDir(), urldecode( $file ) );
			$ext = JFile::getExt( $path );
			$dim = @getimagesize( $path );			
			$date = JFile::getDate( $path );
            $size = JFile::getSize( $path );
			
			$thumb = JPath::makePath( $mainframe->getCfg('live_site'), $this->getCacheThumb( JPath::makePath( $this->base_dir, $file ), true, 120, 120, $ext, 75 ) );
								
			$html  = '<div>' . $cl['dimensions'] . ': <span id="file_width">' . $dim[0] . '</span> x <span id="file_height">' . $dim[1] . '</span></div>';
			$html .= '<div>' . $cl['size'] . ': ' . $size . '</div>';
			$html .= '<div>' . $cl['modified'] . ': ' . $date . '</div>';
			$html .= '<div style="text-align:center; margin-top:5px;"><img src="' . $thumb . '" width="120" height="120" /></div>';

			return "<script>showProperties('" . $jce->ajaxHTML( $html ) . "','" . $dim[0] . "','" . $dim[1] . "');</script>";	
		}
		function getPopupDimensions( $file ){
			$dim = @getimagesize( JPath::makePath( $this->getBaseDir(), $file ) );
						
			return "<script>setPopupDimensions('" . $dim[0] . "','" . $dim[1] . "');</script>";			
		}
		function getThumbProperties( $file ){
			$thumb = $this->getThumbnail( $file );
			$dim = @getimagesize( JPath::makePath( $this->getBaseDir(), $thumb ) );
			$thumb = JPath::makePath( $this->getBaseUrl(), $thumb );

			return "<script>setThumbProperties('" . $thumb . "','" . $dim[0] . "','" . $dim[1] . "');</script>";
		}
}
?>