jce.set('fileSelected', false);
jce.set('showProperties', false);
function preinit() {
	// Initialize
	tinyMCE.setWindowArg('mce_windowresize', false);
	tinyMCE.setWindowArg('mce_replacevariables', false);
};
function getImageSrc(str) {
	var pos = -1;

	if (!str)
		return "";

	if ((pos = str.indexOf('this.src=')) != -1) {
		var src = str.substring(pos + 10);

		src = src.substring(0, src.indexOf('\''));

		if (tinyMCE.getParam('convert_urls'))
			src = convertURL(src, null, true);

		return src;
	}

	return "";
};
function setIframeSrc(str){
	var token = getValue('token');
	getObj('manager').src = 'index2.php?option=com_jce&no_html=1&task=plugin&plugin='+jce.getPlugin()+'&token='+ token +'&file=files.php' + str + '&mode=' + getValue('mode');	
};
function setMode(mode){
	setValue('mode', mode);
	var modeImg = getObj('modeImg');	
	showMessage(jce.getLang('load', false, 'Loading...'), 'load.gif', 'msg');
	switch(mode){
        case 'images' :
            modeImg.src = jce.getPluginImg('list.gif');
            modeImg.alt = jce.getLang('toggle_list', true, 'List View');
            modeImg.title = jce.getLang('toggle_list', true, 'List View');
        break;
        case 'list' :
            modeImg.src = jce.getPluginImg('images.gif');
            modeImg.alt = jce.getLang('toggle_image', true, 'Image View');
            modeImg.title = jce.getLang('toggle_image', true, 'Image View');
        break;
    }
};
function init() {
	tinyMCEPopup.resizeToInnerSize();
	
	var inst = tinyMCE.getInstanceById(tinyMCE.getWindowArg('editor_id'));
	var elm = inst.getFocusElement();
	var action = "insert";
	var html = "";
		
	setMode(jce.get('mode'));	
	// Check action
	if (elm != null && elm.nodeName == "IMG")
		action = "update";
		
	setValue('insert', tinyMCE.getLang('lang_' + action, 'Insert', true));
	setHTML('border_color_pickcontainer', getColorPickerHTML('border_color_pick','border_color'));
	
	var align = jce.get('align');
	if(align == 'default') align = '';
    
	setValue('hspace', jce.get('hspace'));
	setValue('vspace', jce.get('vspace'));
	check('border', parseInt(jce.get('border')));
    selectByValue('border_width', jce.get('border_width') + 'px');
	selectByValue('border_style', jce.get('border_style'));
	setValue('border_color', jce.get('border_color'));
	setBorder();
	updateColor('border_color_pick', 'border_color');
    selectByValue('align', align);
	
	changeAppearance();
    
	if (action == "update"){
		var linkelm = elm.parentNode;
		var matched = false;
		if(linkelm && linkelm.nodeName == "A"){
			var popup_href = tinyMCE.getAttrib(linkelm, 'href');
			var rel = tinyMCE.getAttrib(linkelm, 'rel');
			if(linkelm.className == "jcebox" || linkelm.className == "thickbox" || rel.indexOf('lightbox') != -1){
				check('popupcheck', true);
				setValue('popup_url', popup_href);
				setValue('popup_caption', tinyMCE.getAttrib(linkelm, 'title'));
				if(linkelm.className == "jcebox" || linkelm.className == "thickbox"){
					selectByValue('popup_type', linkelm.className);
					setValue('popup_group', rel);
				}else{
					selectByValue('popup_type', 'lightbox');
					setValue('popup_group', rel.replace('lightbox[', '', 'gi').replace(']', '', 'gi'));
				}
			}
			var temp = 'index2.php?option=com_jce&task=popup';
			if(popup_href.indexOf(temp) != -1 || tinyMCE.cleanupEventStr(linkelm.getAttribute('onclick')).indexOf(temp) != -1){
				var src = tinyMCE.cleanupEventStr(linkelm.getAttribute('onclick'));
				src = src.replace(/&amp;/g, '&').replace(/&#39;/g, "'").split("'");
				var params = parseQuery(src[1]);
				check('popupcheck', true);
				setValue('popup_url', convertURL(params['img'], null, true));
				setValue('popup_caption', params['title'].replace(/_/g, ' '));
				setValue('popup_width', params['w']);
				setValue('popup_height', params['h']);
				selectByValue('popup_mode', params['mode']);
				check('popup_print', (params['print'] == 0) ? false : true);
				check('popup_right_click', (params['click'] == 0) ? false : true);
				selectByValue('popup_type', 'jcepopup');
				checkPopupType();
			}
			if(popup_href.indexOf("mosce/jscripts/tiny_mce/popupImage.php") != -1){
				var src = popup_href.replace(/&amp;/g, '&').replace(/&#39;/g, "'").replace(/&quot;/g, '"');
				src = src.replace(/[\(\'\)\;]/g, '').replace(/\?/g, '&');
				var params = parseQuery( src );
				check('popupcheck', true);
				setValue('popup_url', convertURL(params['img'], null, true));
				setValue('popup_caption', params['title'].replace(/_/g, ' '));
			}
			if(getValue('popup_width') == '' || getValue('popup_height') == ''){
				var path = makePath(tinyMCE.getParam('document_base_url'), jce.get('base_url'));
				var file = getValue('popup_url').replace(path, '', 'g');
				jce.ajaxSend('getPopupDimensions', file);
			}
		}		
		var src = tinyMCE.getAttrib(elm, 'src');
		var onmouseoversrc = getImageSrc(tinyMCE.cleanupEventStr(tinyMCE.getAttrib(elm, 'onmouseover')));
		var onmouseoutsrc = getImageSrc(tinyMCE.cleanupEventStr(tinyMCE.getAttrib(elm, 'onmouseout')));

		src = convertURL(src, elm, true);

		// Use mce_src if found
		var mceRealSrc = tinyMCE.getAttrib(elm, 'mce_src');
		if (mceRealSrc != "") {
			src = mceRealSrc;

			if (tinyMCE.getParam('convert_urls'))
				src = convertURL(src, elm, true);
		}
		if (onmouseoversrc != "" && tinyMCE.getParam('convert_urls'))
			onmouseoversrc = convertURL(onmouseoversrc, elm, true);

		if (onmouseoutsrc != "" && tinyMCE.getParam('convert_urls'))
			onmouseoutsrc = convertURL(onmouseoutsrc, elm, true);

		// Setup form data
		setValue('src', src);
		setValue('alt', tinyMCE.getAttrib(elm, 'alt'));
		setValue('title', tinyMCE.getAttrib(elm, 'title'));
		if(tinyMCE.getAttrib(elm, 'border') || trimSize(getStyle(elm, 'border', 'borderLeftWidth'))){
			check('border', true);	
			setBorder();
		}
		selectByValue('border_width', tinyMCE.getAttrib(elm, 'border') || trimSize(getStyle(elm, 'border', 'borderLeftWidth')));			
		selectByValue('border_style', getStyle(elm, 'border', 'borderLeftStyle'));
		setValue('border_color',  rgbToHex(getStyle(elm, 'borderColor')) || '#000000');
		updateColor('border_color_pick', 'border_color');
		
		setValue('vspace', tinyMCE.getAttrib(elm, 'vspace') || trimSize(getStyle(elm, 'marginTop')) || trimSize(getStyle(elm, 'marginBottom')) || 0);
		setValue('hspace', tinyMCE.getAttrib(elm, 'hspace') || trimSize(getStyle(elm, 'marginLeft')) || trimSize(getStyle(elm, 'marginRight')) || 0);
		
		setValue('width', tinyMCE.getAttrib(elm, 'width') || trimSize(getStyle(elm, 'width')));
		setValue('height', tinyMCE.getAttrib(elm, 'height') || trimSize(getStyle(elm, 'height')));
		setValue('tmp_width', getValue('width'));
		setValue('tmp_height', getValue('height')); 
		setValue('onmouseoversrc', onmouseoversrc);
		setValue('onmouseoutsrc', onmouseoutsrc);
		setValue('id', tinyMCE.getAttrib(elm, 'id'));
		selectByValue('dir', tinyMCE.getAttrib(elm, 'dir'));
		setValue('lang', tinyMCE.getAttrib(elm, 'lang'));
		setValue('longdesc', tinyMCE.getAttrib(elm, 'longdesc'));
		setValue('usemap', tinyMCE.getAttrib(elm, 'usemap'));

		addClassesToList('classlist', 'advimage_styles');
		selectByValue('classlist', tinyMCE.getAttrib(elm, 'class'));

		if(tinyMCE.getAttrib(elm, 'class') == 'jce_tooltip'){
			check('tooltipcheck', true);
			disable('onmousemovecheck', true);
			var title = tinyMCE.getAttrib(elm, 'title');
			if(title.indexOf('::') != -1){
				setValue('title', title.substring(0, title.lastIndexOf('::')));
				setValue('tooltip_title', getValue('title'));
				var tooltip_text = title.substring(title.length, title.lastIndexOf('::')+2);
				tooltip_text = tinyMCE.regexpReplace(tooltip_text, "<br />", "\n", "gi"); 
				tooltip_text = tinyMCE.regexpReplace(tooltip_text, "<br>", "\n", "gi");
				tooltip_text = tinyMCE.regexpReplace(tooltip_text, "&lt;br&gt;", "\n", "gi");
				setValue('tooltip_text', tooltip_text);
			}else{
				setValue('tooltip_title', '');
				setValue('tooltip_text', title);
				setValue('title', title);
			}
		}
		// Select by the values
		if (tinyMCE.isMSIE)
			selectByValue('align', getStyle(elm, 'align', 'styleFloat'));
		else
			selectByValue('align', getStyle(elm, 'align', 'cssFloat'));
		
		updateStyle();
		changeAppearance();

		window.focus();
	}else{
		addClassesToList('classlist', 'advimage_styles');
		updateStyle();
	}	
	// Check swap image if valid data
	if (getValue('onmouseoversrc') != "" || getValue('onmouseoutsrc') != "")
		setSwapImageDisabled(false);
	else
		setSwapImageDisabled(true);

	setupIframe(getValue('src'));
	jce.tree = new dTree('jce.tree', jce.getLibUrl());
	TinyMCE_EditableSelects.init();
};
function frameInit(){
	eval(jce.frameFunction);
};
function changeAppearance() {
	var img = getObj('alignSampleImg');
	if (img) {
		img.align = getSelectValue('align');
		img.hspace = getValue('hspace');
		img.vspace = getValue('vspace');
		if(ischecked('border')){
			img.style.borderLeftWidth = img.style.borderRightWidth = img.style.borderTopWidth = img.style.borderBottomWidth = getSelectValue('border_width');
			img.style.borderStyle = getValue('border_style');
			img.style.borderColor = getValue('border_color');
		}else{
			img.style.borderLeftWidth = img.style.borderRightWidth = img.style.borderTopWidth = img.style.borderBottomWidth = '';
			img.style.borderStyle = '';
			img.style.borderColor = '';
		}
	}
};
function getPopupOnclick(){
	var popup_image         = getValue('popup_url');
	var popup_title         = getValue('popup_caption');
	
	var popup_print         = ischecked('popup_print') ? '1' : '0';
	var popup_right_click   = ischecked('popup_right_click') ? '1' : '0';
		
	if( popup_image.indexOf(tinyMCE.getParam('document_base_url')) == 0 ){
		popup_image = popup_image.replace( tinyMCE.getParam('document_base_url'), '', 'g' );
	}		
	popup_title = popup_title.replace(' ', '_', 'gi');
	var winprops = 'height='+getValue('popup_height')+',width='+getValue('popup_width')+',top=10,left=10,scrollbars=no,resizable=yes';		
	var popup_features = '&mode=' + getSelectValue('popup_mode') + '&print=' + popup_print + '&click=' + popup_right_click;			
	var popup_url = '&img=' + popup_image + '&title=' + popup_title + '&w=' + getValue('popup_width') + '&h=' + getValue('popup_height') + popup_features;
	win = 'window.open(this.href+\'' + popup_url + '\',\'' + popup_title + '\',\'' + winprops + '\');return false;';
	
	return win;
};
function setPopupAttrib(l){
	var s = getSelectValue('popup_type');
	var g = getValue('popup_group');
	switch(s){
		case 'jcebox':
			setAttrib(l, 'class', 'jcebox');
			if(g != '') setAttrib(l, 'rel', g);	
			setAttrib(l, 'onclick', '');
			break;
		case 'thickbox':
			setAttrib(l, 'class', 'thickbox');
			if(g != '') setAttrib(l, 'rel', g);
			setAttrib(l, 'onclick', '');
			break;
		case 'lightbox':
			var rel = 'lightbox';
			setAttrib(l, 'class', '');
			if(g != '') rel += '[' + g + ']';
			setAttrib(l, 'rel', rel);
			setAttrib(l, 'onclick', '');
			break;
		case 'jcepopup':
			setAttrib(l, 'href', 'index2.php?option=com_jce&task=popup');
			var win = getPopupOnclick();			
			setAttrib(l, 'onclick', win);			
			break;
	}
};
function insertAction() {
	var inst = tinyMCE.getInstanceById(tinyMCE.getWindowArg('editor_id'));
	var elm = inst.getFocusElement();
	var src = getValue('src');
	var onmouseoversrc = getValue('onmouseoversrc');
	var onmouseoutsrc = getValue('onmouseoutsrc');

	if(!src){
		alert(jce.getLang('no_src', true), 'Please provide an URL for the image');
		return;
	}
	
	if (tinyMCE.getParam("accessibility_warnings")) {
		if (getValue('alt') == "") {
			var answer = confirm(jce.getLang('missing_alt', true, 'Are you sure you want to continue without including an Image Description? Without  it the image may not be accessible to some users with disabilities, or to those using a text browser, or browsing the Web with images turned off.'));
			if (answer == true) {
				setValue('alt', " ");
			}
		} else {
			var answer = true;
		}

		if (!answer)
			return;
	}
	if (onmouseoversrc && onmouseoversrc != "")
		onmouseoversrc = "this.src='" + convertURL(onmouseoversrc, tinyMCE.imgElement) + "';";

	if (onmouseoutsrc && onmouseoutsrc != "")
		onmouseoutsrc = "this.src='" + convertURL(onmouseoutsrc, tinyMCE.imgElement) + "';";
	//Update
	if (elm != null && elm.nodeName == "IMG"){
		updateStyle();
		if(ischecked('popupcheck')){
			var linkelm =  tinyMCE.getParentElement(elm, "a");
			if(linkelm){			
				setAttrib(linkelm, 'href', convertURL(getValue('popup_url'), linkelm));
				setAttrib(linkelm, 'title', getValue('popup_caption'));
				setPopupAttrib(linkelm);
			//new
			}else{
				if (tinyMCE.isSafari){
                	tinyMCEPopup.execCommand("mceInsertContent", false, '<a href="' + getValue('popup_url') + '">' + inst.getSelectedHTML() + '</a>');
				}else{
                	tinyMCEPopup.execCommand("createlink", false, getValue('popup_url'));					
				}
				// Move cursor behind the new anchor
				var linkelm =  tinyMCE.getParentElement(elm, "a");
				if (tinyMCE.isGecko){
					var sp = inst.getDoc().createTextNode(" ");	
					if (linkelm.nextSibling){
						linkelm.parentNode.insertBefore(sp, linkelm.nextSibling);
					}else{
						linkelm.parentNode.appendChild(sp);
					}	
					// Set range after link
					var rng = inst.getDoc().createRange();
					rng.setStartAfter(linkelm);
					rng.setEndAfter(linkelm);
	
					// Update selection
					var sel = inst.getSel();
					sel.removeAllRanges();
					sel.addRange(rng);
				}
				setAttrib(linkelm, 'title', getValue('popup_caption'));
				setPopupAttrib(linkelm);
			}
		}else{
			tinyMCEPopup.execCommand("unlink", false);
		}
		//Standard attributes
		setAttrib(elm, 'src', convertURL(src, tinyMCE.imgElement));
		setAttrib(elm, 'mce_src', src);
		setAttrib(elm, 'alt');
		setAttrib(elm, 'title');
		setAttrib(elm, 'width');
		setAttrib(elm, 'height');
		setAttrib(elm, 'id');
		setAttrib(elm, 'dir', getSelectValue('dir'));
		setAttrib(elm, 'lang');
		setAttrib(elm, 'longdesc');
		setAttrib(elm, 'usemap');
		setAttrib(elm, 'style');
		setAttrib(elm, 'class', getSelectValue('classlist'));
		//Setup rollover
		if(ischecked('onmousemovecheck')){
			setAttrib(elm, 'onmouseover', onmouseoversrc);
			setAttrib(elm, 'onmouseout', onmouseoutsrc);
		}else{
			setAttrib(elm, 'onmouseover', '');
			setAttrib(elm, 'onmouseout', '');
		}
		//Remove vspace/hspace
		setAttrib(elm, 'vspace', '');
		setAttrib(elm, 'hspace', '');
		//Create/Update tooltip
		if(ischecked('tooltipcheck')){
			setAttrib(elm, 'class', 'jce_tooltip');	
			var tooltip_text = tinyMCE.regexpReplace(getValue('tooltip_text'), "\r\n", "<br />", "gi"); 
			tooltip_text = tinyMCE.regexpReplace(tooltip_text, "\r", "<br />", "gi"); 
			tooltip_text = tinyMCE.regexpReplace(tooltip_text, "\n", "<br />", "gi"); 			
			var tooltip_content = getValue('tooltip_title') + '::' + tooltip_text;
			setAttrib(elm, 'title', tooltip_content);
		}
		var align = getSelectValue('align');
		//Setup align. If left or right, use style float.
		if(align == 'left' || align == 'right'){
			setAttrib(elm, 'align','');	
		}else{
			setAttrib(elm, 'align', align);
		}
		// Refresh in old MSIE
		if (tinyMCE.isMSIE5)
			elm.outerHTML = elm.outerHTML;
	//New
	}else{
		updateStyle();
		var html = "";
		if(ischecked('popupcheck')){
			html += '<a';
			html += makeAttrib('title', getValue('popup_caption'));
			var s = getSelectValue('popup_type');
			var g = getValue('popup_group');
			switch(s){
				case 'jcebox':
					html += makeAttrib('href', getValue('popup_url'));
					html += makeAttrib('class', 'jcebox');
					if(g != '') html += makeAttrib('rel', g);
					break;
				case 'thickbox':
					html += makeAttrib('href', getValue('popup_url'));
					html += makeAttrib('class', 'thickbox');
					if(g != '') html += makeAttrib('rel', g);
					break;
				case 'lightbox':
					var rel = 'lightbox';
					html += makeAttrib('href', getValue('popup_url'));
					html += makeAttrib('class', '');
					if(g != '') rel += '[' + g + ']';
					html += makeAttrib('rel', rel);							
					break;
				case 'jcepopup':
					html += makeAttrib('href', 'index2.php?option=com_jce&task=popup');
					var win = getPopupOnclick();
					html += makeAttrib('onclick', win);
					break;
			}
			html += '>';
		}
		html += "<img";
		html += makeAttrib('src', convertURL(src, tinyMCE.imgElement));
		html += makeAttrib('mce_src', src);
		html += makeAttrib('alt');
		html += makeAttrib('width');
		html += makeAttrib('height');
		if(ischecked('onmousemovecheck')){
			html += makeAttrib('onmouseover', onmouseoversrc);
			html += makeAttrib('onmouseout', onmouseoutsrc);
		}
		html += makeAttrib('id');
		html += makeAttrib('dir', getSelectValue('dir'));
		html += makeAttrib('lang');
		html += makeAttrib('longdesc');
		html += makeAttrib('usemap');
		html += makeAttrib('style');
		html += makeAttrib('align', getSelectValue('align'));
		if(ischecked('tooltipcheck')){
			html += makeAttrib('class', 'jce_tooltip');	
			var tooltip_text = tinyMCE.regexpReplace(getValue('tooltip_text'), "\r\n", "<br />", "gi"); 
			tooltip_text = tinyMCE.regexpReplace(tooltip_text, "\r", "<br />", "gi"); 
			tooltip_text = tinyMCE.regexpReplace(tooltip_text, "\n", "<br />", "gi"); 
			var tooltip_content = getValue('tooltip_title') + '::' + tooltip_text;
			html += makeAttrib('title', tooltip_content);
		}else{
			html += makeAttrib('title');
			html += makeAttrib('class', getSelectValue('classlist'));
		}
		html += " />";
		if(ischecked('popupcheck')){
			html += "</a>";
		}
		tinyMCEPopup.execCommand("mceInsertContent", false, html);
	}
	tinyMCE._setEventsEnabled(inst.getBody(), false);
	tinyMCEPopup.close();
};
function setSwapImageDisabled(state) {
	check('onmousemovecheck', !state);
	if(state){
		setValue('onmouseoutsrc', getValue('src'));	
	}
};
function setSwap() {
	var state = ischecked('onmousemovecheck');
	if(state){
		setValue('onmouseoutsrc', getValue('src'));	
		check('tooltipcheck', false);
	}
	disable('tooltipcheck', state);	
};
function setTooltip(){
	var state = ischecked('tooltipcheck');	
	if(state)
		check('onmousemovecheck', false);		
	disable('onmousemovecheck', state);
};
function setBorder(){
	if(ischecked('border')){
		disable('border_width', false); 
		disable('border_style', false);
		disable('border_color', false);
	}else{
		disable('border_width', true); 
		disable('border_style', true);
		disable('border_color', true);
	}
	changeAppearance();
	updateStyle();
};
function updateStyle() {
	var st = tinyMCE.parseStyle(getValue('style'));

	//st['width'] = getValue('width') == '' ? '' : getValue('width') + "px";
	//st['height'] = getValue('height') == '' ? '' : getValue('height') + "px";
	
	if(getSelectValue('align') == 'left' || getSelectValue('align') == 'right'){
		st['float'] = getSelectValue('align');	
	}else{
		st['float'] = '';	
	}
	if(ischecked('border')){
		st['border'] = '';
		if(getSelectValue('border_width') != ''){
			st['border'] += getSelectValue('border_width') + 'px ';
		}
		if(getSelectValue('border_style') != ''){
			st['border'] += getSelectValue('border_style') + ' ';
		}
		if(getValue('border_color') != ''){
			st['border'] += getValue('border_color');
		}
	}else{
		st['border'] = '';
	}
	if(parseInt(getValue('vspace')) == 0){
		st['margin-top'] = st['margin-bottom'] = '';
	}else{
		st['margin-top'] = st['margin-bottom'] = getValue('vspace') + 'px';
	}
	if(parseInt(getValue('hspace')) == 0){
		st['margin-left'] = st['margin-right'] = '';	
	}else{
		st['margin-left'] = st['margin-right'] = getValue('hspace') + 'px';	
	}
	setValue('style', tinyMCE.serializeStyle(st));
};
function changeHeight() {
	if( !ischecked('constrain'))
        return;

    if (getValue('width') ==  "" || getValue('height') == "")
		return;

	var temp = (getValue('width') / getValue('tmp_width')) * getValue('tmp_height');
	setValue('height', temp.toFixed(0));
};
function changeWidth() {
	if( !ischecked('constrain'))
        return;

    if (getValue('width') ==  "" || getValue('height') == "")
		return;

	var temp = (getValue('height') / getValue('tmp_height')) * getValue('tmp_width');
	setValue('width', temp.toFixed(0));
};
function changePopupHeight() {
	if( !ischecked('popup_constrain'))
        return;

    if (getValue('popup_width') ==  "" || getValue('popup_height') == "")
		return;

	var temp = (getValue('popup_width') / getValue('tmp_popup_width')) * getValue('tmp_popup_height');
	setValue('popup_height', temp.toFixed(0));
};
function changePopupWidth() {
	if( !ischecked('popup_constrain'))
        return;

    if (getValue('popup_width') ==  "" || getValue('popup_height') == "")
		return;

	var temp = (getValue('popup_height') / getValue('tmp_popup_height')) * getValue('tmp_popup_width');
	setValue('popup_width', temp.toFixed(0));
};
function checkPopupType(){
	var s = getSelectValue('popup_type');
	if(s == 'jcepopup'){
		disable('popup_width', false);
		disable('popup_height', false);
		disable('popup_constrain', false);
		disable('popup_group', false);
		show('jcepopup_attr');
	}else{
		disable('popup_width', true);
		disable('popup_height', true);
		disable('popup_constrain', true);
		disable('popup_group', true);
		hide('jcepopup_attr');
	}
};
function viewImage(){  
    var url = makePath(makePath(tinyMCE.getParam('document_base_url'), jce.get('base_url')), getValue('itemsList'));	
	new imagePreview(basename(getValue('itemsList')), url);
};
function getDimensions(w, h){
	setValue('width', w);
	setValue('tmp_width', w);
    setValue('height', h);
	setValue('tmp_height', h);
	setHTML('dim_loader', '');
	disable('insert', false);
};
function switchMode() {
	var mode = getValue('mode');
	var modeImg = getObj('modeImg');
	showMessage(jce.getLang('load', false, 'Loading...'), 'load.gif', 'msg');
    switch(mode){
        case 'images' :
			newmode = 'list';
            modeImg.src = jce.getPluginImg('images.gif');
            modeImg.alt = jce.getLang('toggle_image', true, 'Image View');
            modeImg.title = jce.getLang('toggle_image', true, 'Image View');
        break;
        case 'list' :
			newmode = 'images';
            modeImg.src = jce.getPluginImg('list.gif');
            modeImg.alt = jce.getLang('toggle_list', true, 'List View');
            modeImg.title = jce.getLang('toggle_list', true, 'List View');
        break;
    }
    var dir = getSelectValue('dirPath');
    setValue('mode', newmode);
	setIframeSrc('&dir=' + encodeURIComponent(dir));
};
function createThumb(){
	var html = '<table style="text-align:center">';
		html += '<tr><td class="column1"><label id="thumb_sizelabel" for="thumb_size">' + jce.getLang('size', true, 'Size') + '</label></td><td><input type="text" id="thumb_size" name="thumb_size" value="150" size="5" style="margin-left:5px;" />&nbsp;px</td>';
		html += '<td class="column1"><label id="thumb_qualitylabel" for="thumb_quality">&nbsp;' + jce.getLang('quality', true, 'Quality') + '</label></td><td><select id="thumb_quality" name="thumb_quality" /><option value="100">100</option><option value="75" selected="selected">75</option><option value="50">50</option><option value="25">25</option></select>&nbsp;%</td></tr>';	
		html += '<tr><td class="column1"><label>&nbsp;' + jce.getLang('thumbnail_type', true, 'Type') + '</label></td>';
		html += '<td class="column1" colspan="3" style="text-align:left"><select id="thumb_mode" name="thumb_mode" /><option value="" selected="selected">' + jce.getLang('normal', true, 'Proportional') + '</option><option value="zc">' + jce.getLang('square', true, 'Square') + '</option></select></td></tr></table>';
	
	new basicDialog(jce.getLang('thumbnail', true, 'Create Thumbnail'), html, {
		width: 260,
		modal: true,
		minimize: false,
		onConfirm: function(){
			var file = getValue('itemsList');
			var dir = getSelectValue('dirPath');
			var s = getValue('thumb_size');
			var q = getSelectValue('thumb_quality');
			var m = getSelectValue('thumb_mode');
			setIframeSrc('&dir=' + encodeURIComponent(dir) + '&opt=create_thumb&tf='+file+'&ts='+s+'&tq='+q+'&tm='+m);
			this.close();
		}
	});
};
function deleteThumb(){
	var file = getValue('itemsList');
	var dir = getSelectValue('dirPath');
	new Confirm(jce.getLang('delete_thumb_alert', true, 'Delete Thumbnail?'), {
		onConfirm : function(){
			setIframeSrc('&dir=' + encodeURIComponent(dir) + '&opt=delete_thumb&tf='+file);	
			this.close();
		}
	});
};
function setupUpload(el){
	if(el.checked){ 
		el.value = 1;
		disable(el.name + '_value', false);
		disable(el.name + '_quality', false);
		if(el.name == 'upload_thumbnail'){
			disable('upload_thumbnail_mode', false);	
		}
	}else{
		el.value = 0;
		disable(el.name + '_value', true);
		disable(el.name + '_quality', true);
		if(el.name == 'upload_thumbnail'){
			disable('upload_thumbnail_mode', true);	
		}
	}
};
function setThumbProperties(src, w, h){
	setValue('src', src);
	setValue('width', w);
	setValue('tmp_width', w);
	setValue('height', h); 
	setValue('tmp_height', h);
	disable('insert', false);	
};
function setPopupDimensions(w, h){
	setValue('popup_width', w); 
	setValue('tmp_popup_width', w);
	setValue('popup_height', h); 
	setValue('tmp_popup_height', h);
	setHTML('popup_dim_loader', '');
	disable('insert', false);
};
function uploadFile(){	
	var html = '<table>';
		//Main section
		html += '<tr><td class="column1"><label>' + jce.getLang('file', false, 'File') + '</label></td>';
		html += '<td colspan="5"><input type="file" name="upload" id="upload" size="60" value="" onchange="setUploadName(this.value);" /></td></tr>';
		html += '<tr><td class="column1"><span class="label">' + jce.getLang('name', false, 'Name') + '</label></td>';
		html += '<td colspan="5"><input type="text" name="upload_name" id="upload_name" size="60" /></td></tr>';
		//Resize
		html += '<tr><td><label>' + jce.getLang('resize', true, 'Resize') + '</label></td>';		
		html += '<td><input type="text" id="upload_resize_value" name="upload_resize_value" value="' + jce.get('resize_value') + '" size="5" disabled="disabled" /> px</td>';
		html += '<td><label>' + jce.getLang('quality', true, 'Quality') + '</label></td>';
		html += '<td><select style="vertical-align:middle" id="upload_resize_quality" name="upload_resize_quality" disabled="disabled" /><option value="100">100</option><option value="75" selected="selected">75</option><option value="50">50</option><option value="25">25</option></select> %</td>';		
		html += '<td><input type="checkbox" class="checkbox" id="upload_resize" name="upload_resize" style="vertical-align:middle;" value="0" onclick="setupUpload(this);"/></td></tr>';
		//Thumbnail
		html += '<tr><td><label>' + jce.getLang('thumbnail', true, 'Thumbnail') + '</label></td>';		
		html += '<td><input type="text" id="upload_thumbnail_value" name="upload_thumbnail_value" value="' + jce.get('thumb_value') + '" size="5" disabled="disabled" /> px</td>';
		html += '<td><label>' + jce.getLang('quality', true, 'Quality') + '</label></td>';
		html += '<td><select style="vertical-align:middle" id="upload_thumbnail_quality" name="upload_thumbnail_quality" disabled="disabled" /><option value="100">100</option><option value="75" selected="selected">75</option><option value="50">50</option><option value="25">25</option></select> %</td>';	
		html += '<td><input type="checkbox" class="checkbox" id="upload_thumbnail" name="upload_thumbnail" style="vertical-align:middle;" value="0" onclick="setupUpload(this);"/></td>';	
		html += '<td><select id="upload_thumbnail_mode" name="upload_thumbnail_mode" disabled="disabled" /><option value="" selected="selected">' + jce.getLang('normal', true, 'Normal') + '</option><option value="zc">' + jce.getLang('square', true, 'Square') + '</option></select></td>';
		//Upload select
		html += '<tr><td colspan="6" style="text-align:center;"><input type="checkbox" class="checkbox" name="upload_select" id="upload_select" />&nbsp;';
		html += '<span class="label">' + jce.getLang('upload_select', false, 'Select File after Upload') + '</span></td></tr>';
		//Overwrite conditions
		html += '<tr><td colspan="6" style="text-align:center;"><input type="radio" class="checkbox" id="overwrite" name="overwrite" style="vertical-align:middle;" value="1" checked="checked" /><label>' + jce.getLang('overwrite', false, 'Overwrite Existing File') + '</label>&nbsp;';		
		html += '<input type="radio" class="checkbox" id="unique" name="overwrite" style="vertical-align:middle;" value="0" /><span class="label">' + jce.getLang('unique', false, 'Create Unique File') + '</label></td></tr></table>';
	
	new basicDialog(jce.getLang('upload', false), html, {
		width: 480,
		parent: 'form',
		modal: true,
		onConfirm: function(){
			showMessage(jce.getLang('uploading', false, 'Uploading...'), 'load.gif', 'msg');
			getObj('uploadForm').submit();
			if(ischecked('upload_select')){
				var file = makePath(getDir(), getValue('upload_name') + '.' + makeSafe(getExtension(getValue('upload'))));
				jce.iframeFunction = function(){
					setReturnFile(file, true);
				};
			}
			this.close();
		},
		onOpen: function(){			
			if(jce.get('resize') == "0"){
				check('upload_resize', false);
				setValue('upload_resize', 0);
				disable('upload_resize', true);	
			}
			if(jce.get('force_resize') == "1"){
				check('upload_resize', true);
				setValue('upload_resize', 1);
				disable('upload_resize', true);
			}
			if(jce.get('thumb') == "0"){
				check('upload_thumbnail', false);
				setValue('upload_thumbnail', 0);
				disable('upload_thumbnail', true);	
			}
			if(jce.get('force_thumb') == "1"){
				check('upload_thumbnail', true);
				setValue('upload_thumbnail', 1);
				disable('upload_thumbnail', true);
			}
			selectByValue('upload_resize_quality', jce.get('resize_quality'));
			selectByValue('upload_thumbnail_quality', jce.get('thumb_quality'));
			selectByValue('upload_thumbnail_mode', jce.get('thumb_mode'));
		}
	});
};
function changeResizeWidth(){
	if (getValue('resize_width') ==  "" || getValue('resize_height') == "")
		return;
			
	if(getSelectValue('resize_width_type') == 'pct' && getSelectValue('resize_height_type') == 'pct'){
		var temp = getValue('resize_width');
	}else if(getSelectValue('resize_width_type') == 'pct'){
		var temp = Math.round(getValue('resize_height') * getValue('resize_width') / 100);	
	}else{
		var temp = getValue('resize_width') / getValue('resize_width_tmp') * getValue('resize_height_tmp');
		temp = temp.toFixed(0);
	}
	setValue('resize_height', temp);
};
function changeResizeHeight(){
	if (getValue('resize_width') ==  "" || getValue('resize_height') == "")
		return;
	
	if(getSelectValue('resize_width_type') == 'pct' && getSelectValue('resize_height_type') == 'pct'){
		var temp = getValue('resize_height');
	}else if(getSelectValue('resize_height_type') == 'pct'){
		var temp = Math.round(getValue('resize_width') * getValue('resize_height') / 100);	
	}else{
		var temp = getValue('resize_height') / getValue('resize_height_tmp') * getValue('resize_width_tmp');
		temp = temp.toFixed(0);
	}
	setValue('resize_width', temp);		
};
function checkResizeType(v, m){
	var nv = getValue(m);
	var ov = getValue(m + '_tmp');
	switch(v){
		case 'px':
			nv = Math.round(nv * ov / 100);
			break;
		case 'pct':
			nv = Math.round(nv / ov * 100);
			break;
	}
	setValue(m, nv);	
};
function resizeImage(){
	var html = '<table style="text-align:center">';
		html += '<tr><td><label>' + jce.getLang('width', true, 'Width') + '</label></td>';		
		html += '<td><input type="hidden" id="resize_width_tmp" value="'+trim(getHTML('file_width'))+'" /><input type="text" id="resize_width" name="resize_width" value="'+trim(getHTML('file_width'))+'" size="10" onChange="changeResizeWidth();" /></td>';
		html += '<td><select name="resize_width_type" onChange="checkResizeType(this.value, \'resize_width\');"><option value="px">' + jce.getLang('pixels', true, 'Pixels') + '</option><option value="pct">' + jce.getLang('percent', true, 'Percent') + '</option></select></td></tr>';
		html += '<tr><td><label>' + jce.getLang('height', true, 'Height') + '</label></td>';
		html += '<td><input type="hidden" id="resize_height_tmp" value="'+trim(getHTML('file_height'))+'" /><input type="text" id="resize_height" name="resize_height" value="'+trim(getHTML('file_height'))+'" size="10" onChange="changeResizeHeight();" /></td>';
		html += '<td><select name="resize_height_type" onChange="checkResizeType(this.value, \'resize_height\');"><option value="px">' + jce.getLang('pixels', true, 'Pixels') + '</option><option value="pct">' + jce.getLang('percent', true, 'Percent') + '</option></select></td></tr>';
		html += '<td><label>' + jce.getLang('quality', true, 'Quality') + '</label></td>';
		html += '<td colspan="4" style="text-align:left;"><select style="vertical-align:middle" id="resize_quality" name="resize_quality" /><option value="100">100</option><option value="75" selected="selected">75</option><option value="50">50</option><option value="25">25</option></select> %</td>';
		html += '</tr></table>';
	new basicDialog(jce.getLang('resize', true, 'Resize Image'), html, {
		width: 240,
		parent: 'form',
		modal: true,
		minimize: false,
		onConfirm: function(){
			var file = getValue('itemsList');
			var dir = getSelectValue('dirPath');
			var rw = getValue('resize_width');
			if(getSelectValue('resize_width_type') == 'pct'){
				rw =  Math.round(rw * getValue('resize_width_tmp') / 100);
			}	
			var rh = getValue('resize_height');
			if(getSelectValue('resize_height_type') == 'pct'){
				rh =  Math.round(rh * getValue('resize_height_tmp') / 100);	
			}
			var rq = getSelectValue('resize_quality');
			setIframeSrc('&dir=' + encodeURIComponent(dir) + '&opt=resize_image&rf='+file+'&rw='+rw+'&rh='+rh+'&rq='+rq);
			this.close();
		}
	});
};
function selectFile(id){
	jce.set('fileSelected', true);
	var dir = getSelectValue('dirPath');
	var name = getObj('manager').contentWindow.document.getElementById(id).title;
	var path = makePath(dir,name);
	
	disable('insert', true);
	
	//var url = makePath(tinyMCE.getParam('document_base_url'), jce.get('base_url'));
	//var src = makePath(url, makePath(dir, name));
	
	var src = makePath(jce.get('base_url'), makePath(dir, name));
	if(src.charAt(0) == '/') src = src.substring(1);
	
	if(hasClass('general_panel', 'current') || hasClass('general_panel', 'panel current')){
		setValue('title', name);
		setValue('alt', name);
		setValue('src', src);
		setValue('onmouseoutsrc', src);
		
		setHTML('dim_loader', '<img src="' + jce.getLibImg('load.gif') + '" style="margin-left:2px;" />');
		jce.set('fileSelected', true);
			
		if(jce.get('showProperties') && getHTML('image_name') == stripExtension(name)){
			setValue('width', trim(getHTML('file_width'))); 
			setValue('tmp_width', trim(getHTML('file_width')));
			setValue('height', trim(getHTML('file_height'))); 
			setValue('tmp_height', trim(getHTML('file_height')));
			setHTML('dim_loader', '');
			disable('insert', false);
		}
	}
	        
    if(hasClass('swap_panel', 'current') && ischecked('onmousemovecheck'))
    {
        if( getValue('onmouseoutsrc') != '' ){
            setValue('onmouseoversrc', src);
        }
		jce.set('fileSelected', false);
		disable('insert', false);
    }
	if(hasClass('popup_panel', 'current') && ischecked('popupcheck'))
    {
        if(getObj('manager').contentWindow.document.getElementById(id + '_ts').value == '1'){
			new Confirm(jce.getLang('use_thumb', true, 'Use associated thumbnail?'), {
				onConfirm : function(){
					jce.ajaxSend('getThumbProperties', path);
					setValue('title', name);
					setValue('alt', name);
					disable('insert', true);
					this.close();
				}
			});
		}
		jce.ajaxSend('getPopupDimensions', path);
		setHTML('popup_dim_loader', '<img src="' + jce.getLibImg('load.gif') + '" style="margin-left:2px;" />');
		disable('insert', true);
		setValue('popup_url', src);
		jce.set('fileSelected', false);
    }
};
function showProperties(html, width, height){
	if(document.getElementById('fileProperties')){
		setHTML('fileProperties', xmlDecode(html));	
		jce.set('showProperties', true);
		if(jce.get('fileSelected')){		
			setValue('width', width);
			setValue('tmp_width', width);
			setValue('height', height);
			setValue('tmp_height', height);
			setHTML('dim_loader', '');
			disable('insert', false);
		}
	}
};
function showFileDetails(id){
	jce.set('fileSelected', false);
	jce.set('showProperties', false);
	
	var dir = getSelectValue('dirPath');
    var name = getObj('manager').contentWindow.document.getElementById(id).title;
    var path = makePath(dir,name);
    var ext = getExtension(name).toUpperCase();
	
	var ts = getObj('manager').contentWindow.document.getElementById(id + '_ts').value;

	setIcons(1);
	show('viewIcon');
	show('thumbIcon');
	show('resizeIcon');
	
	var prev = makePath( makePath(tinyMCE.getParam('document_base_url'), jce.get('base_url')), path);
	
    var html = '<div style="font-weight:bold" id="image_name">' + stripExtension(name) + '</div>';
    	html += '<div>' + ext + ' ' + jce.getLang('file', false, 'File') + '</div>';
		html += '<div id="fileProperties"></div>';
	
	setHTML('fileDetails', html);
	setLoader();
	
	jce.ajaxSend('getProperties', path);
	setValue('itemsList', path);
	
	hide('thumbLink' );
    switch( ts ){
		case '0' :
			show('thumbIcon' );
			setHTML('thumbIcon', '<a href="javascript:void(0)" class="tools" onclick="createThumb();"><img src="' + jce.getPluginImg('thumb_create.gif') + '" alt="'+jce.getLang('create_thumb', true, 'Create Thumbnail')+'" title="'+jce.getLang('create_thumb', true, 'Create Thumbnail')+'" border="0" width="20" height="20" /></a>');
		break;
		case '1' :
			show('thumbIcon' );
			setHTML('thumbIcon', '<a href="javascript:void(0)" class="tools"  onclick="deleteThumb();"><img src="' + jce.getPluginImg('thumb_delete.gif') + '" style="cursor:pointer;" alt="'+jce.getLang('delete_thumb', true, 'Delete Thumbnail')+'" title="'+jce.getLang('delete_thumb', true, 'Delete Thumbnail')+'" border="0" width="20" height="20" /></a>');
		break;
	}
};
// While loading
preinit();