﻿/* 
* @copyright Copyright (C) 2007-2008 Ryan Demmer. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
class FlvPreview {
	//External Configuration variables
	private var options:Object = {frontcolor:0x333333, lightcolor:0x999999};
	//Constructor
	public function FlvPreview() {
		//Setup config variables
		for (var n in this.options) {
			if (_root[n] != undefined) {
				this.options[n] = _root[n];
				if (this.options[n] == 'true' || this.options[n] == '1') {
					this.options[n] = true;
				}
				if (this.options[n] == 'false' || this.options[n] == '0') {
					this.options[n] = false;
				}
			}
		}
		initPlayer();
	}
	private function initPlayer() {
		this.buildPlayer();
	}
	private function buildPlayer() {
		//Set button states
		var self = this;
		_root.playBtn._visible = true;
		
		//Set Colors
		this.setColor(_root.playBtn,this.options.frontcolor);
		this.setColor(_root.muteBtn,this.options.frontcolor);
		this.setColor(_root.fullscreenBtn,this.options.frontcolor);
		
		// Play button
		_root.playBtn.onRollOver = function(){
			self.setColor(this, self.options.lightcolor);
		}
		_root.playBtn.onRollOut = function(){
			self.setColor(this, self.options.frontcolor);
		}
		
		// Fullscreen button
		_root.fullscreenBtn.onRollOver = function(){
			self.setColor(this, self.options.lightcolor);
		}
		_root.fullscreenBtn.onRollOut = function(){
			self.setColor(this, self.options.frontcolor);
		}
		// Mute Button
		_root.muteBtn.onRollOver = function(){
			self.setColor(this, self.options.lightcolor);
		}
		_root.muteBtn.onRollOut = function(){
			self.setColor(this, self.options.frontcolor);
		}		
		
		this.setColor(_root.volumeBtn.dark,this.options.frontcolor);
		this.setColor(_root.progressPlay,this.options.frontcolor);
		this.setColor(_root.progressLoad,this.options.lightcolor);
		this.setColor(_root.volumeBtn.light,this.options.lightcolor);
		this.setColor(_root.controllerEdge,this.options.frontcolor);
		
		_root.timeTxt.textColor = this.options.frontcolor;

		_root.timeBar.onRollOver = function(){
			_root.timeTxt.textColor = self.options.lightcolor;
		}
		_root.timeBar.onRollOut = function(){
			_root.timeTxt.textColor = self.options.frontcolor;
		}
	}
	private function setColor(mc:MovieClip, col:Number) {
		var color:Color = new Color(mc);
		color.setRGB(col);
	}
}