<?php
/**
* @version $Id: Spaw.php,v 1.8 2004/09/27 10:52:56 stingrey Exp $
* @package Mambo_4.5.1
* @copyright (C) 2000 - 2004 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onInitEditor', 'botSpawEditorInit' );
$_MAMBOTS->registerFunction( 'onGetEditorContents', 'botSpawEditorGetContents' );
$_MAMBOTS->registerFunction( 'onEditorArea', 'botSpawEditorArea' );

global $spaw_root, $spaw_dir;

/**
* Spaw WYSIWYG Editor - javascript initialisation
*/
function botSpawEditorInit() {
	global $spaw_root, $mosConfig_absolute_path, $spaw_dir, $mosConfig_live_site;

	$spaw_root = $mosConfig_absolute_path."/mambots/editors/spaw/";
	$spaw_dir = $mosConfig_live_site.'/mambots/editors/spaw/';
}

/**
* Spaw WYSIWYG Editor - copy editor contents to form field
* @param string The name of the editor area
* @param string The name of the form field
*/
function botSpawEditorGetContents( $editorArea, $hiddenField ) {
}

/**
* Spaw WYSIWYG Editor - display the editor
* @param string The name of the editor area
* @param string The content of the field
* @param string The name of the form field
* @param string The width of the editor area
* @param string The height of the editor area
* @param int The number of columns for the editor area
* @param int The number of rows for the editor area
*/
function botSpawEditorArea( $name, $content, $hiddenField, $width, $height, $col, $row ) {
	global $database, $mosConfig_absolute_path, $mosConfig_lang, $spaw_root, $spaw_dir, $spaw_default_theme, $spaw_default_css_stylesheet, $spaw_dropdown_data, $spaw_a_targets, $spaw_img_popup_url, $spaw_internal_link_script, $spaw_disable_style_controls, $spaw_imglibs, $spaw_upload_allowed, $spaw_img_delete_allowed, $spaw_valid_imgs, $mosConfig_live_site, $spaw_inline_js;
	
	// If running in the frontend $spaw_root must be iniciated here and not in botSpawEditorInit
	if( $spaw_root == '' ) {
		$spaw_root = $mosConfig_absolute_path."/mambots/editors/spaw/";
		$spaw_dir = $mosConfig_live_site.'/mambots/editors/spaw/';
	}
	require_once($spaw_root."spaw_control.class.php");
	
	// Get Mambot Parameters
	$query = "SELECT id FROM #__mambots WHERE element='spaw' AND folder='editors'";
	$database->setQuery( $query );
	$id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load( $id );
	$params =& new mosParameters( $mambot->params );

	// Get Default Template
	if( $params->get( 'template', '' ) == 1 ) {
		$database->setQuery( "SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'" );
		$tempcss = '';
		$tempcss = $database->loadResult();
		$tempcss = $mosConfig_live_site.'/templates/'.$tempcss.'/css/template_css.css';
	}else{
		$tempcss = '';
	}
	
	$sw = new SPAW_Wysiwyg( $hiddenField, html_entity_decode($content), substr($mosConfig_lang, 0, 2), $params->get( 'type', 'default' ), $params->get( 'theme', 'default' ), $width.'px', $height.'px', $tempcss );
	$sw->show();
}
?>