<?php
// $Id: editor.tmedit.php, v 1.0 2005/06/11 16:23:28 bpfeifer Exp $
/**
* Handler for TMEdit
* @ package TMEdit
* @ Copyright  2004, 2005 Bernhard Pfeifer - www.thinkmambo.com
* @ All rights reserved
* @ Released under ThinkMambo Free Software License: http://www.thinkmambo.com/license/TMEdit_license.txt
* @version $Revision: 1.0 $
**/

defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed!' );

$_MAMBOTS->registerFunction( 'onInitEditor', 'botTMeditEditorInit' );
$_MAMBOTS->registerFunction( 'onGetEditorContents', 'botTMeditEditorGetContents' );
$_MAMBOTS->registerFunction( 'onEditorArea', 'botTMeditEditorArea' );

	function botTMeditEditorInit() {
		global $mosConfig_live_site, $database, $_MAMBOTS;
		$query = "SELECT id FROM #__mambots WHERE element = 'tmedit' AND folder = 'editors'";
		$database->setQuery( $query );
		$id = $database->loadResult();
		$mambot = new mosMambot( $database );
		$mambot->load( $id );
		$params =& new mosParameters( $mambot->params );

		?>
		<script type="text/javascript">
		<!--
			_editor_url = "<?php echo $mosConfig_live_site; ?>/mambots/editors/tmedit/";
			<?php
			$language = $params->get( 'language', 'en' );
			?>
			_editor_lang = "<?php echo $language; ?>";
		//-->
		</script>
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/mambots/editors/tmedit/tmedit.js"></script>
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/mambots/editors/tmedit/dialog.js"></script>
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/mambots/editors/tmedit/lang/<?php echo $language; ?>.js"></script>
		<style type="text/css">@import url(<?php echo $mosConfig_live_site; ?>/mambots/editors/tmedit/tmedit.css)</style>
		<script type="text/javascript">
		<!--
			// load the plugin files
			<?php
			if( $params->get( 'tableoperations', '0' ) ) {
			?>
			TMEdit.loadPlugin("TableOperations");
			<?php
			}
			if( $params->get( 'enterparagraphs', '0' ) ) {
			?>
			TMEdit.loadPlugin("EnterParagraphs");
			<?php
			}
			if( $params->get( 'contextmenu', '0' ) ) {
			?>
			TMEdit.loadPlugin("ContextMenu");
			<?php
			}
			if( $params->get( 'css', '0' ) ) {
			?>
			TMEdit.loadPlugin("CSS");
			<?php
			}
			if( $params->get( 'insertsmiley', '0' ) ) {
			?>
			TMEdit.loadPlugin("InsertSmiley");
			<?php
			}
			?>
			var editor = null;
		//-->
		</script>
		<?php
		}

	function botTMeditEditorArea( $name, $content, $hiddenField, $width, $height, $col, $row ) {
		global $database, $mosConfig_live_site, $_MAMBOTS;
		$query = "SELECT id FROM #__mambots WHERE element = 'tmedit' AND folder = 'editors'";
		$database->setQuery( $query );
		$id = $database->loadResult();
		$mambot = new mosMambot( $database );
		$mambot->load( $id );
		$params =& new mosParameters( $mambot->params );
		if( $params->get( 'csspreview', '0' ) ) {
			$database->setQuery( "SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'" );
			$template = $database->loadResult();
		}
		?>
		<textarea name="<?php echo $hiddenField; ?>" id="<?php echo $hiddenField; ?>" cols="<?php echo $col; ?>" rows="<?php echo $row; ?>" style="width:<?php echo $width; ?>; height:<?php echo $height; ?>"><?php echo $content; ?></textarea>
		<?php
			$results = $_MAMBOTS->trigger( 'onCustomEditorButton' );
			if ($results) {
				foreach ($results as $result) {
					$buttons[] = "<img src=\"".$mosConfig_live_site."/mambots/editors-xtd/".$result[0]."\" onclick=\"editor".$name.".focusEditor();editor".$name.".insertHTML('".$result[1]."');\" />";
				}
				echo implode( "", $buttons );
			}
		?>
		<script language="JavaScript1.2" defer="defer">
		<!--
			// create the editor
		var editor<?php echo $name ?> = new TMEdit("<?php echo $hiddenField ?>");

			// retrieve the config object
		var config<?php echo $name ?> = editor<?php echo $name ?>.config;
		<?php
		if( $params->get( 'csspreview', '0' ) ) {
		?>
			config<?php echo $name ?>.pageStyle='@import url(<?php echo $mosConfig_live_site ."/templates/". $template ."/css/template_css.css";?>);';
		<?php
		} else {
		?>
			config<?php echo $name ?>.pageStyle='body {background: white; margin: 5px;} body, td, p {font-family: sans-serif; font-size: 12px;}';
		<?php
		}
		?>	
		config<?php echo $name ?>.sizeIncludesToolbar = false;
		config<?php echo $name ?>.height = "300px";
		config<?php echo $name ?>.width = "625px";

		/* BUTTON TEMPLATE SNIPPET BELOW - EDIT TO YOUR NEEDS! //
		
		config<?php echo $name ?>.registerButton({
		  id        : "",
		  tooltip   : "",
		  image     : _editor_url + "images/.gif",
		  textMode  : false,
		  action    : function(editor<?php echo $name ?>, id) {
						editor<?php echo $name ?>.focusEditor();
		                editor<?php echo $name ?>.insertHTML('');
		              }
		});
		
		// END BUTTON TEMPLATE SNIPPET */

		config<?php echo $name ?>.toolbar = [
			[ "fontname", "space", "fontsize", "space", "formatblock", "space", "separator", "space", "bold", "italic", "underline", "separator", "strikethrough", "subscript", "superscript", "separator", "createlink", "separator", "undo", "redo"],
			[ "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator", "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator", "forecolor", "hilitecolor", "space", "textindicator", "space", "removeformat", "separator", "htmlmode", "separator", "popupeditor", "separator", "preview"],
			[ "inserthorizontalrule", "insertcharacter", "insertimage", "insertfile", "separator", "inserttable", "toggleborders", "separator", "cut", "copy", "paste", "separator", "killword"],
		];

		<?php
			if( $params->get( 'tableoperations', '0' ) ) {
		?>
			editor<?php echo $name ?>.registerPlugin(TableOperations);
		<?php
			}
			if( $params->get( 'enterparagraphs', '0' ) ) {
		?>
			editor<?php echo $name ?>.registerPlugin(EnterParagraphs);
		<?php
			}
			if( $params->get( 'contextmenu', '0' ) ) {
		?>
			editor<?php echo $name ?>.registerPlugin(ContextMenu);
		<?php
			}
			if( $params->get( 'css', '0' ) ) {
		?>
			editor<?php echo $name ?>.registerPlugin(CSS, {
				combos : [ { label: "CSS Styles:",
					// 6 standard Mambo CSS template classes contained
					// add your own CSS classes like this (but leave [Default] for removal of classes)
					// "Class name to be shown in the drop down": "name of the class like typed in your CSS file",
					// Note: you mustn't put a comma to the last line!
						options: { "[Default]": "",
							"Small": "small",
							"Small Dark": "smalldark",
							"Contentheading": "contentheading",
							"Componentheading": "componentheading",
		 					"Message": "message",
		 					"Arrow": "arrow"							
						}
					} ]
				}
			);
		<?php
			}
			if( $params->get( 'insertsmiley', '0' ) ) {
		?>
			editor<?php echo $name ?>.registerPlugin(InsertSmiley);
		<?php
			}
			if ($name != "editor2") {
		?>
			TMEdit.agt = navigator.userAgent.toLowerCase();
			TMEdit.is_gecko  = (navigator.product == "Gecko");
			if (TMEdit.is_gecko) {
				setTimeout('editor<?php echo $name ?>.generate("<?php echo $hiddenField ?>")', 3000); // Mozilla needs a rest here, especially on Mac OS
			} else {
				editor<?php echo $name ?>.generate('<?php echo $hiddenField ?>');
			}
		<?php
			} else if ($name == "editor2") {
		?>
				editor<?php echo $name ?>.generate('<?php echo $hiddenField ?>');
		<?php
			}
		?>

		//-->
		</script>
		<?php
		}
		function botTMeditEditorGetContents( $editorArea, $hiddenField ) {
		}