<?php
/**
* Hot Property's Searchbot
*
* @package Hot Property 0.9
* @copyright (C) 2004 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <hotproperty@mosets.com>
**/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onSearch', 'botSearchHotProperty' );

# Include the config file
global $mosConfig_absolute_path;
require( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/config.hotproperty.php' );

# Include the language file. Default is English
if (file_exists($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php')) {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php');
} else {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/english.php');
}

/**
* Search method
* @param array Named 'text' element is the search term
*/
function botSearchHotProperty( $text, $phrase='', $ordering='' ) {
	global $database;

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	$wheres = array();
	switch ($phrase) {
		case 'exact':
			$wheres2 = array();
			$wheres2[] = "LOWER(p.name) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.intro_text) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.full_text) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.address) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.suburb) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.state) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.country) LIKE '%$text%'";
			$wheres2[] = "LOWER(p.postcode) LIKE '%$text%'";
			$where = '(' . implode( ') OR (', $wheres2 ) . ')';
			break;
		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$wheres2 = array();
				$wheres2[] = "LOWER(p.name) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.intro_text) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.full_text) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.address) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.suburb) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.state) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.country) LIKE '%$word%'";
				$wheres2[] = "LOWER(p.postcode) LIKE '%$word%'";
				$wheres[] = implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

	switch ($ordering) {
		case 'newest':
		default:
			$order = 'p.created DESC';
			break;
		case 'oldest':
			$order = 'p.created ASC';
			break;
		case 'popular':
			$order = 'p.hits DESC';
			break;
		case 'alpha':
			$order = 'p.name ASC';
			break;
		case 'category':
			$order = 't.name ASC, p.name ASC';
			break;
	}

	# The main search query
	$database->setQuery( "SELECT p.id AS id, p.created AS created, p.name AS title,"
	. "\n	p.intro_text AS text, '0' AS browsernav, "
	. "\n	CONCAT('index.php?option=com_hotproperty&task=view&id=',p.id) AS href,"
	.	"\n CONCAT_WS('/', '"._HP_COM_TITLE."', t.name) AS section"
	. "\nFROM #__hp_properties AS p"
	. "\nINNER JOIN #__hp_prop_types AS t ON t.id=p.type"
	. "\nWHERE ($where)"
	. "\n	AND p.published='1' AND t.published='1'"
	. "\n	AND (p.publish_up = '0000-00-00 00:00:00' OR p.publish_up <= NOW())"
	. "\n	AND (p.publish_down = '0000-00-00 00:00:00' OR p.publish_down >= NOW())"
	. "\nORDER BY $order"
	);

	return $database->loadObjectList();
}
?>