<?php

/**
* Hot Property's Featured Property Module
*
* @package Hot Property 0.9
* @copyright (C) 2004-2005 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <hotproperty@mosets.com>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

# Include the config file
require( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/config.hotproperty.php' );

# Include the language file. Default is English
if (file_exists($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php')) {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php');
} else {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/english.php');
}


# Get params
$count = intval( $params->get( 'count', 5 ) );

# Get total number of published featured items
//global $database;
$database->setQuery( "SELECT COUNT(*) AS total FROM #__hp_properties AS p"
	. "\nLEFT JOIN #__hp_prop_types AS t ON t.id=p.type"
	.	"\nWHERE p.published=1 AND p.approved=1 AND t.published=1"
	. "\n AND p.featured=1"
	. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
	. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())");
$total = $database->loadResult();

# Get Itemid, determine if the HP component is published
$database->setQuery("SELECT id FROM #__menu"
	.	"\nWHERE link='index.php?option=com_hotproperty'"
	.	"\nLIMIT 1");
$Itemid = $database->loadResult();

# Get all featured property
$database->setQuery( "SELECT p.* FROM #__hp_properties AS p"
		. "\nLEFT JOIN #__hp_prop_types AS t ON p.type = t.id"
		. "\nLEFT JOIN #__hp_featured AS f ON f.property = p.id"
		. "\nWHERE p.published='1' AND p.approved='1' AND t.published='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		.	"\nAND p.featured='1'"
		. "\nORDER BY f.ordering ASC"
		. "\nLIMIT 0, ".$count );
	$featured = $database->loadObjectList();
?>
<ul style="text-align:left">
<?php foreach($featured AS $f) { ?>
<li><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=view&amp;id='.$f->id.'&amp;Itemid='.$Itemid); ?>"><?php echo $f->name; ?></a></li>
 <?php } ?>
</ul>
<?php if ($total > $count) { 
echo '<a href="'
	.	sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewfeatured&amp;Itemid='.$Itemid)
	.	'">'._HP_MOREFEATURED.'</a>';
} ?>
