<?php

/**
* Hot Property's Featured Property Module with Pictures
*
* @package Hot Property 0.9
* @copyright (C) 2004-2005 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <hotproperty@mosets.com>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
global $option;

# Include the config file
require( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/config.hotproperty.php' );

# Include the language file. Default is English
if (file_exists($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php')) {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php');
} else {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/english.php');
}


# Get params
$count = intval( $params->get( 'count', 6 ) );
$direction = $params->get( 'direction', 'vertical' );

# Get total number of published featured items
$database->setQuery( "SELECT COUNT(*) AS total FROM #__hp_properties AS p"
	. "\nLEFT JOIN #__hp_prop_types AS t ON t.id=p.type"
	.	"\nWHERE p.published=1 AND p.approved=1 AND t.published=1"
	. "\n AND p.featured=1"
	. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
	. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())");
$total = $database->loadResult();

# Get Itemid, determine if the HP component is published
$database->setQuery("SELECT id FROM #__menu"
	.	"\nWHERE link='index.php?option=com_hotproperty'"
	.	"\nLIMIT 1");
$Itemid = $database->loadResult();
?>
<div class="news_slider top_stories">
  <div class="messaging"> Please Note: You may have disabled JavaScript and/or CSS. Although this news content will be accessible, certain functionality is unavailable.</div>
  <a href="javascript:;" class="skip" title="If you have JavaScript turned off, you will be unable to skip to the news content.">Skip to news content.</a>
  <div class="prev"> <a href="#"><img src="images/s_prev.gif" alt="to Previous Property" width="16" height="50" border="0" title="to Previous Property" env="images" /></a></div>
  <div class="next"> <a href="#"><img src="images/s_next.gif" alt="to Next Property" width="16" height="50" border="0" title="to Next Property" env="images" /></a></div>
 <div class="news_items">
 	<div class="container">  
<?php 

# Get First featured property of Each Category 
$database->setQuery( "SELECT * FROM #__hp_prop_types"
		. "\n WHERE  published='1'"
		. "\n ORDER BY ordering ASC"
		. "\n LIMIT 0, ".$count );
$featured_types = $database->loadObjectList();

foreach($featured_types as $featuredtypes) { 
	$database->setQuery( "SELECT p.* FROM #__hp_properties AS p"
		. "\nLEFT JOIN #__hp_featured AS f ON f.property = p.id "
		. "\nWHERE type= " . $featuredtypes->id
		. "\n   AND p.published='1' AND p.approved='1'"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
		.	"\nAND p.featured='1'"
		. "\nORDER BY f.ordering ASC"
		. "\nLIMIT 0, 1");
	$featured = $database->loadObjectList();
	if (count($featured) > 0){
	foreach($featured as $f) { 
	unset($thumb);
	# Get the first thumbnail of the property
	$database->setQuery( "SELECT * FROM #__hp_photos"
		. "\nWHERE property='".$f->id."'"
		. "\nORDER BY ordering ASC"
		. "\nLIMIT 0,1");
	$database->loadObject($thumb);
	if ($thumb->thumb <> '') {
		$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb.$thumb->thumb); 
	} else {
		$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_thumb.$hp_img_noimage_thumb); 
	}
#--------------------------------------------------------
# Populating non-core field's data
foreach($featured as $prop) { 
	$sql3 = "SELECT e.name, e.caption, e.featured, e.field_type, p.property, p.field, p.value FROM #__hp_properties2 AS p, #__hp_prop_ef AS e"
		.	"\nWHERE e.id=p.field AND e.published=1 AND e.featured=1 AND e.hidden=0 AND e.search=1"
		.	"\nAND p.property=" . $f->id;		

	$database->setQuery($sql3);
	$extras = $database->loadObjectList();
} // End foreach

$extras_html = "";
$prop_status = "";
foreach($extras as $e) {
	if ($e->value != "" ) {
		if ($e->name == "prop_status") {
			$prop_status = "*" . $e->value . "*";
		} else {
			$extras_html .= $e->caption . ": <strong>" . $e->value . "</strong><br />";
		}
	}
}
#---------------------------------------------------------

	?>
	<div class="item">	
		<div class="toggler"><?php echo $featuredtypes->name; ?></div>
		<div class="featured_float_sliding">
		<div class="cropme"><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=view&amp;id='.$f->id.'&amp;Itemid='.$Itemid); ?>">
 <?php echo '<img '.$thumb_imgsize[3].' border="0" src="'.$mosConfig_live_site."/".$hp_imgdir_thumb.((!empty($thumb->thumb)) ? $thumb->thumb : $hp_img_noimage_thumb).'" alt="'.$thumb->title.'" />'; ?></a></div>
		<div class="floatingtext">
			<span class="property_title"><?php echo $f->name . ""; ?></span>
	<?php if ($prop_status <> "" ) { ?>
			<span class="pro_status"><?php echo $prop_status; ?></span>
	<?php }?>
	<?php echo $f->intro_text; 
		echo "<div><br></div>";
		echo $extras_html; ?>
		<span class="price_tag"><?php echo $hp_currency."". number_format($f->price, $hp_dec_point, $hp_dec_string, ($hp_thousand_sep) ? $hp_thousand_string:'');?></span>
		</div>
	<div><a href="<?php echo sefRelToAbs('index.php?option=com_hotproperty&amp;task=view&amp;id='.$f->id.'&amp;Itemid='.$Itemid); ?>" class="readon"><?php echo "plus d'info";?></a></div>
	</div>
</div>
 <?php } // End of Featured Pro Loop
	}  // End of IF not empty
 } // End of Types Loop 

?>
		</div>
	</div>
</div>
<?php 
if (count($featured) >0) {
?><div class="more"><?php echo '<a href="' . sefRelToAbs('index.php?option=com_hotproperty&amp;task=viewfeatured&amp;Itemid='.$Itemid) .'">'._HP_MOREFEATURED.'</a>'; ?></div>
<?php 	
} ?>
<script type="text/javascript">
$(function() {
    var options = {headline: "Top Stories", newsWidth: 240, newsSpeed: "normal"};
    $(".top_stories").slideNews(options);
});
	try {
		Window.disableImageCache();
	} catch(e) {}
</script>

