<?php

/**
* Hot Property's List Agents with Picture Module
*
* @package Hot Property 0.9
* @copyright (C) 2004-2005 Lee Cher Yeong
* @url http://www.Mosets.com/
* @author Lee Cher Yeong <hotproperty@mosets.com>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

# Include the config file
require( $mosConfig_absolute_path.'/administrator/components/com_hotproperty/config.hotproperty.php' );

# Include the language file. Default is English
if (file_exists($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php')) {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/' . $mosConfig_lang . '.php');
} else {
	include($mosConfig_absolute_path . '/components/com_hotproperty/language/english.php');
}

# Assign parameter
$max_count = intval( $params->get( 'max_count', 3 ) );
$direction = $params->get( 'direction', 'vertical' );
$show_all_co = intval( $params->get( 'show_all_co', 1 ) );
$company_id = intval( $params->get( 'company_id', 0 ) );
$show_empty = intval( $params->get( 'show_empty', 1 ) );
$show_photo = intval( $params->get( 'show_photo', 1 ) );
$show_num_of_prop = intval( $params->get( 'show_num_of_prop', 1 ) );
$show_co = intval( $params->get( 'show_co', 0 ) );
$show_mobile = intval( $params->get( 'show_mobile', 0 ) );

# Get all agents
$database->setQuery("SELECT a.*, c.id AS companyid, c.name AS company FROM #__hp_agents AS a"
	.	"\nLEFT JOIN #__hp_companies AS c ON c.id=a.company"
	. ( (!$show_all_co && $company_id > 0) ? "\n WHERE c.id = $company_id" : '' )
	.	"\nGROUP BY a.id"
	.	"\nLIMIT $max_count"	
	);
$agents = $database->loadObjectList();

# Get number of active properties each agent has
$database->setQuery( "SELECT p.agent, COUNT(p.id) AS count FROM #__hp_properties as p "
	.	"\n LEFT JOIN #__hp_prop_types AS t ON t.id=p.type"
	.	"\nWHERE p.published='1' AND p.approved='1' AND t.published='1'"
	. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= NOW())"
	. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= NOW())"
	.	"\nGROUP BY p.agent");
$properties = $database->loadObjectList('agent');

# Get Itemid, determine if the HP component is published
$database->setQuery("SELECT id FROM #__menu"
	.	"\nWHERE link='index.php?option=com_hotproperty'"
	.	"\nLIMIT 1");
$Itemid = $database->loadResult();

?><table cellpadding="2" cellspacing="1" border="0" width="100%">
<?php if ($direction == 'horizontal') echo "<tr>"; ?>
<?php foreach($agents AS $agent) { 
	if ( !$show_empty && $properties[$agent->id]->count == 0 ) {

	} else {
		if ( empty($properties[$agent->id]->count) ) $properties[$agent->id]->count = 0;
?>
  <?php if ($direction == 'vertical') echo "<tr>"; ?><td align="center" valign="bottom">
		<?php
			if ( !empty($agent->photo) && $show_photo ) {
				if ( file_exists($mosConfig_absolute_path.$hp_imgdir_agent.$agent->photo) ) {
					$thumb_imgsize = GetImageSize ($mosConfig_absolute_path.$hp_imgdir_agent.$agent->photo); 
					echo '<center><a href="'.sefRelToAbs("index.php?option=com_hotproperty&Itemid=$Itemid&task=viewagent&id=$agent->id").'"><img '.$thumb_imgsize[3].' src="'.$mosConfig_live_site.$hp_imgdir_agent.$agent->photo.'" border="0" vspace="5" hspace="0" /></a></center>';
				}
			}
			echo '<a href="'.sefRelToAbs("index.php?option=com_hotproperty&Itemid=$Itemid&task=viewagent&id=$agent->id").'">'.$agent->name . "</a>";
			if ($show_co) echo '<br />'._HP_COMPANY.': <a href="'.sefRelToAbs("index.php?option=com_hotproperty&Itemid=$Itemid&task=viewco&id=$agent->companyid").'">'.$agent->company.'</a>';
			if ($show_num_of_prop)echo '<br />'._HP_PROPERTIES.': '.$properties[$agent->id]->count;
			if ($show_mobile && !empty($agent->mobile))echo '<br />'._HP_AGENT_MOBILE.': '.$agent->mobile;
		?>		
	</td><?php if ($direction == 'vertical') echo "</tr>"; ?>
 <?php 
		} // End of if		
	} // End of foreach
		
?>
<?php if ($direction == 'horizontal') echo "</tr>"; ?>
</table>
