<?php
/**
* @version $Id: mod_relateditems_xtd.php, v4.11 2005/09/27  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/***************************************************** */
/* Related Items Modules XTD, version 4.10beta         */
/***************************************************** */

/* Any problems, feature requests etc. write here:     */
/* http://developer.joomla.org/sf/sfmain/do/viewProject/projects.related_items_bot_and_module_doc          */
/* By Tomas Hanzelka (http://tomh.gdi.cz) 			   */

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/* ************************************************************************** */
// PART 0 - Main configuration, list of know MiniBots and their shortcuts
// For each MiniBot one file here is expected:
// Path: <MAMBO_ROOT>/module/relateditems/rib_[MINIBOTFULLNAME].inc.php
/* ************************************************************************** */

// Try to avoid more-includes
if ( (!defined('_MOSBOT_RELATED_ITEMS_ISON')) && (!defined('_MOSMOD_RELATED_ITEMS_ISON')) ) {

    function getListOfMiniBots() {
    	$MINI_BOTS = Array();

    	// List of all known  MiniBots (key is FULLNAME, value is three-letter SHORTCUT)
    	$MINI_BOTS['MainMenu'] 	         = "mnu";
    	$MINI_BOTS['SectionCategories']  = "cat";
    	$MINI_BOTS['ContentItems'] 	  	 = "cnt";
    	$MINI_BOTS['Weblinks'] 		  	 = "wbl";
    	$MINI_BOTS['NXTLinks'] 		  	 = "nxt";
    	$MINI_BOTS['Remository'] 	     = "rem";
    	$MINI_BOTS['Galleries'] 	     = "gal";
    	$MINI_BOTS['Events'] 	     	 = "eve";

    	return $MINI_BOTS;
    }

    // This is hard-limit of max. count all items showed by this bot
    if (!defined("_MOSBOT_RELATED_ITEMS_LIMIT")) {
    	define ( '_MOSBOT_RELATED_ITEMS_LIMIT', 500);
    }

    /* ************************************************************************** */
    // PART I - Functions for run MiniBots
    /* ************************************************************************** */
    // MAIN Function
    // Gets all avail MiniBots, and make search with $words
    // If mod==1, than caller is module not bot
    function getRelations($words,$contentid,&$params,$mod=0) {
    	global $mosConfig_absolute_path;

        $orderArray  = Array();
        $items	     = Array();
        $mbot_result = Array();

        $limit  	 = $params->get( 'limit'    , _MOSBOT_RELATED_ITEMS_LIMIT);
        $maxwords 	 = $params->get( 'maxwords' , 5);

        if ($limit > _MOSBOT_RELATED_ITEMS_LIMIT) {
        	$limit = _MOSBOT_RELATED_ITEMS_LIMIT;
        }

    	$allMiniBots = getListOfMiniBots();
    	$words 		 = array_unique(array_slice($words,0,$maxwords));

        // Main settings for minibot, make them in right order
    	foreach ($allMiniBots as $key=>$val) {
    		$orderArray[] = $params->get($val."_botorder" ,100);
    	}

    	array_multisort($orderArray,SORT_ASC,$allMiniBots);

        // This will call all minibots and get data
        foreach ($allMiniBots as $key => $mbot) {
        	$mbot_limit = $params->get($mbot."_limit" ,5);
            $fname =  "getRelated".$key;

        	if (!$params->get($mbot."_ison" ,0)) {
        		continue;
        	}

        	// Test if there are some words to search and fulltext is off
			if (empty($words) && (!$params->get($mbot."_fulltext" ,0))) {
    			continue;
    		}

    		if (!(function_exists($fname))) {
        		// Include MiniBot
            	if ($mod) {
            		$path  = $mosConfig_absolute_path . "/modules/relateditems/";
            	}
            	else {
            		$path  = $mosConfig_absolute_path . "/mambots/content/relateditems/";
            	}

        		$path .= "rib_".strtolower($key).".inc.php";
        		if (file_exists($path)) {
        			@include_once $path;
        		}
        		else {
        			continue;
        		}
    		}

    		// If function is defined so go on
    		if (function_exists($fname)) {
    			$in_limit = ($limit < $mbot_limit) ? $limit : $mbot_limit;
    			$mbot_result =  $fname($contentid,$in_limit,$words,$params);
    			if (!empty($mbot_result)) {
    				 $items[$mbot] = $mbot_result;
    			}
    		}

        	// Check if are not have more than 'Global limit' items
        	$limit -=  count($mbot_result);
        	if ($limit <= 0) {
        		break;
    		}
        }

        // If not found anything please go ... out
        if (count($items)==0)  {
        	return '';
        }

        // This will show founded data in HTML (see PART II.)
        return formatFinaly($items,$params);
    }

    /* ************************************************************************** */
    // PART II - Formating function below, how to print HTML around our data
    /* ************************************************************************** */
    function formatURL($url) {

    	$url = sefRelToAbs($url);

    	// Replace bad ampersands in URL
    	$url = Str_Replace('&amp;','&',$url);
    	$url = Str_Replace('&','&amp;',$url);

         return $url;
    }

    // HTML Function - Name, link and description of item (all styles)
    function formatLink($item ,$titlelimit,$mbottarget = 'default', $class = '') {

    	$html = '';
    	// Make title
		$title = $item['title'];

		if (StrPos($title,'<img src="') === false) {
			$title  = ($titlelimit ?   SubStr($item['title'],0,$titlelimit) : $item['title']);
		}

		// Make href
		$href   = formatURL($item['url']);

		// Make target
		$target = (isSet($item['target']) ? $item['target'] : "") ;

        // Check if link has own targetn , if not use global for MiniBot
        // [OWN TARGET FOR EACH LINKS IS NOT IMPLEMENTED YET]
    	if (!$target)  {
    		$target = $mbottarget;
    	}

        // If not set target use default
    	if ((!$target) || ($target=="default")) {
    		$target = 3;
    	}

    	// Add class
        $class = ($class ? ' class="'.$class.'" ' : '');

    	// Swicth by target number (1-blank,2-popup,3-parent)
    	switch ($target) {
    		case 1:
    			$html = '<a '.$class.' href="'. $href .'" target="_blank">'. $title .'</a>';
    		break;

    		case 2:
    			$html = '<a '.$class." href=\"#\" onclick=\"javascript: window.open('". $href ."', '', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550'); return false\">". $title ."</a>";
    		break;

    		case 3:
    		default:
    			$html = '<a '.$class.' href="'. $href .'">'. $title .'</a>';
    		break;
    	}

    	// Add text after link if is any
        if ( (isSet($item['text'])) && ($item['text']!="")) {
        	$html .= " - ".$item['text']." ";
        }

    	return $html;
    }

    // HTML Function - Title of MiniBot (all styles)
    function formatTitle($titleison,$title,$tag,$likemodule = 0) {
    	$html = '';

    	if (!$titleison) {
    		return $html;
    	}

		if ($likemodule) {
			$html = "\n<tr><th>".$title."</th></tr>";
		}
		else {
    		$html = "\n".'<'.$tag.'>'.$title.'</'.$tag.'> '. "\n" ;
    	}

        return $html;
    }

    // HTML Function for style 'Inline'
    function formatInline($items,$target,&$params) {

        $html = '';
        $separator  = $params->get( 'inlineseparator' , '');
        $titlelimit = $params->get( 'maxtitle'        ,0);
        $aclass		= $params->get( 'aclass'		  ,'');

        if (!$items) {
        	return '';
    	}

    	foreach ($items as $item) {
    		$html .= formatLink($item,$titlelimit,$target,$aclass);
    		$html .= $separator;
    	}
    	$html = SubStr($html,0,-StrLen($separator));

    	return $html;
    }

    // HTML Function for style 'Block'
    function formatBlock($items,$target,&$params,$blockclass,$ordered=0) {

        $itemclass  = $params->get('itemclass' , '');
        $titlelimit = $params->get( 'maxtitle' , 0);
    	$bltag      = ($ordered == 1 ? 'ol' : 'ul');
        $aclass		= $params->get( 'aclass'		  ,'');
        $html = '';

        if (!$items) {
        	return '';
    	}

    	$html = '<'.$bltag.' '. ( $blockclass ? ' class="'.$blockclass.'" ' : '') . '>' ;

    	foreach ($items as $item) {
    		$html .= '<li '.($itemclass ? ' class="'.$itemclass.'" ' : '').'>';
    		$html .= formatLink($item,$titlelimit,$target,$aclass);
    		$html .= '</li>';
    		$html .= "\n";

    	}
    	$html .= '</'.$bltag.'>';
    	$html .=   "\n";

    	return $html;
    }

    // HTML Function for style 'Simple'
    function formatSimple($items,$target,&$params) {

        $titlelimit = $params->get( 'maxtitle' , 0);
        $aclass		= $params->get( 'aclass'		  ,'');
        $html = '';

        if (!$items) {
        	return '';
    	}

    	foreach ($items as $item) {
    		$html .= formatLink($item,$titlelimit,$target,$aclass)."<br/>\n";
    	}

    	return $html;
    }

    // HTML Function for style 'Table-Columns'
    function formatTableColumn($items,$target,&$params) {

        $titlelimit = $params->get( 'maxtitle'        ,0);
        $aclass		= $params->get( 'aclass'		  ,'');

        $html = '';

        if (!$items) {
        	return '';
    	}

    	foreach ($items as $item) {
    		$html .= formatLink($item,$titlelimit,$target,$aclass) .'<br/>';
    	}

    	$html .=   "\n";

    	return $html;
    }

    // HTML Function for style 'Table-TOC'
    function formatTableTOC($items,$target,&$params) {

        $titlelimit = $params->get( 'maxtitle'   , 0);
        $aclass		= $params->get( 'aclass'	 ,'');
        $itemclass	= $params->get( 'itemclass'  ,'');

        $html = '';

        if (!$items) {
        	return '';
    	}

    	$tr = '<tr><td'.($itemclass ? ' class="'.$itemclass.'" ': '').'>';
    	foreach ($items as $item) {
    		$html .= $tr . formatLink($item,$titlelimit,$target,$aclass) .'</td></tr>'."\n";
    	}

    	$html .=   "\n";

    	return $html;
    }

    function formatSelect($items,$target,&$params) {

    	$titlelimit = $params->get( 'maxtitle'   , 0);
    	$itemclass	= $params->get( 'itemclass'  ,'');
        $first		= $params->get( 'firsttext'  ,'');
        $html = '';

        if (!$items) {
        	return '';
    	}

    	if (!$first) {
			$first = _CMN_SELECT . '&nbsp;'._CMN_NEXT_ARROW;
		}
		$html .= "<option>".$first ."</option>";

        $opt = '<option '.($itemclass ? ' class="'.$itemclass.'" ': '');
    	foreach ($items as $item) {
    		$title  = ($titlelimit ?   SubStr($item['title'],0,$titlelimit) : $item['title']);
			$html .= $opt. ' value="'.formatURL($item['url']).'" >'.$title;

    		// Add text after link if is any
        	if ( (isSet($item['text'])) && ($item['text']!="")) {
        		$html .= " - ".$item['text']." ";
        	}

        	$html .= '</option>'. "\n";
    	}

    	$html .=   "\n";

    	return $html;
    }

    // Format if there is no items
    function formatNoItems($mod,&$params) {

    	$text  = $params->get( 'show_noitem_text' );
    	$class = $params->get( 'blockclass' );

    	$html  = '';

    	if (!$mod) {
    		$html .= formatTitle($params->get('cnt_showtitle'),
    						 $params->get('cnt_title'),
    						 $params->get( 'tag' ),0 );
    	}
    	$html .= '<span id="ribni" '.($class ? ' class="'.$class.'" ' : '' ).'>'.$text.'</span>';

    	return $html;
    }

    // Main HTML Function
    function formatFinaly($items, &$params) {

    	$showstyle  = $params->get('showstyle'    , 'block');
        $spclass    = $params->get('spanclass'    , '');
        $blockclass = $params->get('blockclass'   , '');
        $itemclass  = $params->get('itemclass'    , '');
        $va			= $params->get('table_valign' , 0);
        $wrap		= $params->get('table_wrap'   , 0);
        $moduletitle= $params->get('module_title' , 0);


    	$tag        = $params->get('tag'          , '');
    	$related    = "";
    	$botcount	= 0;
    	$tag  	    = getBlockTag($tag);

        $select = '<select '.( $blockclass ? 'class="'.$blockclass.'" ': '' );

        // *************************
        // *** HTML Before iteration
        // *************************
    	switch ($showstyle) {

    		// INLINE - Items Inline
    		case "inline": {
        		$related .= $params->get('inlinebefore' , '').' ';
        		break;
    		}

    		// TABLE - Items in one table-row with more columns with one MiniBot in
            case "table": {
            	$related .= '<table ';
    			if ($blockclass) {
    				$related .= ' class="'.$blockclass.'" ';
    			}
    			$related .= '>' ;
    			$related .= '<tr>';
        		break;
    		}

            // TOC LIKE - Items as TOC
    		case "toc": {
    			$related .= '<table class="'.$blockclass.'">';
    			break;
    		}

    		// SELECT 1 - Items in one select box, now always in same window
    		case "select1": {
    			$related .= $params->get('inlinebefore' , '').' ';
        		$related .= $select. ' onchange="location.href=this.options[this.selectedIndex].value" >';
        		break;
    		}

    		// SELECT 2 - Items in more select boxes
    		case "select2": {
    			$related .= $params->get('inlinebefore' , '').' ';
        		break;
    		}

    		// BLOCK - Items as List
    		default:
    		case "block":
    		case "block0":
    		case "block2":
    		case "select2":  {
    		}
    	}

        // *****************************************
        // *** Iteration throught each MiniBot links
        // *****************************************
        foreach ($items as $mbot => $links) {

            if (!$links) {
            	continue;
            }

            $mbot_showtitle = $params->get($mbot."_showtitle" ,0);
            $mbot_title		= $params->get($mbot."_title"  ,'');
            $mbot_target	= $params->get($mbot."_target" ,'default');

    		switch ($showstyle) {

    			// INLINE - Items Inline
    			case "inline": {
            		$related .= formatInline($links,$mbot_target, $params);
            		break;
    			}

    			// TABLE - Items in one table-row with more columns with one MiniBot in
                case "table": {
                	$related .= '<td'.($itemclass ? ' class="'.$itemclass.'" ': ''). ' '.($va ? 'style="vertical-align:top">' : '');
                		$related .= formatTitle($mbot_showtitle,$mbot_title,$tag);
            			$related .= formatTableColumn($links,$mbot_target, $params);
            		$related .= '</td>';

                    // If wrapping is on, so add new line after $wrap count of columns
            		if ($wrap) {
            			$botcount++;
            		 	if ($botcount >= $wrap) {
                            $related .= "</tr><tr>";
            		 		$botcount = 0;
            		 	}
            		}
            		break;
    			}

    			// TOC LIKE STYLE
    			case "toc": {

    				if ($mbot_showtitle) {
    					$related .= '<tr><th>'.$mbot_title.'</th><tr>';
    				}

    				$related .= formatTableTOC($links,$mbot_target, $params);

    				break;
    			}

        		// SELECT 1 - Items in one select box
        		case "select1": {
        			if ($mbot_showtitle) {
    					$related .= '<optgroup label="'.$mbot_title.'">';
    				}
            		$related .= formatSelect($links,$mbot_target, $params);
            		if ($mbot_showtitle) {
    					$related .= '</optgroup>';
    				}

            		break;
        		}

        		// SELECT 2 - Items in more select boxes
        		case "select2": {

        			$related .= formatTitle($mbot_showtitle,$mbot_title,$tag,$moduletitle);
            		$related .= $select;

    				switch ($mbot_target) {
    					case 1:
    					case 2: $related .= ' onchange="window.open(this.options[this.selectedIndex].value, \'\', \'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550\'); return false"'; break;
    					case 3: $related .= ' onchange="location.href=this.options[this.selectedIndex].value" >'; break;

    				}

                    	$related .= formatSelect($links,$mbot_target, $params);
            		$related .= '</select>';

            		break;
        		}

    			 // BLOCK - Items as List with numbers
    			case "block2": {
    				$related .= formatTitle($mbot_showtitle,$mbot_title,$tag,$moduletitle);
    				$related .= formatBlock($links, $mbot_target, $params,$blockclass,1);
    				break;
    			}

    			// BLOCK - Items only on new row
        		case "block0": {
        			$related .= formatTitle($mbot_showtitle,$mbot_title,$tag,$moduletitle);
        			$related .= formatSimple($links, $mbot_target, $params,$blockclass);
        			break;
        		}

        		// BLOCK - Items as List unordered
    			default:
    			case "block": {
    				$related .= formatTitle($mbot_showtitle,$mbot_title,$tag,$moduletitle);
    				$related .= formatBlock($links, $mbot_target, $params,$blockclass,0);
    				break;
    			}


    		}
        }

        // ************************
    	// *** HTML After iteration
    	// ************************
    	switch ($showstyle) {

    		// INLINE - Items Inline
    		case "inline": {
        		$related .= $params->get( 'inlineafter' ,'');
        		break;
    		}

    		// TABLE - Items in one table-row with more columns with one MiniBot in

            case "table": {
            	$related .= '</tr>';
    			$related .= '</table>';
        		break;
    		}

    		// TOC LIKE
            case "toc": {
    			$related .= '</table>';
        		break;
    		}

    		// SELECT 1 - Items in one select box
    		case "select1": {
        		$related .= '</select>';
        		break;
    		}

    		// BLOCK - Items as List
    		default:
    		case "block":
    		case "block0":
    		case "block2":
    		case "select2": {
    		}
    	}

    	// *** Finish return $related
    	if ($spclass) {
    		return "\n".'<span class="'.$spclass.'">'.$related.'</span>'."\n";
    	}
    	else {
    		return $related;
    	}
    }

    /* ************************************************************************** */
    // PART III - Some subsidiary functions
    /* ************************************************************************** */

    // Escape entered metakeys to use it in SQL statements and remove IGNORE words
    // Return array of nonblank,nonignore strings
    function getEscapedWord($words,$ignorewords, $noacc = 1,$remnonword = 0) {
    	global $database,$mosConfig_absolute_path,$mosConfig_lang;

    	$words         = array_unique(explode(',', trim ($words)));
    	$return 	   = Array();
        $search_ignore = Array();
		$ignore_words  = Array();

    	@include_once "$mosConfig_absolute_path/language/$mosConfig_lang.ignore.php";

		$ignore_words = array_unique( array_merge($search_ignore, explode(',', trim ($ignorewords))));

    	// If not accent is set to on add noacc words too
		if (!$noacc) {
			$words = array_unique(array_merge($words,array_map('getWithoutAccent',$words)));
		}

		// Remove non-word characters
		if ($remnonword) {
			$words = array_map('getOnlyAlfaNums',$words);
		}

    	// Assemble any non-blank,non-ingnore word(s)
    	foreach ($words as $key) {
    		$key = trim( $key );
    		if ( ($key) && (!in_array( $key, $ignore_words )) ) {
    			$return[] = $database->getEscaped( $key );
    		}
    	}

    	return $return;
    }

    // Return HTML tag inputed if is one of block-and-pair tag else return 'h3'
    function getBlockTag($what) {

    	$ok_tags = Array('blockquote','pre','address','center','div','p','h1','h2','h3','h4','h5','h6');
    	$what    = strtolower($what);

    	if (in_array($what,$ok_tags)) {
    		return $what;
    	}

    	return 'h3';
    }

    // Function for the minibots with which they can find the most appropriate MenuItem
    // Similar to $mainframe->getItemid($row->id);, but then for any component
    // by Reinier Battenberg
    function getMenuLink ($component, $nameforcategory, $categoryid, $nameforid, $id) {
    	global $my,$database,$mosConfig_shownoauth;

        $result = "";

    	// first we fetch all the menus that we have access to that have the
    	// componentname in itself. (in this case that will be 'com_akogallery')
    	$query = "SELECT  id,link FROM #__menu WHERE published=1 ";

    	if (!$mosConfig_shownoauth) {
           	$query .= " AND access <= '$my->gid' ";
    	}

    	$query .= ' AND link LIKE "%option='.$component.'%" ';

    	$database->setQuery( $query );
    	$rows = $database->loadObjectList();

    	if (!$rows)  {
    		// no rows means there is no menuitem pointing to this component
    		return $result;
    	}

    	foreach ($rows as $row ) {
    		$tp  = $row->link;

    		// look for a menuitem that points to this ID
    	 	if (
    	 		// this is for &id=123&
    	 		(substr_count($tp, "&". $nameforid."=".$id."&" ) > 0)
    		 		||
    			(strpos($tp, "&".$nameforid."=".$id ) + strlen("&".$nameforid."=".$id) >= strlen($tp))
    		)

    		// This is for when the &id=123 is at the end of the LINK, not in the middle
    		// because then id=2 would match id=20
    		{
    			$tp = substr($tp, strpos(strtoupper($tp), "ITEMID=") + 7 );
    			$result = substr($tp, 0, strpos($tp, "&"))."want".$nameforid."=".$id;

    			// we found a menu pointing to this sepcific ID, so break out of the foreach
    			break 1;
    	 	}

    		//look for a menuitem that points to the category of this ID
    	 	if (
    	 	  (substr_count($tp, "&".$nameforcategory."=".$categoryid ."&") > 0)
    		  ||
    		  (strpos($tp, "&".$nameforcategory."=".$categoryid) + strlen("&".$nameforcategory."=".$categoryid) >= strlen($tp))
    		  )
    		{
    			$tp = substr($tp, strpos(strtoupper($tp), "ITEMID=") + 7 );
    			$result = substr($tp, 0, strpos($tp, "&"))."catwant".$nameforcategory."=".$categoryid;
    			continue;
    			// we found a menuitem pointing to the category of this item, so break out of this loop, and continue with the next
    	 	}

    		// look for a menuitem that points to the component
    		// (if the result is not yet set that's better then nothing)
    	 	if (
    	 			(!strpos($tp, "&". $nameforcategory ) ) &&
    	 			(!strpos($tp,"&". $nameforid ) ) &&
    	 			(strlen($result) ==0)
    	 	    )
    	 	{
    	 		// we found a menuitem pointing to this component: keep looking!
    	 	    $result = $row->id;
    		}
    	}

    	return  $result;
    }

    // Return string witout accent (in 7-bit ASCII), hope work well
    // Copied from php.net contrubutor notes
    function getWithoutAccent($str) {

       $str = StrTr($str, "OoYYAAAAEEII?NOOOUUaaaaeeii?nooouuy",
     			          "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
       $str = StrTr($str,
     	"\xe1\xc1\xe0\xc0\xe2\xc2\xe4\xc4\xe3\xc3\xe5\xc5\xaa\xe7\xc7\xe9\xc9\xe8\xc8\xea\xca\xeb\xcb\xed".
     	"\xcd\xec\xcc\xee\xce\xef\xcf\xf1\xd1\xf3\xd3\xf2\xd2\xf4\xd4\xf6\xd6\xf5\xd5\x8\xd8\xba\xf0\xfa".
     	"\xda\xf9\xd9\xfb\xdb\xfc\xdc\xfd\xdd\xff\xe6\xc6\xdf",
     	"aAaAaAaAaAaAacCeEeEeEeEiIiIiIiInNoOoOoOoOoOoOoouUuUuUuUyYyaAs");

    	return $str;
    }

    //Return string withnou non-word characters
	function getOnlyAlfaNums($str) {

		return preg_replace("/[\W_]/","",$str);
	}



} // end if bot is alreasy ON

if (!(defined('_MOSMOD_RELATED_ITEMS_ISON'))) {

// Module specific function  - Return metakys of Content Item by ID
function getContentItemMetakeys($contentid, &$params) {
	global $my, $database;

	$stype = $params->get( 'stype' , 'phrase');

	// Select the meta keywords and sec,cat id (migh be useful) from the item
	$query = "SELECT metakey,catid,sectionid FROM #__content WHERE id='$contentid'";
	$database->setQuery( $query );

	$res = $database->loadRow();

    $metakey = trim($res[0]);
    $params->set('rib_catid',$res[1]);
    $params->set('rib_secid',$res[2]);

	if ($stype == "words") {
		$metakey = str_replace("  "," ",$metakey);
		$metakey = str_replace(" ",",",$metakey);
	}

    $words = getEscapedWord($metakey,
    					    $params->get('ignorewords'),
    					    $params->get('noacc',0),
    					    $params->get('remnonword',0)
    					    );
	return $words;
}

}

/* ************************************************************************** */
// PART IV - Module specific code
/* ************************************************************************** */

$option = trim  ( mosGetParam( $_REQUEST, 'option', null ) );
$task   = trim  ( mosGetParam( $_REQUEST, 'task', null ) );
$id     = intval( mosGetParam( $_REQUEST, 'id', null ) );

$moduleclass_sfx  = $params->get( 'moduleclass_sfx' );
$show_owntitle    = $params->get( 'show_owntitle' );
$owntitle 		  = $params->get( 'owntitle' );
$show_noitem	  = $params->get( 'show_noitem' );
$show_noitem_text = $params->get( 'show_noitem_text' );
$blockclass		  = $params->get( 'blockclass' );

if ($option == 'com_content' && $task == 'view' && $id) {

	$related = getRelations(getContentItemMetakeys($id,$params),$id,$params,1);

	if ($related) {
		if ($show_owntitle && $owntitle) {
           echo '</td></tr><tr><th valign="top">'.$owntitle.'</th></tr><tr><td>';
		}
		echo $related;
	}

	elseif ($show_noitem) {
		if ($show_owntitle && $owntitle) {
           echo '</td></tr><tr><th valign="top">'.$owntitle.'</th></tr><tr><td>';
		}
		echo formatNoItems(1,$params);
	}
}

// Try to avoid include bugs with than one mod on page
if (!defined('_MOSMOD_RELATED_ITEMS_ISON')) {
	define('_MOSMOD_RELATED_ITEMS_ISON',true);
}


?>
