<?php
/**
* @version $Id: contentitems.inc.php, v1.07 2005/08/10  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot ContentItems (cnt) 1.07	                            */
/* Search in all core ContentItems of your Mambo site           */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* --> cnt_mysec [0,1,2] : if [(1 == don't) (2==only)] search in self section of viewed/searched Item */
/* --> cnt_mycat [0,1,2] : if [(1 == don't) (2==only)] search in self category of viewed/searched Item */

function getRelatedContentItems($contentid,$limit,$words,&$params){

    global $my,$database,$mosConfig_offset,$mainframe,$option,$task;

    $sensitive   = $params->get( 'sensitive'        , 0 );
    $titletoo    = $params->get( 'cnt_titletoo'     , 0 );
    $order	     = $params->get( 'cnt_order' 	    , 0 );
    $mysec	     = $params->get( 'cnt_mysec' 	    , 0 );
    $mycat	     = $params->get( 'cnt_mycat' 	    , 0 );
    $onlysec     = $params->get( 'cnt_onlysec'      , 0 );
    $onlycat     = $params->get( 'cnt_onlycat'      , 0 );
    $restsec     = $params->get( 'cnt_restsec'      , 0 );
    $restcat     = $params->get( 'cnt_restcat'      , 0 );
    $fulltext    = $params->get( 'cnt_fulltext'     , 0 );
    $fullcompare = $params->get( 'cnt_fullcompare'  , 0 );
    $fullscore   = $params->get( 'cnt_fullscore'    , 0 );
    $fullscoreon = $params->get( 'cnt_fullscoreon'  , 0 );
    $fullorder   = $params->get( 'cnt_fullorder'    , 0 );
    $static		 = $params->get( 'cnt_static'       , 0 );
    $archived    = $params->get( 'cnt_archived'     , 0 );
	$showintro   = $params->get( 'cnt_showintro'    , 0 );
	$breakintro  = $params->get( 'cnt_breakintro'   , 0 );


    $orderStr  = '';
    $fcols	   = '';
	$and       = '';
	$search    = '';
	$match	   = '';
	$catsql	   = '';
	$result    = Array();
	$now       = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	// No my own Content Item
	if ($contentid) {
		$and .= ' AND id != '.$contentid;
	}

	// ** PART RESTRICT FOR SECTION AND /OR CATEGORY

	// It will be need know Content Item SecID and CatID
	if ($contentid && ($mysec || $mycat) ) {

		$secid = $params->get("rib_secid",0);
		$catid = $params->get("rib_catid",0);

		// If not is set (How it could happend I don't know but for sure)
		// because its load in function botRelatedItemsGetById
		if ($secid==0 || $catid==0) {
			$tmpq = "SELECT sectionid as secid,catid FROM #__content WHERE id = ".$contentid." LIMIT 1";
			$database->setQuery( $tmpq );
			$tmp = $database->loadRow();
			$secid = $tmp[0];
			$catid = $tmp[1];
		}

		// CategorySection self Restrictions
		if ($mysec==1) {
    		$catsql = ' AND sectionid != '.$secid;
		}
		elseif($mysec==2) {
    		$catsql = ' AND sectionid = '.$secid;
		}
		elseif ($mycat==1) {
			$catsql = ' AND catid != '.$catid;
		}
		elseif ($mycat==2) {
			$catsql = ' AND catid = '.$catid;
		}
	}

	// Only (sec,cat) restrictions
	if ($onlysec) {
       $catsql .= " AND sectionid = ".$onlysec;
	}
	elseif($onlycat) {
       $catsql .= " AND catid = ".$onlycat;
	}

	// NOT (sec,cat) restrictions
	if ($restsec) {
       $catsql .= " AND sectionid NOT IN (".$restsec.") ";
	}
	elseif ($restcat) {
       $catsql .= " AND catid NOT IN ( ".$restcat.")";
	}

	// StaticContent 0 = yes, 1 = no, 2 = only
	if ($catsql) {
		switch ($static) {
			case 0:  $catsql .= " OR (sectionid=0 AND catid=0)"; break;
			case 1:  $catsql .= " AND NOT (sectionid=0 AND catid=0) "; break;
			case 2:  $catsql .= " AND (sectionid=0 AND catid=0) "; break;
		}
	}

	if ($catsql) {
		$catsql = " AND ( 1=1 ".$catsql." ) ";
	}

	// Archived content 0 = yes, 1 = no, 2 = only
	switch ($archived) {
		case 0:  $state = " ( state = 1 OR state = -1 ) "; break;
		case 2:  $state = " state = -1 "; break;
		case 1:
		default:  $state = " state = 1 "; break;
	}

    // ** PART SEARCH FOR SOME TEXT
    // If FULLTEXT is on
	if ($fulltext) {

		switch ($fulltext) {
			case 1: $fcols = " (`metakey`) "; break;
			case 2: $fcols = " (`introtext`) "; break;
			case 3: $fcols = " (`fulltext`) "; break;
			case 4: $fcols = " (`introtext`, `fulltext`) "; break;
			case 5: $fcols = " (`title`, `introtext`, `fulltext`) "; break;
		}

		// If fullcompare so use full arcticle instead metakeys
		if ($fullcompare) {
    		$match = " MATCH ".$fcols." AGAINST ('"._mosri_getFullCompare($contentid)."')";
    	}
    	else {
			$match = " MATCH ".$fcols." AGAINST ('".implode(" ",$words)."')";
    	}

		// If is set score limit
		if ($fullscore) {
    		$search = " AND ( ".$match." > ".abs($fullscore+0).") ";
    	}
    	else {
    		$search = " AND ( ".$match." ) \n";
    	}
    }

    // If not search normally in metakey and/or title
    else {

        $search .= " AND ";

    	if ($titletoo)  {
    		$search .= " ( ";
    	}

		$search .= " (metakey LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$search .= implode( "%' OR metakey LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$search .= "%')";

		if ($titletoo) {
			$search .= " OR (title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
			$search .= implode( "%' OR title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
			$search .= "%') )";
		}
	}

	// ** ALL THINGS NOW TOGETHER
	$query  = " SELECT id, title";

	if ($fulltext && $fullscoreon) {
		$query .= ",CONCAT(title,' [',".$match.",']') as title ";
	}
	else {
		$query .= ",title ";
	}

	if ($fulltext && $fullorder ) {
		$query .= "," .$match. " as score ";
	}

	if ($showintro) {
		if ($breakintro) {
			$query .= ", CONCAT('<br/>',introtext) as text ";
		}
		else {
			$query .= ", introtext as text ";
		}
	}

	$query .= " FROM #__content";
	$query .= " WHERE ".$state." AND access <=". ($my->gid) . $catsql. $and ;
	$query .= " AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now' ) ";
	$query .= " AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )  ";

	$query .= $search;

    // Ordering and limit
    switch ($order) {
    	case 'alpha':   $orderStr = ' title '; break;
    	case 'hits':    $orderStr = ' hits '; break;
    	case 'date':    $orderStr = ' created '; break;
    	case 'rdate':   $orderStr = ' created DESC'; break;
    	case 'seccat':  $orderStr = ' sectionid, catid '; break;
    	case 'random':  $orderStr = ' RAND(NOW()) ';break;
    	default:     	$orderStr = ' title '; break;
    }

	if ($fulltext && $fullorder) {
		$orderStr = ' score DESC, '.$orderStr;
	}

    $query .= ' ORDER BY '.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {

		if ($option=="com_content" && $task =="view") {
    		$Itemid = $mainframe->getItemid($row->id);
    	}

		$href = "index.php?option=com_content&task=view&id=".$row->id."&Itemid=".$Itemid;

		if ($showintro) {
			$result[] = Array("url"=>$href,"title"=>$row->title,"text"=>$row->text);
		}
		else {
			$result[] = Array("url"=>$href,"title"=>$row->title);
		}

	}

	return  $result;
}


// This function si used if fulltext is on
// Return Content Item content by defined ID, but only plain text without HTML tags
function _mosri_getFullCompare($id) {
    global $database;

    $q = "";
    $text = "";
    $known_bots = Array(
    	'#{moscode}(.*?){/moscode}#s',
		'/{mosimage\s*.*?}/i',
		'/{(mospagebreak)\s*(.*?)}/i',
		'/{mos_ri\s*.*?}/i',
		'/{moscomment}/i',
		'/{mosloadposition\s*.*?}/i',
		'/\r\n/'
    );

    // Load text
	$query = " SELECT introtext,`fulltext` FROM #__content WHERE id=".$id." LIMIT 1";

	$database->setQuery( $query );
	$res = $database->loadRow();

	// Strip HTML tags from it
	$text = strip_tags($res[0].$res[1]);

	if (!($text)) {
		return $text;
	}

    // Replace all bots tags
	foreach($known_bots as $regex) {
		$text = preg_replace( $regex, '', $text );
	}

	// Escape for DB, needed min PHP 4.0.3 version here, hope all have this
	// release date was 11 October 2000...
	if (version_compare(phpversion(),"4.3.0")== -1) {
		return mysql_escape_string($text);
    }
    else {
        return mysql_real_escape_string($text);
    }
}


?>