<?php
/**
* @version $Id: rib_events.inc.php, v1.0 2005/06/10  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka,Reinier Battenberg
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot Events (eve) 1.0			                            */
/* Search in Events and ExtCalandar items						*/

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* -> eve_coms [x,y] : x==Events,y==ExtCal Calendar; if (n>0) then com is show in n-th place order */
/* -> eve_showdesc  [Bool] : if x>0 its show after title description, maximum length of string is set to x */

function getRelatedEvents($contentid,$limit,$words,&$params){
	global $my, $database, $mosConfig_absolute_path,$mosConfig_offset;

	$sensitive = $params->get( 'sensitive'     , 0 );
	$coms	   = $params->get( 'eve_coms'      , 0 );
    $titletoo  = $params->get( 'eve_titletoo'  , 0 );
    $order	   = $params->get( 'eve_order' 	   , 0 );
    $sd        = $params->get( 'eve_showdesc'  , 0 );
	$old	   = $params->get( 'eve_showended' , 0 );

	$result    = Array();
	$query 	   = "";
	$column   = Array('','','');
	$comcount = 0;

	// Parse which compontent is switch on and installed too
    $types = explode(",",$coms);
    if (Count($types)!=2) {
    	$types = Array(0,0);
    }

    $filename[0] = "/components/com_events/events.php";
    $filename[1] = "/components/com_extcalendar/extcalendar.php";

	foreach ($filename as $key => $val) {
		if (!file_exists($mosConfig_absolute_path.$val)) {
			$types[$key] = 0;
		}
	}

    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );

	// ****************************
	// Events component
	// ****************************
	if ($types[0]!=0) {

      	$query .=  " SELECT ".$types[0]." as tmp,1 as com,e.title as title,e.id as id, c.title as ctitle ";
      	$query .=  ($sd != 0 ? ",SUBSTRING(e.content,1,".$sd.") as sd " : "");
      	$query .=  " FROM #__events as e INNER JOIN #__categories AS c ON  c.id = e.catid ";
       	$query .=  " LEFT JOIN #__sections AS s ON (s.id = e.sid AND e.sid!=0) ";
      	$query .=  " WHERE c.section='com_events' AND c.published = 1 ";
      	$query .=  " AND c.access <= ".$my->gid." AND e.state=1 AND e.access<=".$my->gid." AND ";

        if (!$old) {
        	 $query .= "  (e.publish_down >= '".$now."' AND reccurtype=0) AND  ";
       	}

        $query .= " ( ";

    	$query .= " (e.content LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    	$query .= implode( "%' OR e.content LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
    	$query .= "%')";

    	if ($titletoo) {
    		$query .= " OR  (e.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    		$query .= implode( "%' OR e.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words	 );
    		$query .= "%')";
    	}

    	$query .= " ) ";

    	$comcount++;
    }

    // ****************************
	// ExtCalendar component
	// ****************************
	if ($types[1]!=0) {

		if ($comcount)  {
		 	$query .= " UNION ";
		}

    	$query .= " SELECT ".$types[1]." as tmp,2 as com,e.title as title,e.extid as id,c.cat_name as ctitle ";
    	$query .=  ($sd != 0 ? ",SUBSTRING(e.description,1,".$sd.") as sd " : "");
    	$query .=  " FROM #__extcal_events AS e LEFT JOIN #__extcal_categories AS c ON (e.cat =c.cat_id ) ";
        $query .=  " WHERE c.published = 1 AND e.approved = 1 AND  ";

        if (!$old) {
        	 $query .= " (     (e.recur_type=''  AND e.end_date >= '".$now."') ";
        	 $query .= "    OR (e.recur_type<>'' AND e.recur_end_type=0)  ";
        	 $query .= "    OR (e.recur_type<>'' AND e.recur_end_type<>0 AND e.recur_until>'".$now."') ";
        	 $query .= " ) AND ";
       	}
		$query .= " ( ";

       	$query .= " (e.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    	$query .= implode( "%' OR e.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
    	$query .= "%')";

    	if ($titletoo) {
    		$query .= " OR (e.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    		$query .= implode( "%' OR e.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words	 );
    		$query .= "%')";
    	}
		$query .= " )";

		$comcount++;
	}


    switch ($order) {
    	case 'alpha':   $orderStr = ' e.title '; break;
    	case 'hits':    $orderStr = ' e.hits'; break;
    	case 'date':    $orderStr = ' e.publish_up '; break;
    	case 'seccat':  $orderStr = ' ctitle '; break;
    	case 'random':  $orderStr = ' RAND(NOW()) ';break;
    	default:     	$orderStr = ' e.title  '; break;
    }

    // For all - get order and limit
    $query .= ' ORDER BY '.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {

		switch ($row->com)  {
			case 1:  {
				$href = "index.php?option=com_events&task=view_detail&agid=".$row->id;
			break;
			}

			case 2: {
				$href = "index.php?option=com_extcalendar&extmode=view&extid=".$row->id;
			break;
			}
		}

		if ($sd!=0) {
			$result[] = Array("url"=>$href,"title"=>$row->title,"text"=>" - ".$row->sd);
		}
		else {
			$result[] = Array("url"=>$href,"title"=>$row->title);
		}
	}

	return  $result;
}


?>