<?php
/**
* @version $Id: rib_galleries.inc.php, v2.0 2005/07/29  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka, Reinier Battenberg
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot Galleries (gal) 2.0	 	                            */
/* Search in AkoGallery and rsGallery components		        */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* -> gal_coms [x,y,z] : x==AkoGallery,y==rsGallery,z==ZoomGallery; if (n>0) then com is show in n-th place order */
/* -> gal_showdesc	[int] - if > 0 show x characters image title after image */


function getRelatedGalleries($contentid,$limit,$words,&$params){
	global $mosConfig_absolute_path, $mosConfig_live_site, $database,
		   $my, $imagepath, $size, $ag_paththumbs, $zoomConfig;

	$sensitive = $params->get( 'sensitive'     , 0 );
	$coms	   = $params->get( 'gal_coms'      , 0 );
	$limit	   = $params->get( 'gal_limit'     , 0 );
    $titletoo  = $params->get( 'gal_titletoo'  , 0 );
    $order	   = $params->get( 'gal_order' 	   , 0 );
	$sd        = $params->get( 'gal_showdesc'  , 0 );
	$how       = $params->get( 'gal_how'       , 0 );
	$cattoo    = $params->get( 'gal_cattoo'    , 0 );

	$query	   = '';
	$result    = Array();
	$filename  = Array();
	$column    = Array('','','');
	$comcount  = 0;
	$sensitive = ($sensitive ? 'BINARY ' : '');


	// Parse which compontent is switched on and installed too
    $types = explode(",",$coms);
    if (Count($types)!=3) {
    	$types = Array(0,0,0);
    }

    $filename[0] = '/administrator/components/com_akogallery/config.akogallery.php';
    $filename[1] = '/administrator/components/com_rsgallery/settings.rsgallery.php';
    $filename[2] = '/components/com_zoom/zoom_config.php';

	foreach ($filename as $key => $val) {
		if (!file_exists($mosConfig_absolute_path.$val)) {
			$types[$key] = 0;
		}
		else {
			include_once $mosConfig_absolute_path.$val;
		}
	}

	// All components are set off or not installed
	if (!array_sum($types)) {
		return $result;
	}

	// Get order and list of needed columns (only for ordering use)
    switch ($order) {
    	case 'alpha':    $orderStr = ' title ';       break;
    	case 'random':   $orderStr = ' RAND(NOW()) '; break;
        case 'seccat':   $orderStr = ' secid,title '; break;

    	case 'hits':
    		$orderStr = ' hits DESC ';
    		$column[0] = ",w.imgcounter as hits";
    		$column[1] = ",w.hits as hits";
    		$column[2] = ",w.imghits as hits";
    	break;

    	case 'date':
    		$orderStr = ' date ';
    		$column[0] = ",w.imgdate as date";
    		$column[1] = ",w.date as date";
    		$column[2] = ",w.imgdate as date";

    	break;

    	case 'rdate':
    		$orderStr = ' date DESC';
    		$column[0] = ",w.imgdate as date";
    		$column[1] = ",w.date as date";
    		$column[2] = ",w.imgdate as date";
    	break;

    	default:   	$orderStr = ' title '; 	 break;
    }


	// ****************************
	// AkoGallery  component
	// ****************************
	if ($types[0]!=0) {

      	$query .=  "SELECT ".$types[0]." as tmp,0 as com,w.id, w.imgthumbname as name, w.imgtitle as title, w.catid as secid,w.metadesc as descr".$column[0]." \n";
    	$query .= " FROM #__categories AS c LEFT JOIN #__akogallery AS w ON w.catid = c.id\n";
    	$query .= " WHERE  w.published=1 ";
        $query .= " AND c.section='com_akogallery' AND c.published='1' AND c.access <= ".$my->gid."  \n";
       	$query .=  " AND (w.publish_up = '0000-00-00 00:00:00' OR w.publish_up <= NOW())\n";
      	$query .=  " AND (w.publish_down = '0000-00-00 00:00:00' OR w.publish_down >= NOW()) AND \n";

        if ($titletoo) {
        		$query .= " ( \n";
    	}

    	$query .= " (w.metakey LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    	$query .= implode( "%' OR w.metakey LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
    	$query .= "%')\n";

    	if ($titletoo) {
    		$query .= " OR (w.imgtitle LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
    		$query .= implode( "%' OR w.imgtitle LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words	 );
    		$query .= "%')\n )\n";
    	}

    	if ($cattoo) {
		    $query .= " UNION ";
			$query .= " SELECT ".($types[0]-0.1)." as tmp,0 as com,id,'__cat',title,0,description as descr";
			if ($column[0]) {
				$query .= ",0";
			}
			$query .= " FROM #__categories WHERE section='com_akogallery' AND  published='1'  AND access <= ".$my->gid." ";
			$query .= " AND ((description LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR description LIKE ". $sensitive."'%", $words );
    		$query .= "%')\n";
    		$query .= " OR (title LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR title LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n";
    		$query .= " OR (name LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR name LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n )\n";
    	}

		$comcount++;
    }

	// ****************************
	// RSGallery  component
	// ****************************

    if ($types[1]!=0) {

    	if ($comcount) {
		 	$query .= " UNION ";
		}

    	$query .=  "SELECT ".$types[1]." as tmp,1 as com,w.id as id, w.name, w.title as title, w.gallery_id as secid, w.descr as descr".$column[1]." \n";
		$query .= " FROM #__rsgallery AS c LEFT JOIN #__rsgalleryfiles AS w ON w.gallery_id = c.id \n";
		$query .= " WHERE c.published='1'  AND \n";

        if ($titletoo) {
        	$query .= " ( \n";
    	}
    	$query .= " (w.descr LIKE ". $sensitive." '%";
    	$query .= implode( "%' OR w.descr LIKE ". $sensitive."'%", $words );
    	$query .= "%')\n";

    	if ($titletoo) {
    		$query .= " OR (w.title LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR w.title LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n )\n";
    	}

    	if ($cattoo) {
		    $query .= " UNION ";
			$query .= " SELECT ".($types[1]-0.1)." as tmp,1 as com,id,'__cat',catname as title,0,description as descr";
			if ($column[1]) {
				$query .= ",0";
			}
			$query .= " FROM #__rsgallery WHERE published='1'  AND \n";
			$query .= " ((description LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR description LIKE ". $sensitive."'%", $words );
    		$query .= "%')\n";
    		$query .= " OR (catname LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR catname LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n )\n";
    	}

		$comcount++;
	}

    // zoomGallery
	if ($types[2]!=0) {

    	if ($comcount) {
		 	$query .= " UNION ";
		}

    	$query .=  "SELECT ".$types[2]." as tmp,2 as com,w.imgid as id, CONCAT(c.catdir,'/thumbs/',w.imgfilename) as name, w.imgname  as title, w.catid  as secid, w.imgdescr  as descr".$column[2]." \n";
		$query .= " FROM #__zoom AS c LEFT JOIN #__zoomfiles AS w ON w.catid = c.catid \n";
		$query .= " WHERE c.published='1'  AND ( \n";

    	$query .= " (w.imgdescr LIKE ". $sensitive." '%";
    	$query .= implode( "%' OR w.imgdescr LIKE ". $sensitive."'%", $words );
    	$query .= "%')\n";

        $query .= " OR (w.imgkeywords        LIKE ". $sensitive." '%";
    	$query .= implode( "%' OR w.imgkeywords        LIKE ". $sensitive."'%", $words );
    	$query .= "%')\n";

    	if ($titletoo) {
    		$query .= " OR (w.imgname  LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR w.imgname  LIKE ". $sensitive."'%", $words	 );
            $query .= "%')";
    	}
    	$query .= ")\n";


    	if ($cattoo) {
		    $query .= " UNION ";
			$query .= " SELECT ".($types[2]-0.1)." as tmp,2 as com,catid,'__cat',catname as title,0,catdescr  as descr";
			if ($column[2]) {
				$query .= ",0";
			}
			$query .= " FROM #__zoom WHERE published='1'  AND \n";
			$query .= " ( (catdescr  LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR catdescr  LIKE ". $sensitive."'%", $words );
    		$query .= "%')\n";
    		$query .= " OR (catname LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR catname LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n";
    		$query .= " OR (catkeywords  LIKE ". $sensitive." '%";
    		$query .= implode( "%' OR catkeywords  LIKE ". $sensitive."'%", $words	 );
    		$query .= "%')\n )\n";

    	}

		$comcount++;
	}

    $query .= ' ORDER BY tmp,'.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {
        $noway = 0;

		switch ($row->com)  {

			// AkoGallery
			case 0:

				// its category name
				if ($row->name=='__cat') {
					$ItemId = getMenuLink("com_akogallery", "catid", $row->id, "id", $row->id);
    				$href   = "index.php?option=com_akogallery&func=viewcategory&catid=".$row->id."&ItemId=".$ItemId;
                    $title = $row->title;
				}

                //its image
				else {

    				$ItemId = getMenuLink("com_akogallery", "catid", $row->secid, "id", $row->id);
    				$href  = "index.php?option=com_akogallery&func=detail&id=".$row->id.($ItemId ? "&ItemId=".$ItemId : '');

    				switch ($how) {
    					case 0:
    						$title = $row->title;
    					break;
    					case 1:
    					case 2:
    						$tmp  = $mosConfig_absolute_path.($how > 1 ? '' : $ag_paththumbs)."/".$row->name;
    						if (file_exists($tmp)) {
    							$title = '<img src="'.$tmp.'" border="0" title="'.$row->title.'"/>';
    						}
    						else {
    							$noway = 1;
    						}
    					break;
    				}
    			}
			break;

            // rsGallery
			case 1:

				// its category name
				if ($row->name=='__cat') {
					$ItemId = getMenuLink("com_rsgallery", "catid", $row->id, "id", $row->id);
    				$href   = "index.php?option=com_rsgallery&catid=".$row->id."&ItemId=".$ItemId;
                    $title = $row->title;
				}

				//its image
				else {
    			    $ItemId = getMenuLink("com_rsgallery", "catid", $row->secid, "id", $row->id);
    				$href   = "index.php?option=com_rsgallery&page=inline&limitstart=".($row->id-1)."&catid=". $row->secid."&id=".$row->id."&ItemId=".$ItemId;

    				switch ($how) {
    					case 0:
    						$title = $row->title;
    					break;

    					case 1:
    						$tmp  = $mosConfig_absolute_path.$imagepath.'thumbs/'.$row->name;
    						if (file_exists($tmp)) {
    							$title = '<img src="'.$mosConfig_live_site.$imagepath.'thumbs/'.$row->name.'" border="0" title="'.$row->title.'" width="'.$size.'" />';
    						}
    						else {
    							$noway = 1;
    						}
    					break;

    					case 2:
    						$tmp  = $mosConfig_absolute_path.$imagepath.$row->name;
    						if (file_exists($tmp)) {
    							$title = '<img src="'.$mosConfig_live_site.$imagepath.$row->name.'" border="0" title="'.$row->title.'"  />';
    						}
    						else {
    							$noway = 1;
    						}
    					break;
    				}
    			}
			break;

			// zoomGallery
			case 2:

				// its category name
				if ($row->name=='__cat') {
					$ItemId = getMenuLink("com_zoom", "catid", $row->id, "id", $row->id);
    				$href   = "index.php?option=com_zoom&catid=".$row->id."&ItemId=".$ItemId;
                    $title = $row->title;
				}

				//its image
				else {

    			    $ItemId = getMenuLink("com_zoom", "catid", $row->secid, "id", $row->id);
    			    $info = _mosri_getZoomID($row->secid,$row->id,$zoomConfig['PageSize']);
    				$href   = "index.php?option=com_zoom&page=view&catid=". $row->secid."&key=".$info[0]."&PageNo=".$info[1]."&hits=1&ItemId=".$ItemId;

    				switch ($how) {
    					case 0:
    						$title = $row->title;

    					break;

    					case 1:

    						$tmp  = $mosConfig_absolute_path."/".$zoomConfig['imagepath'].$row->name;
    						if (file_exists($tmp)) {
    							$title = '<img src="'.$mosConfig_live_site."/".$zoomConfig['imagepath'].$row->name.'" border="0" title="'.$row->title.'" width="'.$size.'" />';
    						}
    						else {
    							$noway = 1;
    						}
    					break;

    					case 2:
    						$tmp  = $mosConfig_absolute_path."/".$zoomConfig['imagepath'].Str_Replace('/thumbs','',$row->name);
    						if (file_exists($tmp)) {
    							$title = '<img src="'.$mosConfig_live_site."/".$zoomConfig['imagepath'].Str_Replace('/thumbs','',$row->name).'" border="0" title="'.$row->title.'"  />';
    						}
    						else {
    							$noway = 1;
    						}
    					break;
    				}
    			}
			break;
		}

        if (!$noway) {
			if ($sd) {
				$text     = SubStr($row->title, 0, $sd);
				$result[] = Array("url"=>$href,"title"=>$title,"text"=>" - ".$text);
			} else {
				$result[] = Array("url"=>$href,"title"=>$title);
			}
		}
	}

	return  $result;
}

// This function return Array with two int fields:
// [0] - key attribute for url
// [1] - PageNo attribute for url
function _mosri_getZoomID($catid,$id,$pagelimit) {
	global $database;

	$query = "SELECT (COUNT(imgid)-1) FROM #__zoomfiles WHERE published=1 and catid=".$catid." AND imgid<=".$id." GROUP BY catid ORDER BY imgid DESC ";
	$database->setQuery( $query );
	$row = $database->loadRow();

	return Array($row[0], ($row[0] - (($row[0]) % $pagelimit)+0)+1 );
}

?>