<?php
/**
* @version $Id: mainmenu.inc.php, v1.0 2005/06/10  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot MainMenu (mnu) 1.0		                        	*/
/* Search in all core menus of your Mambo site                   */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* --> mnu_content [bool] : if TRUE don't search for content items links */
/* --> mnu_weblink [bool] : if TRUE don't search for weblinks/nxtlinks links */
/* --> mnu_onlymenu [mos_menu_name] : if not "" restrict search in selected Mos_menu only */

function getRelatedMainMenu($contentid,$limit,$words,&$params) {
	global $my,$database,$mosConfig_shownoauth;

    $sensitive = $params->get( 'sensitive'   , 0 );
    $order	   = $params->get( 'mnu_order'   , 0 );
    $conttoo   = $params->get( 'mnu_content' , 0 );
    $wbltoo    = $params->get( 'mnu_weblink' , 0 );
    $only	   = $params->get( 'mnu_onlymenu', '');

    $orderStr  = '';
	$result    = Array();

	$query = "SELECT  name,link FROM #__menu WHERE published=1 ";

	if (!$mosConfig_shownoauth) {
        $query .= " AND access <= '$my->gid' ";
	}

	if (!$conttoo) {
		$query .= ' AND type NOT IN ("content_typed","content_item_link") ';
	}

	if (!$wbltoo) {
		$query .= ' AND link NOT LIKE "%option=com_weblinks%" ';
		$query .= ' AND link NOT LIKE "%option=com_nxtlinks%" ';
	}

	if ($only) {
		$query .= " AND menutype='".$only."' ";
	}

	$query .= " AND (name LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
	$query .= implode( "%' OR name LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
	$query .= "%')";

    switch ($order) {
    	case 'alpha':    $orderStr = ' name '; break;
    	case 'ordering': $orderStr = ' ordering '; break;
    	case 'random':   $orderStr = ' RAND(NOW()) ';break;
    	default:     	 $orderStr = ' name '; break;
    }

    $query .= ' ORDER BY '.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {
        $result[] = Array("url"=>$row->link,"title"=>$row->name);
	}

	return  $result;
}
?>