<?php
/**
* @version $Id: contentitems.inc.php, v1.01 2005/06/06  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot Remository (rem) 1.01			                    */
/* Search in Remository files 							        */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* rem_showfilesize [bool] - if TRUE show file size after link */
/* rem_showdesc	[int] - if >0 show x char file description after link */


function getRelatedRemository($contentid,$limit,$words,&$params){
	global $my,$database,$ItemId,$mosConfig_absolute_path;

    $sensitive = $params->get( 'sensitive'   , 0 );
    $order	   = $params->get( 'rem_order'   , 0 );
    $titletoo  = $params->get( 'rem_titletoo'  , 1 );
    $sd        = $params->get( 'rem_showdesc'  , 0 );
    $fs        = $params->get( 'rem_showfilesize'  , 0 );
    $orderStr  = '';
	$result    = Array();

    $filename = $mosConfig_absolute_path."/components/com_remository/remository.php";

	// If Remository is installed
	if (!file_exists($filename)) {
		return $result;
	}

	$query  = " SELECT d.id,d.catid,d.filename as title,dc.name as catname,f.name as folname ";

	if ($sd) {
		$query .= ", d.description as description ";
	}

	if ($fs) {
		$query .= ", d.filesize as filesize";
	}

	if ($order=="rating") {
		$query .= ",r.rating as rating";
	}
	$query .= " FROM #__downloads as d ";
	$query .= " LEFT JOIN #__downloads_category as dc ON (d.catid = dc.id OR d.catid=0)";
	$query .= " LEFT JOIN #__downloads_folders as f ON (d.folderid = f.id OR d.folderid = 0)";

	if ($order=="rating") {
		$query .= " LEFT JOIN #__downloads_votes as r ON r.id = d.id ";
	}

	$query .= " WHERE d.published=1 AND "; //dc.registered <=".$my->gid." AND f.registered <=".$my->gid." AND ";

    if ($titletoo) {
    	$query .= " ( ";
    }

	$query .= " (d.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
	$query .= implode( "%' OR d.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
	$query .= "%')";

	if ($titletoo) {
		$query .= " OR (d.filename LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR d.filename LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%') )";
	}

    switch ($order) {
    	case 'alpha':    $orderStr = ' d.filename '; break;
    	case 'hits':     $orderStr = ' d.downloads DESC'; break;
    	case 'date':     $orderStr = ' d.submitdate'; break;
    	case 'dater':    $orderStr = ' d.submitdate DESC'; break;
    	case 'seccat':   $orderStr = ' folname,catname'; break;
    	case 'rating':   $orderStr = ' rating DESC'; break;
    	case 'random':   $orderStr = ' RAND(NOW()) ';break;
    	default:     	 $orderStr = ' d.filename '; break;
    }

    $query .= ' ORDER BY '.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {
		$ItemId = getMenuLink("com_remository", "cat", $row->catid, "filecatid", $row->id);

		$text = (isSet($row->filesize) ? ' ('.$row->filesize.') ' : '');

		if ($sd) {
			$text .= (isSet($row->description) ? '  '.substr($row->description,0,$sd) : '');
		}

		$url  = 'index.php?option=com_remository'.($ItemId ? '&amp;Itemid='.$ItemId : '');
		$url .= '&amp;func=fileinfo&amp;filecatid='.$row->id.'&amp;parent=category';

        if ($text!="") {
			$result[] = Array("url"=>$url,"title"=>$row->title,"text"=>" - ".$text);
		}
		else {
			$result[] = Array("url"=>$url,"title"=>$row->title);
		}
	}

	return  $result;
}

?>
