<?php
/**
* @version $Id: sectioncategories.inc.php, v1.0 2005/06/10 $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/* MiniBot SectionCategories (cat) 1.0		                  	*/
/* Search in all Mambo Section and Categories                   */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* --> cat_mysec [bool] : if TRUE don't search in self section for any categories of viewed/searched Item */


function getRelatedSectionCategories($contentid,$limit,$words,&$params){
	global $my,$database,$mosConfig_shownoauth,$mosConfig_offset;

    $sensitive = $params->get( 'sensitive' , 0 );
    $order	   = $params->get( 'cat_order' , 0 );
    $mysec	   = $params->get( 'cat_mysec' , 1 );
	$scsep     = $params->get( 'cat_separator' , '' );

	// It will be need know CItem SecID
	if (!$mysec && $contentid){
		$secid = $params->get("rib_secid",0);
		if ($secid==0) {
			$tmpq = "SELECT sectionid as secid FROM #__content WHERE id = ".$contentid." LIMIT 1";
			$database->setQuery( $tmpq );
			$tmp = $database->loadObjectList();
			$secid = $tmp[0]->secid;
		}
	}

    $orderStr  = '';
    $query     = '';
	$result    = Array();
    $now       = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );

	// Section part

	$query  =  " SELECT  1 as tmp,a.id as id,a.title as title,'' as ctitle,COUNT(b.id) as cnt ";
	$query .=  " FROM #__sections as a LEFT JOIN #__content as b ON a.id=b.sectionid ";
	$query .=  " WHERE  a.published=1 ";
	$query .=  " AND (b.publish_up = '0000-00-00 00:00:00' OR b.publish_up <= '". $now ."' )";
	$query .=  " AND (b.publish_down = '0000-00-00 00:00:00' OR b.publish_down >= '". $now ."' )";
	$query .=  " AND a.scope='content' ";

	if (!$mosConfig_shownoauth) {
        $query .= " AND a.access <= ".$my->gid."  AND b.access <= ".$my->gid;
	}

	if (!$mysec && $contentid) {
		$query .= ' AND b.id != '.$contentid.' AND b.sectionid != '.$secid;
	}
	elseif ($contentid) {
		$query .= ' AND b.id != '.$contentid;
	}

	$query .= " AND ( ";

		$query .= " (a.name LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR a.name LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		$query .= " OR (a.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR a.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		$query .= " OR (a.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR a.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

	$query .= " )";
	$query .= " GROUP BY a.id HAVING COUNT(b.id)>0 ";

	// Category part

	$query .= " UNION ALL ";

	$query .=  " SELECT  2 as tmp,a.id as id,a.title as title, c.title as ctitle,COUNT(b.id) as cnt ";
	$query .=  " FROM #__sections as a LEFT JOIN #__content as b ON a.id=b.sectionid ";
	$query .=  " LEFT JOIN #__categories as c ON c.section=a.id ";
	$query .=  " WHERE  a.published=1 AND c.published=1 ";
	$query .=  " AND (b.publish_up = '0000-00-00 00:00:00' OR b.publish_up <= '". $now ."' )";
	$query .=  " AND (b.publish_down = '0000-00-00 00:00:00' OR b.publish_down >= '". $now ."' )";
	$query .=  " AND a.scope='content' ";

	if (!$mosConfig_shownoauth) {
        $query .= " AND a.access <= ".$my->gid." AND b.access <= ".$my->gid." AND c.access <= ".$my->gid;
	}

	if (!$mysec && $contentid) {
		$query .= ' AND b.id != '.$contentid.' AND b.sectionid != '.$secid;
	}
	elseif ($contentid) {
		$query .= ' AND b.id != '.$contentid;
	}

	$query .= " AND ( ";

		$query .= " (c.name LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR c.name LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		$query .= " OR (c.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR c.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		$query .= " OR (c.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR c.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

    $query .= " )";

    $query .= " GROUP BY a.id HAVING COUNT(b.id)>0 ";


    switch ($order) {
    	case 'alpha':    $orderStr = ' title '; break;
    	case 'ordering': $orderStr = ' a.ordering '; break;
    	case 'random':   $orderStr = ' RAND(NOW()) ';break;
    	default:     	 $orderStr = ' title '; break;
    }

    $query .= ' ORDER BY '.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {
		if ($row->tmp==1) {
			$url = sefRelToAbs("index.php?option=com_content&task=blogsection&id=".$row->id);
        	$result[] = Array("url"=>$url,"title"=>$row->title);
    	}
    	else {
    		$url = sefRelToAbs("index.php?option=com_content&task=blogscategory&id=".$row->id);
        	$result[] = Array("url"=>$url,"title"=>$row->title.$scsep.$row->ctitle);
    	}
	}

	return  $result;
}
?>