<?php
/**
* @version $Id: weblinks.inc.php, v1.1 2005/07/26  $
* @package Mambo_4.5.X
* @copyright (C) 2005 Tomas Hanzelka
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Lot of code in section 'Bookmarks' is used from:
* project Bookmarks, bookmarks.searchbot.php, v2.6_12 2005/05/29 16:52:31 by DJesus
*
*/

/* MiniBot Weblinks (wbl) 1.1             */
/* Search in Weblinks and NXTLinks Components */

/* This is part for Related Items Bot		      	            */
/* Project pages http://mamboforge.net/projects/relateditembot/ */

/* Special options: */
/* -> wbl_coms [x,y,z] : x==Weblinks,y==NXTlinks,z==Bookmarks; if (n>0) then com is show in n-th place order */
/* -> wbl_showdesc  [Bool] : if x>0 its show after title description, maximum length of string is set to x */

function getRelatedWeblinks($contentid,$limit,$words,&$params) {
    global $my,$database,$mosConfig_absolute_path;

    $sensitive = $params->get( 'sensitive'     , 0 );
    $coms	   = $params->get( 'wbl_coms'      , 0 );
    $titletoo  = $params->get( 'wbl_titletoo'  , 1 );
    $order	   = $params->get( 'wbl_order' 	   , 'alpha' );
    $sd        = $params->get( 'wbl_showdesc'  , 0 );
    $target	   = $params->get( 'wbl_target'    , 'default' );

    $orderStr = '';
	$query 	  = '';
	$result   = Array();
	$filename = Array();
	$column   = Array('','','');
	$comcount = 0;

	// Parse which compontent is switched on and installed too
    $types = explode(",",$coms);
    if (Count($types)!=3) {
    	$types = Array(0,0,0);
    }

    $filename[0] = "/components/com_weblinks/weblinks.php";
    $filename[1] = "/components/com_nxtlinks/nxtlinks.php";
    $filename[2] = "/components/com_bookmarks/bookmarks.php";

	foreach ($filename as $key => $val) {
		if (!file_exists($mosConfig_absolute_path.$val)) {
			$types[$key] = 0;
		}
	}

	if (!array_sum($types)) {
		return $result;
	}

    // Get order and list of needed columns (only for ordering use)
    switch ($order) {
    	case 'alpha':    $orderStr = ' title ';       break;
    	case 'random':   $orderStr = ' RAND(NOW()) '; break;
        case 'seccat':   $orderStr = ' catid,title '; break;

    	case 'hits':
    		$orderStr = ' hits DESC ';
    		$column[0] = ",w.hits as hits";
    		$column[1] = ",w.hits as hits";
    		$column[2] = ",w.hits as hits";
    	break;

    	case 'date':
    		$orderStr = ' date ';
    		$column[0] = ",w.date as date";
    		$column[1] = ",w.date as date";
    		$column[2] = ",w.created as hits";
    	break;

    	case 'rdate':
    		$orderStr = ' date DESC';
    		$column[0] = ",w.date as date";
    		$column[1] = ",w.date as date";
    		$column[2] = ",w.created as hits";
    	break;

    	case 'ordering':
    		$orderStr = ' catid, ordering ';
    		$column[0] = ",w.ordering as ordering";
    		$column[1] = ",w.ordering as ordering";
    		$column[2] = ",i.ordering as ordering";
    	break;

    	default:   		$orderStr = ' title '; 	 break;
    }

    // ****************************
	// Weblinks Std Mambo component
	// ****************************
	if ($types[0]!=0) {
		$query .= " SELECT ".$types[0]." as tmp,1 as com,w.title as title,w.url as url,w.id as id,w.catid as catid".$column[0];
		$query .= ($sd != 0 ? ",SUBSTRING(w.description,1,".$sd.") as sd " : "");
		$query .= " FROM #__categories AS c LEFT JOIN #__weblinks AS w ON w.catid = c.id";
		$query .= " WHERE w.archived=0 AND w.approved=1 AND w.published=1 ";
        $query .= " AND c.section='com_weblinks' AND c.published='1' AND c.access <= ".$my->gid." AND ";

    	if ($titletoo) $query .= " ( ";
		$query .= " (w.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR w.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		if ($titletoo) {
			$query .= " OR (w.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
			$query .= implode( "%' OR w.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
			$query .= "%') )";
		}

		$comcount++;
	}


    // *******************
    // NXTLinks component
    // *******************
	if ($types[1]!=0) {

		 if ($comcount)  {
		 	$query .= " UNION ";
		 }
		 $query .= " SELECT ".$types[1]." as tmp,2 as com,w.title as title,w.url as url ,w.id as id,w.catid as catid".$column[1];
    	 $query .= ($sd != 0 ? ",SUBSTRING(w.description,1,".$sd.") as sd " : "");
    	 $query .= " FROM #__menu AS c LEFT JOIN #__nxtlinks AS w ON w.catid = c.id";
    	 $query .= " WHERE w.archived=0 AND w.approved=1 AND w.published=1";
         $query .= " AND c.menutype='nxtlinks' AND c.published='1' AND c.access <= ".$my->gid." AND ";

    	 if ($titletoo) $query .= " ( ";
		 $query .= "  (w.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		 $query .= implode( "%' OR w.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		 $query .= "%')";

		 if ($titletoo) {
		 	$query .= " OR (w.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		 	$query .= implode( "%' OR w.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		 	$query .= "%') )";
		 }

		 $comcount++;
	}


    // *******************
    // Bookmarks component
	// *******************
	if ($types[2]!=0) {

		if ($comcount) {
		 	$query .= " UNION ";
		}

     	// Com Bookmarks has its own catgories to search
   		$database->setQuery( "SELECT CONCAT('f_',c.name) as fname, c.*"
                    . "\n FROM #__bookmarks_columns AS c"
                    . "\n WHERE c.category = '' AND c.custom = '1'"
                    . "\n AND f_type IN ('1','2','6','7')"
                    . "\n ORDER BY c.ordering"
   		);

   		$fields =  $database->loadObjectList();

        // Main SQL
		$query .= " SELECT ".$types[2]." as tmp,3 as com,w.title as title,w.url as url, w.id as id,i.catid as catid".$column[2];
		$query .= ($sd != 0 ? ",SUBSTRING(w.description,1,".$sd.") as sd " : "");
        $query .= " FROM #__bookmarks_categories AS bc";
        $query .= " LEFT JOIN #__bookmarks_itemcat AS i ON i.catid = bc.id";
        $query .= " LEFT JOIN #__bookmarks AS w ON w.id = i.itemid";

        $query .= " WHERE (w.published=1 AND w.approved=1)";
        $query .= " AND (bc.published=1 AND bc.access<=$my->gid)";
        $query .= " AND ( (w.private=0) OR (w.private=1 AND w.created_by = ".$my->id.") )";

		$query .= " AND ( ";

		$query .= " (w.description LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR w.description LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		$query .= " OR (w.detail LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
		$query .= implode( "%' OR w.detail LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
		$query .= "%')";

		foreach ($fields as $field) {
			$query .= " OR  (w.".$field->fname." LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
			$query .= implode( "%' OR w.".$field->fname." LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
			$query .= "%')";
        }

		if ($titletoo) {
			$query .= " OR (w.title LIKE ". ($sensitive ? 'BINARY ' : '')." '%";
			$query .= implode( "%' OR w.title LIKE ". ($sensitive ? 'BINARY ' : '')."'%", $words );
			$query .= "%')";
		}

		$query .= " )";

		$comcount++;
	}

    // For all - get order and limit
    $query .= ' ORDER BY tmp,'.$orderStr;

    if ($limit) {
		$query .= ' LIMIT '.$limit;
	}

	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	if (!$rows)  {
		return $result;
	}

	foreach ($rows as $row ) {

		switch ($row->com)  {

			case 1:  {
				$url = "index.php?option=com_weblinks&amp;task=view&amp;catid=".$row->catid."&amp;id=".$row->id;
			break;
			}

			case 2: {
				$url = "index.php?option=com_nxtlinks&amp;task=view&amp;catid=".$row->catid."&amp;id=".$row->id;
			break;
			}

			case 3: {
				$url = "index.php?option=com_bookmarks&task=view&id=" . $row->id;
			break;
			}
		}

		if ($sd) {
			$result[] = Array("url"=>$url,"title"=>$row->title,"text"=>" - ".$row->sd);
		}
		else {
			$result[] = Array("url"=>$url,"title"=>$row->title);
		}

	}

	return  $result;
}

?>