

# Contributing to phpList

:+1::tada: Many thanks for taking the time to contribute! :tada::+1:


# Reporting an Issue

You can report and issue here in Github, or use our issue tracker at https://mantis.phplist.com
At this stage (March 2015), most issues are in Mantis, and it may be best to check around to see if your issue has been reported before.

Please follow the guidelines below when creating an issue so that your issue can be more promptly resolved:

* Provide information including: the version of PHP and phpList, the type of operating system and Web server, MySQL version, browser type and version;
* Provide the **complete** error call stack if available. A screenshot to explain the issue is very welcome.
* Describe the steps for reproducing the issue. 
* If possible try to reproduce this error on our demo at http://demo.phplist.com/lists/admin/

**Do not report an issue if**

* you are asking how to use some feature. You should use [the community](http://community.phplist.com) for this purpose.
* your issue is about security. Please [contact us directly](mailto:info@phplist.com) to report security issues.

**Avoid duplicated issues**

Before you report an issue, please search through [existing issues](https://mantis.phplist.com) to see if your issue is already reported or fixed to make sure you are not reporting a duplicated issue. 
Also make sure you have the latest version of phpList and see if the issue still exists.


# Contribute to the core code or fix bugs (Pull Requests)

Third-party patches are essential for keeping phpList great. 
We want to keep it as easy as possible to contribute changes that get things working in your environment. 
There are a few guidelines that we need contributors to follow so that we can have a chance of keeping on top of things.

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Fork the repository on GitHub
* Before we can accept your patches, you'll have to sign the Contributors License Agreement 
  * https://www.phplist.com/cla
* Make sure there is an issue created for the thing you are working on if it requires signifcant effort to fix
* Open a pull request 



